/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.source;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.seatunnel.api.common.JobContext;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.source.Boundedness;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.common.constants.JobMode;
import org.apache.seatunnel.connectors.seatunnel.common.source.AbstractSingleSplitReader;
import org.apache.seatunnel.connectors.seatunnel.common.source.AbstractSingleSplitSource;
import org.apache.seatunnel.connectors.seatunnel.common.source.SingleSplitReaderContext;
import org.apache.seatunnel.connectors.seatunnel.source.Web3jSourceParameter;
import org.apache.seatunnel.connectors.seatunnel.source.Web3jSourceReader;

public class Web3jSource
extends AbstractSingleSplitSource<SeaTunnelRow> {
    private Web3jSourceParameter parameter;
    private JobContext jobContext;

    public Web3jSource(ReadonlyConfig readonlyConfig) {
        this.parameter = new Web3jSourceParameter(readonlyConfig);
    }

    public Boundedness getBoundedness() {
        return JobMode.BATCH.equals((Object)this.jobContext.getJobMode()) ? Boundedness.BOUNDED : Boundedness.UNBOUNDED;
    }

    public String getPluginName() {
        return "Web3j";
    }

    public void setJobContext(JobContext jobContext) {
        this.jobContext = jobContext;
    }

    public List<CatalogTable> getProducedCatalogTables() {
        return Collections.singletonList(CatalogTable.of((TableIdentifier)TableIdentifier.of((String)"Web3j", (TablePath)TablePath.DEFAULT), (TableSchema)TableSchema.builder().column((Column)PhysicalColumn.of((String)"value", (SeaTunnelDataType)BasicType.STRING_TYPE, (Long)0L, (boolean)true, null, (String)"")).build(), new HashMap(), new ArrayList(), (String)""));
    }

    @Override
    public AbstractSingleSplitReader<SeaTunnelRow> createReader(SingleSplitReaderContext readerContext) throws Exception {
        return new Web3jSourceReader(this.parameter, readerContext);
    }
}

