/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.single;

import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.SingleObserver;
import io.reactivex.SingleSource;
import io.reactivex.annotations.Nullable;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.observers.BasicIntQueueDisposable;
import java.util.Iterator;

public final class SingleFlatMapIterableObservable<T, R>
extends Observable<R> {
    final SingleSource<T> source;
    final Function<? super T, ? extends Iterable<? extends R>> mapper;

    public SingleFlatMapIterableObservable(SingleSource<T> source2, Function<? super T, ? extends Iterable<? extends R>> mapper) {
        this.source = source2;
        this.mapper = mapper;
    }

    @Override
    protected void subscribeActual(Observer<? super R> observer) {
        this.source.subscribe(new FlatMapIterableObserver<T, R>(observer, this.mapper));
    }

    static final class FlatMapIterableObserver<T, R>
    extends BasicIntQueueDisposable<R>
    implements SingleObserver<T> {
        private static final long serialVersionUID = -8938804753851907758L;
        final Observer<? super R> downstream;
        final Function<? super T, ? extends Iterable<? extends R>> mapper;
        Disposable upstream;
        volatile Iterator<? extends R> it;
        volatile boolean cancelled;
        boolean outputFused;

        FlatMapIterableObserver(Observer<? super R> actual, Function<? super T, ? extends Iterable<? extends R>> mapper) {
            this.downstream = actual;
            this.mapper = mapper;
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onSuccess(T value) {
            boolean has;
            Iterator<R> iterator2;
            Observer<R> a = this.downstream;
            try {
                iterator2 = this.mapper.apply(value).iterator();
                has = iterator2.hasNext();
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.downstream.onError(ex);
                return;
            }
            if (!has) {
                a.onComplete();
                return;
            }
            if (!this.outputFused) {
                boolean b;
                do {
                    R v;
                    if (this.cancelled) {
                        return;
                    }
                    try {
                        v = iterator2.next();
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        a.onError(ex);
                        return;
                    }
                    a.onNext(v);
                    if (this.cancelled) {
                        return;
                    }
                    try {
                        b = iterator2.hasNext();
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        a.onError(ex);
                        return;
                    }
                } while (b);
                a.onComplete();
                return;
            }
            this.it = iterator2;
            a.onNext(null);
            a.onComplete();
        }

        @Override
        public void onError(Throwable e) {
            this.upstream = DisposableHelper.DISPOSED;
            this.downstream.onError(e);
        }

        @Override
        public void dispose() {
            this.cancelled = true;
            this.upstream.dispose();
            this.upstream = DisposableHelper.DISPOSED;
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        @Override
        public int requestFusion(int mode) {
            if ((mode & 2) != 0) {
                this.outputFused = true;
                return 2;
            }
            return 0;
        }

        @Override
        public void clear() {
            this.it = null;
        }

        @Override
        public boolean isEmpty() {
            return this.it == null;
        }

        @Override
        @Nullable
        public R poll() throws Exception {
            Iterator<R> iterator2 = this.it;
            if (iterator2 != null) {
                R v = ObjectHelper.requireNonNull(iterator2.next(), "The iterator returned a null value");
                if (!iterator2.hasNext()) {
                    this.it = null;
                }
                return v;
            }
            return null;
        }
    }
}

