/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Predicate;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;

public final class ObservableSkipWhile<T>
extends AbstractObservableWithUpstream<T, T> {
    final Predicate<? super T> predicate;

    public ObservableSkipWhile(ObservableSource<T> source2, Predicate<? super T> predicate) {
        super(source2);
        this.predicate = predicate;
    }

    @Override
    public void subscribeActual(Observer<? super T> observer) {
        this.source.subscribe(new SkipWhileObserver<T>(observer, this.predicate));
    }

    static final class SkipWhileObserver<T>
    implements Observer<T>,
    Disposable {
        final Observer<? super T> downstream;
        final Predicate<? super T> predicate;
        Disposable upstream;
        boolean notSkipping;

        SkipWhileObserver(Observer<? super T> actual, Predicate<? super T> predicate) {
            this.downstream = actual;
            this.predicate = predicate;
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void dispose() {
            this.upstream.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }

        @Override
        public void onNext(T t) {
            if (this.notSkipping) {
                this.downstream.onNext(t);
            } else {
                boolean b;
                try {
                    b = this.predicate.test(t);
                }
                catch (Throwable e) {
                    Exceptions.throwIfFatal(e);
                    this.upstream.dispose();
                    this.downstream.onError(e);
                    return;
                }
                if (!b) {
                    this.notSkipping = true;
                    this.downstream.onNext(t);
                }
            }
        }

        @Override
        public void onError(Throwable t) {
            this.downstream.onError(t);
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
        }
    }
}

