/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.maybe;

import io.reactivex.Flowable;
import io.reactivex.MaybeObserver;
import io.reactivex.MaybeSource;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.fuseable.HasUpstreamMaybeSource;
import io.reactivex.internal.subscriptions.DeferredScalarSubscription;
import org.reactivestreams.Subscriber;

public final class MaybeToFlowable<T>
extends Flowable<T>
implements HasUpstreamMaybeSource<T> {
    final MaybeSource<T> source;

    public MaybeToFlowable(MaybeSource<T> source2) {
        this.source = source2;
    }

    @Override
    public MaybeSource<T> source() {
        return this.source;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        this.source.subscribe(new MaybeToFlowableSubscriber<T>(s));
    }

    static final class MaybeToFlowableSubscriber<T>
    extends DeferredScalarSubscription<T>
    implements MaybeObserver<T> {
        private static final long serialVersionUID = 7603343402964826922L;
        Disposable upstream;

        MaybeToFlowableSubscriber(Subscriber<? super T> downstream) {
            super(downstream);
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onSuccess(T value) {
            this.complete(value);
        }

        @Override
        public void onError(Throwable e) {
            this.downstream.onError(e);
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
        }

        @Override
        public void cancel() {
            super.cancel();
            this.upstream.dispose();
        }
    }
}

