/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.completable;

import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.CompletableSource;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.completable.CompletableMergeDelayErrorArray;
import io.reactivex.internal.util.AtomicThrowable;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;

public final class CompletableMergeDelayErrorIterable
extends Completable {
    final Iterable<? extends CompletableSource> sources;

    public CompletableMergeDelayErrorIterable(Iterable<? extends CompletableSource> sources) {
        this.sources = sources;
    }

    @Override
    public void subscribeActual(CompletableObserver observer) {
        Iterator<? extends CompletableSource> iterator2;
        CompositeDisposable set = new CompositeDisposable();
        observer.onSubscribe(set);
        try {
            iterator2 = ObjectHelper.requireNonNull(this.sources.iterator(), "The source iterator returned is null");
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            observer.onError(e);
            return;
        }
        AtomicInteger wip = new AtomicInteger(1);
        AtomicThrowable error = new AtomicThrowable();
        while (true) {
            CompletableSource c;
            boolean b;
            if (set.isDisposed()) {
                return;
            }
            try {
                b = iterator2.hasNext();
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                error.addThrowable(e);
                break;
            }
            if (!b) break;
            if (set.isDisposed()) {
                return;
            }
            try {
                c = ObjectHelper.requireNonNull(iterator2.next(), "The iterator returned a null CompletableSource");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                error.addThrowable(e);
                break;
            }
            if (set.isDisposed()) {
                return;
            }
            wip.getAndIncrement();
            c.subscribe(new CompletableMergeDelayErrorArray.MergeInnerCompletableObserver(observer, set, error, wip));
        }
        if (wip.decrementAndGet() == 0) {
            Throwable ex = error.terminate();
            if (ex == null) {
                observer.onComplete();
            } else {
                observer.onError(ex);
            }
        }
    }
}

