/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.format.json;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.table.type.ArrayType;
import org.apache.seatunnel.api.table.type.MapType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.api.table.type.SqlType;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.common.utils.DateTimeUtils;
import org.apache.seatunnel.common.utils.DateUtils;
import org.apache.seatunnel.common.utils.JsonUtils;
import org.apache.seatunnel.format.json.exception.SeaTunnelJsonFormatException;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.JsonNode;

public class JsonToRowConverters
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final DateTimeFormatter TIME_FORMAT = new DateTimeFormatterBuilder().appendPattern("HH:mm:ss").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).toFormatter();
    public static final String FORMAT = "Common";
    private final boolean failOnMissingField;
    private final boolean ignoreParseErrors;
    public Map<String, DateTimeFormatter> fieldFormatterMap = new HashMap<String, DateTimeFormatter>();

    public JsonToRowConverters(boolean failOnMissingField, boolean ignoreParseErrors) {
        this.failOnMissingField = failOnMissingField;
        this.ignoreParseErrors = ignoreParseErrors;
    }

    public JsonToObjectConverter createConverter(SeaTunnelDataType<?> type) {
        return this.wrapIntoNullableConverter(this.createNotNullConverter(type));
    }

    private JsonToObjectConverter createNotNullConverter(SeaTunnelDataType<?> type) {
        SqlType sqlType = type.getSqlType();
        switch (sqlType) {
            case NULL: {
                return new JsonToObjectConverter(){

                    @Override
                    public Object convert(JsonNode jsonNode, String fieldName) {
                        return null;
                    }
                };
            }
            case BOOLEAN: {
                return new JsonToObjectConverter(){

                    @Override
                    public Object convert(JsonNode jsonNode, String fieldName) {
                        return JsonToRowConverters.this.convertToBoolean(jsonNode);
                    }
                };
            }
            case TINYINT: {
                return new JsonToObjectConverter(){

                    @Override
                    public Object convert(JsonNode jsonNode, String fieldName) {
                        return Byte.parseByte(jsonNode.asText().trim());
                    }
                };
            }
            case SMALLINT: {
                return new JsonToObjectConverter(){

                    @Override
                    public Object convert(JsonNode jsonNode, String fieldName) {
                        return Short.parseShort(jsonNode.asText().trim());
                    }
                };
            }
            case INT: {
                return new JsonToObjectConverter(){

                    @Override
                    public Object convert(JsonNode jsonNode, String fieldName) {
                        return JsonToRowConverters.this.convertToInt(jsonNode);
                    }
                };
            }
            case BIGINT: {
                return new JsonToObjectConverter(){

                    @Override
                    public Object convert(JsonNode jsonNode, String fieldName) {
                        return JsonToRowConverters.this.convertToLong(jsonNode);
                    }
                };
            }
            case DATE: {
                return new JsonToObjectConverter(){

                    @Override
                    public Object convert(JsonNode jsonNode, String fieldName) {
                        return JsonToRowConverters.this.convertToLocalDate(jsonNode, fieldName);
                    }
                };
            }
            case TIME: {
                return new JsonToObjectConverter(){

                    @Override
                    public Object convert(JsonNode jsonNode, String fieldName) {
                        return JsonToRowConverters.this.convertToLocalTime(jsonNode);
                    }
                };
            }
            case TIMESTAMP: {
                return new JsonToObjectConverter(){

                    @Override
                    public Object convert(JsonNode jsonNode, String fieldName) {
                        return JsonToRowConverters.this.convertToLocalDateTime(jsonNode, fieldName);
                    }
                };
            }
            case FLOAT: {
                return new JsonToObjectConverter(){

                    @Override
                    public Object convert(JsonNode jsonNode, String fieldName) {
                        return Float.valueOf(JsonToRowConverters.this.convertToFloat(jsonNode));
                    }
                };
            }
            case DOUBLE: {
                return new JsonToObjectConverter(){

                    @Override
                    public Object convert(JsonNode jsonNode, String fieldName) {
                        return JsonToRowConverters.this.convertToDouble(jsonNode);
                    }
                };
            }
            case STRING: {
                return new JsonToObjectConverter(){

                    @Override
                    public Object convert(JsonNode jsonNode, String fieldName) {
                        return JsonToRowConverters.this.convertToString(jsonNode);
                    }
                };
            }
            case BYTES: {
                return new JsonToObjectConverter(){

                    @Override
                    public Object convert(JsonNode jsonNode, String fieldName) {
                        return JsonToRowConverters.this.convertToBytes(jsonNode);
                    }
                };
            }
            case DECIMAL: {
                return new JsonToObjectConverter(){

                    @Override
                    public Object convert(JsonNode jsonNode, String fieldName) {
                        return JsonToRowConverters.this.convertToBigDecimal(jsonNode);
                    }
                };
            }
            case ARRAY: {
                return this.createArrayConverter((ArrayType)type);
            }
            case MAP: {
                return this.createMapConverter((MapType)type);
            }
            case ROW: {
                return this.createRowConverter((SeaTunnelRowType)type);
            }
        }
        throw new SeaTunnelJsonFormatException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_DATA_TYPE, "Unsupported type: " + type);
    }

    private boolean convertToBoolean(JsonNode jsonNode) {
        if (jsonNode.isBoolean()) {
            return jsonNode.asBoolean();
        }
        return Boolean.parseBoolean(jsonNode.asText().trim());
    }

    private int convertToInt(JsonNode jsonNode) {
        if (jsonNode.canConvertToInt()) {
            return jsonNode.asInt();
        }
        return Integer.parseInt(jsonNode.asText().trim());
    }

    private long convertToLong(JsonNode jsonNode) {
        if (jsonNode.canConvertToLong()) {
            return jsonNode.asLong();
        }
        return Long.parseLong(jsonNode.asText().trim());
    }

    private double convertToDouble(JsonNode jsonNode) {
        if (jsonNode.isDouble()) {
            return jsonNode.asDouble();
        }
        return Double.parseDouble(jsonNode.asText().trim());
    }

    private float convertToFloat(JsonNode jsonNode) {
        if (jsonNode.isDouble()) {
            return (float)jsonNode.asDouble();
        }
        return Float.parseFloat(jsonNode.asText().trim());
    }

    private LocalDate convertToLocalDate(JsonNode jsonNode, String fieldName) {
        String dateStr = jsonNode.asText();
        DateTimeFormatter dateFormatter = this.fieldFormatterMap.get(fieldName);
        if (dateFormatter == null) {
            dateFormatter = DateUtils.matchDateFormatter((String)dateStr);
            this.fieldFormatterMap.put(fieldName, dateFormatter);
        }
        if (dateFormatter == null) {
            throw CommonError.formatDateError((String)dateStr, (String)fieldName);
        }
        return dateFormatter.parse(jsonNode.asText()).query(TemporalQueries.localDate());
    }

    private LocalTime convertToLocalTime(JsonNode jsonNode) {
        TemporalAccessor parsedTime = TIME_FORMAT.parse(jsonNode.asText());
        return parsedTime.query(TemporalQueries.localTime());
    }

    private LocalDateTime convertToLocalDateTime(JsonNode jsonNode, String fieldName) {
        String datetimeStr = jsonNode.asText();
        DateTimeFormatter dateTimeFormatter = this.fieldFormatterMap.get(fieldName);
        if (dateTimeFormatter == null) {
            dateTimeFormatter = DateTimeUtils.matchDateTimeFormatter((String)datetimeStr);
            this.fieldFormatterMap.put(fieldName, dateTimeFormatter);
        }
        if (dateTimeFormatter == null) {
            throw CommonError.formatDateTimeError((String)datetimeStr, (String)fieldName);
        }
        TemporalAccessor parsedTimestamp = dateTimeFormatter.parse(datetimeStr);
        LocalTime localTime = parsedTimestamp.query(TemporalQueries.localTime());
        LocalDate localDate = parsedTimestamp.query(TemporalQueries.localDate());
        return LocalDateTime.of(localDate, localTime);
    }

    private String convertToString(JsonNode jsonNode) {
        if (jsonNode.isContainerNode()) {
            return jsonNode.toString();
        }
        return jsonNode.asText();
    }

    private byte[] convertToBytes(JsonNode jsonNode) {
        try {
            return jsonNode.binaryValue();
        }
        catch (IOException e) {
            throw CommonError.jsonOperationError((String)FORMAT, (String)jsonNode.toString(), (Throwable)e);
        }
    }

    private BigDecimal convertToBigDecimal(JsonNode jsonNode) {
        BigDecimal bigDecimal = jsonNode.isBigDecimal() ? jsonNode.decimalValue() : new BigDecimal(jsonNode.asText());
        return bigDecimal;
    }

    public JsonToObjectConverter createRowConverter(SeaTunnelRowType rowType) {
        final JsonToObjectConverter[] fieldConverters = (JsonToObjectConverter[])Arrays.stream(rowType.getFieldTypes()).map(new Function<SeaTunnelDataType<?>, Object>(){

            @Override
            public Object apply(SeaTunnelDataType<?> seaTunnelDataType) {
                return JsonToRowConverters.this.createConverter(seaTunnelDataType);
            }
        }).toArray((IntFunction<A[]>)new IntFunction<JsonToObjectConverter[]>(){

            @Override
            public JsonToObjectConverter[] apply(int value) {
                return new JsonToObjectConverter[value];
            }
        });
        final String[] fieldNames = rowType.getFieldNames();
        return new JsonToObjectConverter(){

            public SeaTunnelRow convert(JsonNode jsonNode, String rowFieldName) {
                if (jsonNode == null || jsonNode.isNull() || jsonNode.isMissingNode()) {
                    return null;
                }
                int arity = fieldNames.length;
                SeaTunnelRow row = new SeaTunnelRow(arity);
                for (int i = 0; i < arity; ++i) {
                    String fieldName = fieldNames[i];
                    JsonNode field = jsonNode.isArray() ? jsonNode.get(i) : jsonNode.get(fieldName);
                    try {
                        if (StringUtils.isNotBlank((CharSequence)rowFieldName)) {
                            fieldName = rowFieldName + "." + fieldName;
                        }
                        Object convertedField = JsonToRowConverters.this.convertField(fieldConverters[i], fieldName, field);
                        row.setField(i, convertedField);
                        continue;
                    }
                    catch (Throwable t) {
                        throw CommonError.jsonOperationError((String)JsonToRowConverters.FORMAT, (String)String.format("Field $.%s in %s", fieldName, jsonNode.toString()), (Throwable)t);
                    }
                }
                return row;
            }
        };
    }

    private JsonToObjectConverter createArrayConverter(final ArrayType<?, ?> type) {
        final JsonToObjectConverter valueConverter = this.createConverter(type.getElementType());
        return new JsonToObjectConverter(){

            @Override
            public Object convert(JsonNode jsonNode, String fieldName) {
                Object arr = Array.newInstance(type.getElementType().getTypeClass(), jsonNode.size());
                for (int i = 0; i < jsonNode.size(); ++i) {
                    Array.set(arr, i, valueConverter.convert(jsonNode.get(i), fieldName));
                }
                return arr;
            }
        };
    }

    private JsonToObjectConverter createMapConverter(MapType<?, ?> type) {
        final JsonToObjectConverter keyConverter = this.createConverter(type.getKeyType());
        final JsonToObjectConverter valueConverter = this.createConverter(type.getValueType());
        return new JsonToObjectConverter(){

            @Override
            public Object convert(JsonNode jsonNode, final String fieldName) {
                final HashMap value = new HashMap();
                jsonNode.fields().forEachRemaining(new Consumer<Map.Entry<String, JsonNode>>(){

                    @Override
                    public void accept(Map.Entry<String, JsonNode> entry) {
                        JsonNode keyNode;
                        try {
                            keyNode = JsonUtils.stringToJsonNode((String)JsonUtils.toJsonString((Object)entry.getKey()));
                        }
                        catch (Exception e) {
                            throw CommonError.jsonOperationError((String)JsonToRowConverters.FORMAT, (String)entry.getKey(), (Throwable)e);
                        }
                        value.put(keyConverter.convert(keyNode, fieldName + ".key"), valueConverter.convert(entry.getValue(), fieldName + ".value"));
                    }
                });
                return value;
            }
        };
    }

    private Object convertField(JsonToObjectConverter fieldConverter, String fieldName, JsonNode field) {
        if (field == null) {
            if (this.failOnMissingField) {
                throw new IllegalArgumentException(String.format("Could not find field with name %s .", fieldName));
            }
            return null;
        }
        return fieldConverter.convert(field, fieldName);
    }

    private JsonToObjectConverter wrapIntoNullableConverter(final JsonToObjectConverter converter) {
        return new JsonToObjectConverter(){

            @Override
            public Object convert(JsonNode jsonNode, String fieldName) {
                if (jsonNode == null || jsonNode.isNull() || jsonNode.isMissingNode()) {
                    return null;
                }
                try {
                    return converter.convert(jsonNode, fieldName);
                }
                catch (RuntimeException e) {
                    if (!JsonToRowConverters.this.ignoreParseErrors) {
                        throw e;
                    }
                    return null;
                }
            }
        };
    }

    public static interface JsonToObjectConverter
    extends Serializable {
        public Object convert(JsonNode var1, String var2);
    }

    private static final class JsonParseException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public JsonParseException(String message) {
            super(message);
        }

        public JsonParseException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

