/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.tdengine.config;

import java.io.Serializable;
import java.util.Optional;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.connectors.seatunnel.tdengine.config.TDengineSinkOptions;

public class TDengineSinkConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String url;
    private String username;
    private String password;
    private String database;
    private String stable;
    private String timezone;

    public static TDengineSinkConfig of(ReadonlyConfig config) {
        Builder builder = TDengineSinkConfig.builder();
        builder.url((String)config.get(TDengineSinkOptions.URL));
        builder.username((String)config.get(TDengineSinkOptions.USERNAME));
        builder.password((String)config.get(TDengineSinkOptions.PASSWORD));
        builder.database((String)config.get(TDengineSinkOptions.DATABASE));
        builder.stable((String)config.get(TDengineSinkOptions.STABLE));
        Optional optionalTimezone = config.getOptional(TDengineSinkOptions.TIMEZONE);
        builder.timezone(optionalTimezone.orElseGet(() -> TDengineSinkOptions.TIMEZONE.defaultValue()));
        return builder.build();
    }

    TDengineSinkConfig(String url, String username, String password, String database, String stable, String timezone) {
        this.url = url;
        this.username = username;
        this.password = password;
        this.database = database;
        this.stable = stable;
        this.timezone = timezone;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getStable() {
        return this.stable;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void setStable(String stable) {
        this.stable = stable;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TDengineSinkConfig)) {
            return false;
        }
        TDengineSinkConfig other = (TDengineSinkConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$database = this.getDatabase();
        String other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
            return false;
        }
        String this$stable = this.getStable();
        String other$stable = other.getStable();
        if (this$stable == null ? other$stable != null : !this$stable.equals(other$stable)) {
            return false;
        }
        String this$timezone = this.getTimezone();
        String other$timezone = other.getTimezone();
        return !(this$timezone == null ? other$timezone != null : !this$timezone.equals(other$timezone));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TDengineSinkConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        String $stable = this.getStable();
        result = result * 59 + ($stable == null ? 43 : $stable.hashCode());
        String $timezone = this.getTimezone();
        result = result * 59 + ($timezone == null ? 43 : $timezone.hashCode());
        return result;
    }

    public String toString() {
        return "TDengineSinkConfig(url=" + this.getUrl() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", database=" + this.getDatabase() + ", stable=" + this.getStable() + ", timezone=" + this.getTimezone() + ")";
    }

    public static class Builder {
        private String url;
        private String username;
        private String password;
        private String database;
        private String stable;
        private String timezone;

        Builder() {
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder database(String database) {
            this.database = database;
            return this;
        }

        public Builder stable(String stable) {
            this.stable = stable;
            return this;
        }

        public Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public TDengineSinkConfig build() {
            return new TDengineSinkConfig(this.url, this.username, this.password, this.database, this.stable, this.timezone);
        }

        public String toString() {
            return "TDengineSinkConfig.Builder(url=" + this.url + ", username=" + this.username + ", password=" + this.password + ", database=" + this.database + ", stable=" + this.stable + ", timezone=" + this.timezone + ")";
        }
    }
}

