/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.sentry.sink;

import io.sentry.Sentry;
import io.sentry.SentryOptions;
import java.io.IOException;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.connectors.seatunnel.common.sink.AbstractSinkWriter;
import org.apache.seatunnel.connectors.seatunnel.sentry.config.SentrySinkOptions;

public class SentrySinkWriter
extends AbstractSinkWriter<SeaTunnelRow, Void> {
    public SentrySinkWriter(ReadonlyConfig pluginConfig) {
        SentryOptions options = new SentryOptions();
        options.setDsn((String)pluginConfig.get(SentrySinkOptions.DSN));
        if (pluginConfig.getOptional(SentrySinkOptions.ENV).isPresent()) {
            options.setEnvironment((String)pluginConfig.get(SentrySinkOptions.ENV));
        }
        if (pluginConfig.getOptional(SentrySinkOptions.RELEASE).isPresent()) {
            options.setRelease((String)pluginConfig.get(SentrySinkOptions.RELEASE));
        }
        if (pluginConfig.getOptional(SentrySinkOptions.CACHE_DIRPATH).isPresent()) {
            options.setCacheDirPath((String)pluginConfig.get(SentrySinkOptions.CACHE_DIRPATH));
        }
        if (pluginConfig.getOptional(SentrySinkOptions.MAX_CACHEITEMS).isPresent()) {
            options.setMaxCacheItems((Integer)pluginConfig.get(SentrySinkOptions.MAX_CACHEITEMS));
        }
        if (pluginConfig.getOptional(SentrySinkOptions.MAX_QUEUESIZE).isPresent()) {
            options.setMaxQueueSize((Integer)pluginConfig.get(SentrySinkOptions.MAX_QUEUESIZE));
        }
        if (pluginConfig.getOptional(SentrySinkOptions.FLUSH_TIMEOUTMILLIS).isPresent()) {
            options.setFlushTimeoutMillis((Long)pluginConfig.get(SentrySinkOptions.FLUSH_TIMEOUTMILLIS));
        }
        if (pluginConfig.getOptional(SentrySinkOptions.ENABLE_EXTERNAL_CONFIGURATION).isPresent()) {
            options.setEnableExternalConfiguration((Boolean)pluginConfig.get(SentrySinkOptions.ENABLE_EXTERNAL_CONFIGURATION));
        }
        Sentry.init(options);
    }

    public void write(SeaTunnelRow element) throws IOException {
        Sentry.captureMessage(element.toString());
    }

    public void close() throws IOException {
        Sentry.close();
    }
}

