/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.transport;

import io.sentry.ILogger;
import io.sentry.RequestDetails;
import io.sentry.SentryEnvelope;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.cache.IEnvelopeCache;
import io.sentry.hints.Cached;
import io.sentry.hints.DiskFlushNotification;
import io.sentry.hints.Retryable;
import io.sentry.hints.SubmissionResult;
import io.sentry.transport.HttpConnection;
import io.sentry.transport.ITransport;
import io.sentry.transport.ITransportGate;
import io.sentry.transport.NoOpEnvelopeCache;
import io.sentry.transport.QueuedThreadPoolExecutor;
import io.sentry.transport.RateLimiter;
import io.sentry.transport.TransportResult;
import io.sentry.util.LogUtils;
import io.sentry.util.Objects;
import java.io.IOException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AsyncHttpTransport
implements ITransport {
    @NotNull
    private final QueuedThreadPoolExecutor executor;
    @NotNull
    private final IEnvelopeCache envelopeCache;
    @NotNull
    private final SentryOptions options;
    @NotNull
    private final RateLimiter rateLimiter;
    @NotNull
    private final ITransportGate transportGate;
    @NotNull
    private final HttpConnection connection;

    public AsyncHttpTransport(@NotNull SentryOptions options, @NotNull RateLimiter rateLimiter, @NotNull ITransportGate transportGate, @NotNull RequestDetails requestDetails) {
        this(AsyncHttpTransport.initExecutor(options.getMaxQueueSize(), options.getEnvelopeDiskCache(), options.getLogger()), options, rateLimiter, transportGate, new HttpConnection(options, requestDetails, rateLimiter));
    }

    public AsyncHttpTransport(@NotNull QueuedThreadPoolExecutor executor, @NotNull SentryOptions options, @NotNull RateLimiter rateLimiter, @NotNull ITransportGate transportGate, @NotNull HttpConnection httpConnection) {
        this.executor = Objects.requireNonNull(executor, "executor is required");
        this.envelopeCache = Objects.requireNonNull(options.getEnvelopeDiskCache(), "envelopeCache is required");
        this.options = Objects.requireNonNull(options, "options is required");
        this.rateLimiter = Objects.requireNonNull(rateLimiter, "rateLimiter is required");
        this.transportGate = Objects.requireNonNull(transportGate, "transportGate is required");
        this.connection = Objects.requireNonNull(httpConnection, "httpConnection is required");
    }

    @Override
    public void send(@NotNull SentryEnvelope envelope, @Nullable Object hint) throws IOException {
        SentryEnvelope filteredEnvelope;
        IEnvelopeCache currentEnvelopeCache = this.envelopeCache;
        boolean cached = false;
        if (hint instanceof Cached) {
            currentEnvelopeCache = NoOpEnvelopeCache.getInstance();
            cached = true;
            this.options.getLogger().log(SentryLevel.DEBUG, "Captured Envelope is already cached", new Object[0]);
        }
        if ((filteredEnvelope = this.rateLimiter.filter(envelope, hint)) == null) {
            if (cached) {
                this.envelopeCache.discard(envelope);
            }
        } else {
            this.executor.submit(new EnvelopeSender(filteredEnvelope, hint, currentEnvelopeCache));
        }
    }

    @Override
    public void flush(long timeoutMillis) {
        this.executor.waitTillIdle(timeoutMillis);
    }

    private static QueuedThreadPoolExecutor initExecutor(int maxQueueSize, @NotNull IEnvelopeCache envelopeCache, @NotNull ILogger logger) {
        RejectedExecutionHandler storeEvents = (r, executor) -> {
            if (r instanceof EnvelopeSender) {
                EnvelopeSender envelopeSender = (EnvelopeSender)r;
                if (!(envelopeSender.hint instanceof Cached)) {
                    envelopeCache.store(envelopeSender.envelope, envelopeSender.hint);
                }
                AsyncHttpTransport.markHintWhenSendingFailed(envelopeSender.hint, true);
                logger.log(SentryLevel.WARNING, "Envelope rejected", new Object[0]);
            }
        };
        return new QueuedThreadPoolExecutor(1, maxQueueSize, new AsyncConnectionThreadFactory(), storeEvents, logger);
    }

    @Override
    public void close() throws IOException {
        this.executor.shutdown();
        this.options.getLogger().log(SentryLevel.DEBUG, "Shutting down", new Object[0]);
        try {
            if (!this.executor.awaitTermination(1L, TimeUnit.MINUTES)) {
                this.options.getLogger().log(SentryLevel.WARNING, "Failed to shutdown the async connection async sender within 1 minute. Trying to force it now.", new Object[0]);
                this.executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Thread interrupted while closing the connection.", new Object[0]);
            Thread.currentThread().interrupt();
        }
    }

    private static void markHintWhenSendingFailed(@Nullable Object hint, boolean retry) {
        if (hint instanceof SubmissionResult) {
            ((SubmissionResult)hint).setResult(false);
        }
        if (hint instanceof Retryable) {
            ((Retryable)hint).setRetry(retry);
        }
    }

    private final class EnvelopeSender
    implements Runnable {
        @NotNull
        private final SentryEnvelope envelope;
        @Nullable
        private final Object hint;
        @NotNull
        private final IEnvelopeCache envelopeCache;
        private final TransportResult failedResult = TransportResult.error();

        EnvelopeSender(@Nullable SentryEnvelope envelope, @NotNull Object hint, IEnvelopeCache envelopeCache) {
            this.envelope = Objects.requireNonNull(envelope, "Envelope is required.");
            this.hint = hint;
            this.envelopeCache = Objects.requireNonNull(envelopeCache, "EnvelopeCache is required.");
        }

        @Override
        public void run() {
            TransportResult result = this.failedResult;
            try {
                result = this.flush();
                AsyncHttpTransport.this.options.getLogger().log(SentryLevel.DEBUG, "Envelope flushed", new Object[0]);
            }
            catch (Exception e) {
                try {
                    AsyncHttpTransport.this.options.getLogger().log(SentryLevel.ERROR, e, "Envelope submission failed", new Object[0]);
                    throw e;
                }
                catch (Throwable throwable) {
                    if (this.hint instanceof SubmissionResult) {
                        AsyncHttpTransport.this.options.getLogger().log(SentryLevel.DEBUG, "Marking envelope submission result: %s", result.isSuccess());
                        ((SubmissionResult)this.hint).setResult(result.isSuccess());
                    }
                    throw throwable;
                }
            }
            if (this.hint instanceof SubmissionResult) {
                AsyncHttpTransport.this.options.getLogger().log(SentryLevel.DEBUG, "Marking envelope submission result: %s", result.isSuccess());
                ((SubmissionResult)this.hint).setResult(result.isSuccess());
            }
        }

        @NotNull
        private TransportResult flush() {
            TransportResult result = this.failedResult;
            this.envelopeCache.store(this.envelope, this.hint);
            if (this.hint instanceof DiskFlushNotification) {
                ((DiskFlushNotification)this.hint).markFlushed();
                AsyncHttpTransport.this.options.getLogger().log(SentryLevel.DEBUG, "Disk flush envelope fired", new Object[0]);
            }
            if (AsyncHttpTransport.this.transportGate.isConnected()) {
                try {
                    result = AsyncHttpTransport.this.connection.send(this.envelope);
                    if (!result.isSuccess()) {
                        String message = "The transport failed to send the envelope with response code " + result.getResponseCode();
                        AsyncHttpTransport.this.options.getLogger().log(SentryLevel.ERROR, message, new Object[0]);
                        throw new IllegalStateException(message);
                    }
                    this.envelopeCache.discard(this.envelope);
                }
                catch (IOException e) {
                    if (this.hint instanceof Retryable) {
                        ((Retryable)this.hint).setRetry(true);
                    } else {
                        LogUtils.logIfNotRetryable(AsyncHttpTransport.this.options.getLogger(), this.hint);
                    }
                    throw new IllegalStateException("Sending the event failed.", e);
                }
            } else if (this.hint instanceof Retryable) {
                ((Retryable)this.hint).setRetry(true);
            } else {
                LogUtils.logIfNotRetryable(AsyncHttpTransport.this.options.getLogger(), this.hint);
            }
            return result;
        }
    }

    private static final class AsyncConnectionThreadFactory
    implements ThreadFactory {
        private int cnt;

        private AsyncConnectionThreadFactory() {
        }

        @Override
        @NotNull
        public Thread newThread(@NotNull Runnable r) {
            Thread ret = new Thread(r, "SentryAsyncConnection-" + this.cnt++);
            ret.setDaemon(true);
            return ret;
        }
    }
}

