/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.selectdb.sink.committer;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.seatunnel.api.sink.SinkCommitter;
import org.apache.seatunnel.connectors.selectdb.config.SelectDBConfig;
import org.apache.seatunnel.connectors.selectdb.rest.CopySQLUtil;
import org.apache.seatunnel.connectors.selectdb.sink.committer.SelectDBCommitInfo;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectDBCommitter
implements SinkCommitter<SelectDBCommitInfo> {
    private static final Logger log = LoggerFactory.getLogger(SelectDBCommitter.class);
    private final SelectDBConfig selectdbConfig;

    public SelectDBCommitter(Config pluginConfig) {
        this(SelectDBConfig.loadConfig(pluginConfig));
    }

    public SelectDBCommitter(SelectDBConfig selectdbConfig) {
        this.selectdbConfig = selectdbConfig;
    }

    public List<SelectDBCommitInfo> commit(List<SelectDBCommitInfo> commitInfos) throws IOException {
        for (SelectDBCommitInfo committable : commitInfos) {
            this.commitTransaction(committable);
        }
        return Collections.emptyList();
    }

    public void abort(List<SelectDBCommitInfo> commitInfos) {
    }

    private void commitTransaction(SelectDBCommitInfo commitInfo) throws IOException {
        String hostPort = commitInfo.getHostPort();
        String clusterName = commitInfo.getClusterName();
        String copySQL = commitInfo.getCopySQL();
        log.info("commit to cluster {} with copy sql: {}", (Object)clusterName, (Object)copySQL);
        CopySQLUtil.copyFileToDatabase(this.selectdbConfig, clusterName, copySQL, hostPort);
    }
}

