/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.connector.file.org.apache.orc.storage.common.util;

import org.apache.seatunnel.shade.connector.file.org.apache.orc.storage.common.ValidWriteIdList;

public class TxnIdUtils {
    public static boolean checkEquivalentWriteIds(ValidWriteIdList a, ValidWriteIdList b) {
        if (!a.getTableName().equalsIgnoreCase(b.getTableName())) {
            return false;
        }
        ValidWriteIdList newer = a;
        ValidWriteIdList older = b;
        if (a.getHighWatermark() < b.getHighWatermark()) {
            newer = b;
            older = a;
        }
        return TxnIdUtils.checkEquivalentCommittedIds(older.getHighWatermark(), older.getInvalidWriteIds(), newer.getHighWatermark(), newer.getInvalidWriteIds());
    }

    private static boolean checkEquivalentCommittedIds(long oldHWM, long[] oldInvalidIds, long newHWM, long[] newInvalidIds) {
        if (newInvalidIds.length < oldInvalidIds.length) {
            return false;
        }
        for (int idx = 0; idx < oldInvalidIds.length; ++idx) {
            if (oldInvalidIds[idx] == newInvalidIds[idx]) continue;
            return false;
        }
        long oldNewHWMDifference = newHWM - oldHWM;
        long oldNewListSizeDifference = newInvalidIds.length - oldInvalidIds.length;
        return oldNewHWMDifference == oldNewListSizeDifference;
    }
}

