/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.redshift;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.redshift.config.S3RedshiftConfigOptions;
import org.apache.seatunnel.connectors.seatunnel.redshift.exception.S3RedshiftJdbcConnectorException;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

public class RedshiftJdbcClient {
    private static volatile RedshiftJdbcClient INSTANCE = null;
    private final Connection connection;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RedshiftJdbcClient getInstance(Config config) throws S3RedshiftJdbcConnectorException {
        if (INSTANCE != null) return INSTANCE;
        Class<RedshiftJdbcClient> clazz = RedshiftJdbcClient.class;
        synchronized (RedshiftJdbcClient.class) {
            if (INSTANCE != null) return INSTANCE;
            try {
                INSTANCE = new RedshiftJdbcClient(config.getString(S3RedshiftConfigOptions.JDBC_URL.key()), config.getString(S3RedshiftConfigOptions.JDBC_USER.key()), config.getString(S3RedshiftConfigOptions.JDBC_PASSWORD.key()));
            }
            catch (ClassNotFoundException | SQLException e) {
                throw new S3RedshiftJdbcConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.SQL_OPERATION_FAILED, "RedshiftJdbcClient init error", e);
            }
            return INSTANCE;
        }
    }

    private RedshiftJdbcClient(String url, String user, String password) throws SQLException, ClassNotFoundException {
        Class.forName("com.amazon.redshift.jdbc42.Driver");
        this.connection = DriverManager.getConnection(url, user, password);
    }

    public boolean checkTableExists(String tableName) {
        boolean flag = false;
        try {
            DatabaseMetaData meta = this.connection.getMetaData();
            String[] type = new String[]{"TABLE"};
            ResultSet rs = meta.getTables(null, null, tableName, type);
            flag = rs.next();
        }
        catch (SQLException e) {
            throw new S3RedshiftJdbcConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.TABLE_SCHEMA_GET_FAILED, String.format("Check table is or not existed failed, table name is %s ", tableName), e);
        }
        return flag;
    }

    public boolean execute(String sql) throws Exception {
        try (Statement statement = this.connection.createStatement();){
            boolean bl = statement.execute(sql);
            return bl;
        }
    }

    public synchronized void close() throws SQLException {
        this.connection.close();
    }
}

