/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.s3.catalog;

import com.google.auto.service.AutoService;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.table.catalog.Catalog;
import org.apache.seatunnel.api.table.factory.CatalogFactory;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.connectors.seatunnel.file.config.BaseSourceConfigOptions;
import org.apache.seatunnel.connectors.seatunnel.file.config.HadoopConf;
import org.apache.seatunnel.connectors.seatunnel.file.hadoop.HadoopFileSystemProxy;
import org.apache.seatunnel.connectors.seatunnel.file.s3.catalog.S3FileCatalog;
import org.apache.seatunnel.connectors.seatunnel.file.s3.config.S3HadoopConf;

@AutoService(value={Factory.class})
public class S3FileCatalogFactory
implements CatalogFactory {
    public Catalog createCatalog(String catalogName, ReadonlyConfig options) {
        HadoopConf hadoopConf = S3HadoopConf.buildWithReadOnlyConfig(options);
        HadoopFileSystemProxy fileSystemUtils = new HadoopFileSystemProxy(hadoopConf);
        return new S3FileCatalog(fileSystemUtils, (String)options.get(BaseSourceConfigOptions.FILE_PATH));
    }

    public String factoryIdentifier() {
        return "S3";
    }

    public OptionRule optionRule() {
        return OptionRule.builder().build();
    }
}

