/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.qdrant.sink;

import java.io.IOException;
import java.util.Optional;
import org.apache.seatunnel.api.sink.SupportMultiTableSinkWriter;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.connectors.seatunnel.common.sink.AbstractSinkWriter;
import org.apache.seatunnel.connectors.seatunnel.qdrant.config.QdrantParameters;
import org.apache.seatunnel.connectors.seatunnel.qdrant.sink.QdrantBatchWriter;

public class QdrantSinkWriter
extends AbstractSinkWriter<SeaTunnelRow, Void>
implements SupportMultiTableSinkWriter<Void> {
    private final QdrantBatchWriter batchWriter;

    public QdrantSinkWriter(CatalogTable catalog, QdrantParameters qdrantParameters) {
        int batchSize = 64;
        this.batchWriter = new QdrantBatchWriter(catalog, batchSize, qdrantParameters);
    }

    public void write(SeaTunnelRow element) throws IOException {
        this.batchWriter.addToBatch(element);
        if (this.batchWriter.needFlush()) {
            this.batchWriter.flush();
        }
    }

    @Override
    public Optional<Void> prepareCommit() {
        this.batchWriter.flush();
        return Optional.empty();
    }

    private void clearBuffer() {
    }

    public void close() throws IOException {
        this.batchWriter.flush();
        this.batchWriter.close();
    }
}

