/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.qdrant.source;

import java.util.Collections;
import java.util.List;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.source.Boundedness;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.CatalogTableUtil;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.connectors.seatunnel.common.source.AbstractSingleSplitReader;
import org.apache.seatunnel.connectors.seatunnel.common.source.AbstractSingleSplitSource;
import org.apache.seatunnel.connectors.seatunnel.common.source.SingleSplitReaderContext;
import org.apache.seatunnel.connectors.seatunnel.qdrant.config.QdrantParameters;
import org.apache.seatunnel.connectors.seatunnel.qdrant.source.QdrantSourceReader;

public class QdrantSource
extends AbstractSingleSplitSource<SeaTunnelRow> {
    private final QdrantParameters qdrantParameters;
    private final CatalogTable catalogTable;

    public String getPluginName() {
        return "Qdrant";
    }

    public QdrantSource(ReadonlyConfig readonlyConfig) {
        this.qdrantParameters = new QdrantParameters(readonlyConfig);
        this.catalogTable = CatalogTableUtil.buildWithConfig((ReadonlyConfig)readonlyConfig);
    }

    public Boundedness getBoundedness() {
        return Boundedness.BOUNDED;
    }

    public List<CatalogTable> getProducedCatalogTables() {
        return Collections.singletonList(this.catalogTable);
    }

    @Override
    public AbstractSingleSplitReader<SeaTunnelRow> createReader(SingleSplitReaderContext readerContext) {
        return new QdrantSourceReader(this.qdrantParameters, readerContext, this.catalogTable);
    }
}

