/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.iotdb.source;

import com.google.auto.service.AutoService;
import java.io.Serializable;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.options.ConnectorCommonOptions;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.source.SourceSplit;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.CatalogTableUtil;
import org.apache.seatunnel.api.table.connector.TableSource;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.TableSourceFactory;
import org.apache.seatunnel.api.table.factory.TableSourceFactoryContext;
import org.apache.seatunnel.connectors.seatunnel.iotdb.config.IoTDBSourceOptions;
import org.apache.seatunnel.connectors.seatunnel.iotdb.source.IoTDBSource;

@AutoService(value={Factory.class})
public class IoTDBSourceFactory
implements TableSourceFactory {
    public String factoryIdentifier() {
        return "IoTDB";
    }

    public OptionRule optionRule() {
        return OptionRule.builder().required(new Option[]{IoTDBSourceOptions.NODE_URLS, IoTDBSourceOptions.USERNAME, IoTDBSourceOptions.PASSWORD, IoTDBSourceOptions.SQL, ConnectorCommonOptions.SCHEMA}).optional(new Option[]{IoTDBSourceOptions.FETCH_SIZE, IoTDBSourceOptions.THRIFT_DEFAULT_BUFFER_SIZE, IoTDBSourceOptions.THRIFT_MAX_FRAME_SIZE, IoTDBSourceOptions.ENABLE_CACHE_LEADER, IoTDBSourceOptions.VERSION, IoTDBSourceOptions.LOWER_BOUND, IoTDBSourceOptions.UPPER_BOUND, IoTDBSourceOptions.NUM_PARTITIONS}).build();
    }

    public <T, SplitT extends SourceSplit, StateT extends Serializable> TableSource<T, SplitT, StateT> createSource(TableSourceFactoryContext context) {
        CatalogTable catalogTable = CatalogTableUtil.buildWithConfig((ReadonlyConfig)context.getOptions());
        return () -> new IoTDBSource(catalogTable, context.getOptions());
    }

    public Class<? extends SeaTunnelSource> getSourceClass() {
        return IoTDBSource.class;
    }
}

