/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.iotdb.config;

import java.time.ZoneId;
import java.util.List;
import lombok.NonNull;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.connectors.seatunnel.iotdb.config.CommonConfig;
import org.apache.seatunnel.connectors.seatunnel.iotdb.config.IoTDBSinkOptions;
import org.apache.seatunnel.shade.com.google.common.base.Preconditions;

public class SinkConfig
extends CommonConfig {
    private String keyTimestamp;
    private String keyDevice;
    private List<String> keyMeasurementFields;
    private String storageGroup;
    private int batchSize;
    private int maxRetries;
    private int retryBackoffMultiplierMs;
    private int maxRetryBackoffMs;
    private Integer thriftDefaultBufferSize;
    private Integer thriftMaxFrameSize;
    private ZoneId zoneId;
    private Boolean enableRPCCompression;
    private Integer connectionTimeoutInMs;

    public SinkConfig(@NonNull List<String> nodeUrls, @NonNull String username, @NonNull String password) {
        super(nodeUrls, username, password);
        if (nodeUrls == null) {
            throw new NullPointerException("nodeUrls is marked non-null but is null");
        }
        if (username == null) {
            throw new NullPointerException("username is marked non-null but is null");
        }
        if (password == null) {
            throw new NullPointerException("password is marked non-null but is null");
        }
    }

    public static SinkConfig loadConfig(ReadonlyConfig pluginConfig) {
        SinkConfig sinkConfig = new SinkConfig(pluginConfig.toConfig().getStringList(IoTDBSinkOptions.NODE_URLS.key()), (String)pluginConfig.get(IoTDBSinkOptions.USERNAME), (String)pluginConfig.get(IoTDBSinkOptions.PASSWORD));
        sinkConfig.setKeyDevice((String)pluginConfig.get(IoTDBSinkOptions.KEY_DEVICE));
        sinkConfig.setKeyTimestamp((String)pluginConfig.get(IoTDBSinkOptions.KEY_TIMESTAMP));
        sinkConfig.setKeyMeasurementFields((List)pluginConfig.get(IoTDBSinkOptions.KEY_MEASUREMENT_FIELDS));
        sinkConfig.setStorageGroup((String)pluginConfig.get(IoTDBSinkOptions.STORAGE_GROUP));
        if (pluginConfig.getOptional(IoTDBSinkOptions.BATCH_SIZE).isPresent()) {
            sinkConfig.setBatchSize((Integer)pluginConfig.get(IoTDBSinkOptions.BATCH_SIZE));
        }
        if (pluginConfig.getOptional(IoTDBSinkOptions.MAX_RETRIES).isPresent()) {
            sinkConfig.setMaxRetries((Integer)pluginConfig.get(IoTDBSinkOptions.MAX_RETRIES));
        }
        if (pluginConfig.getOptional(IoTDBSinkOptions.RETRY_BACKOFF_MULTIPLIER_MS).isPresent()) {
            sinkConfig.setRetryBackoffMultiplierMs((Integer)pluginConfig.get(IoTDBSinkOptions.RETRY_BACKOFF_MULTIPLIER_MS));
        }
        if (pluginConfig.getOptional(IoTDBSinkOptions.MAX_RETRY_BACKOFF_MS).isPresent()) {
            sinkConfig.setMaxRetryBackoffMs((Integer)pluginConfig.get(IoTDBSinkOptions.MAX_RETRY_BACKOFF_MS));
        }
        if (pluginConfig.getOptional(IoTDBSinkOptions.DEFAULT_THRIFT_BUFFER_SIZE).isPresent()) {
            sinkConfig.setThriftDefaultBufferSize((Integer)pluginConfig.get(IoTDBSinkOptions.DEFAULT_THRIFT_BUFFER_SIZE));
        }
        if (pluginConfig.getOptional(IoTDBSinkOptions.MAX_THRIFT_FRAME_SIZE).isPresent()) {
            sinkConfig.setThriftMaxFrameSize((Integer)pluginConfig.get(IoTDBSinkOptions.MAX_THRIFT_FRAME_SIZE));
        }
        if (pluginConfig.getOptional(IoTDBSinkOptions.ZONE_ID).isPresent()) {
            sinkConfig.setZoneId(ZoneId.of((String)pluginConfig.get(IoTDBSinkOptions.ZONE_ID)));
        }
        sinkConfig.setEnableRPCCompression((Boolean)pluginConfig.get(IoTDBSinkOptions.ENABLE_RPC_COMPRESSION));
        if (pluginConfig.getOptional(IoTDBSinkOptions.CONNECTION_TIMEOUT_IN_MS).isPresent()) {
            Preconditions.checkNotNull((Object)sinkConfig.getEnableRPCCompression());
            sinkConfig.setConnectionTimeoutInMs((Integer)pluginConfig.get(IoTDBSinkOptions.CONNECTION_TIMEOUT_IN_MS));
        }
        return sinkConfig;
    }

    public void setKeyTimestamp(String keyTimestamp) {
        this.keyTimestamp = keyTimestamp;
    }

    public void setKeyDevice(String keyDevice) {
        this.keyDevice = keyDevice;
    }

    public void setKeyMeasurementFields(List<String> keyMeasurementFields) {
        this.keyMeasurementFields = keyMeasurementFields;
    }

    public void setStorageGroup(String storageGroup) {
        this.storageGroup = storageGroup;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public void setRetryBackoffMultiplierMs(int retryBackoffMultiplierMs) {
        this.retryBackoffMultiplierMs = retryBackoffMultiplierMs;
    }

    public void setMaxRetryBackoffMs(int maxRetryBackoffMs) {
        this.maxRetryBackoffMs = maxRetryBackoffMs;
    }

    public void setThriftDefaultBufferSize(Integer thriftDefaultBufferSize) {
        this.thriftDefaultBufferSize = thriftDefaultBufferSize;
    }

    public void setThriftMaxFrameSize(Integer thriftMaxFrameSize) {
        this.thriftMaxFrameSize = thriftMaxFrameSize;
    }

    public void setZoneId(ZoneId zoneId) {
        this.zoneId = zoneId;
    }

    public void setEnableRPCCompression(Boolean enableRPCCompression) {
        this.enableRPCCompression = enableRPCCompression;
    }

    public void setConnectionTimeoutInMs(Integer connectionTimeoutInMs) {
        this.connectionTimeoutInMs = connectionTimeoutInMs;
    }

    public String getKeyTimestamp() {
        return this.keyTimestamp;
    }

    public String getKeyDevice() {
        return this.keyDevice;
    }

    public List<String> getKeyMeasurementFields() {
        return this.keyMeasurementFields;
    }

    public String getStorageGroup() {
        return this.storageGroup;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public int getRetryBackoffMultiplierMs() {
        return this.retryBackoffMultiplierMs;
    }

    public int getMaxRetryBackoffMs() {
        return this.maxRetryBackoffMs;
    }

    public Integer getThriftDefaultBufferSize() {
        return this.thriftDefaultBufferSize;
    }

    public Integer getThriftMaxFrameSize() {
        return this.thriftMaxFrameSize;
    }

    public ZoneId getZoneId() {
        return this.zoneId;
    }

    public Boolean getEnableRPCCompression() {
        return this.enableRPCCompression;
    }

    public Integer getConnectionTimeoutInMs() {
        return this.connectionTimeoutInMs;
    }

    @Override
    public String toString() {
        return "SinkConfig(keyTimestamp=" + this.getKeyTimestamp() + ", keyDevice=" + this.getKeyDevice() + ", keyMeasurementFields=" + this.getKeyMeasurementFields() + ", storageGroup=" + this.getStorageGroup() + ", batchSize=" + this.getBatchSize() + ", maxRetries=" + this.getMaxRetries() + ", retryBackoffMultiplierMs=" + this.getRetryBackoffMultiplierMs() + ", maxRetryBackoffMs=" + this.getMaxRetryBackoffMs() + ", thriftDefaultBufferSize=" + this.getThriftDefaultBufferSize() + ", thriftMaxFrameSize=" + this.getThriftMaxFrameSize() + ", zoneId=" + this.getZoneId() + ", enableRPCCompression=" + this.getEnableRPCCompression() + ", connectionTimeoutInMs=" + this.getConnectionTimeoutInMs() + ")";
    }
}

