/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.session;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.iotdb.rpc.BatchExecutionException;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.RedirectException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.service.rpc.thrift.EndPoint;
import org.apache.iotdb.service.rpc.thrift.TSAppendSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSCreateAlignedTimeseriesReq;
import org.apache.iotdb.service.rpc.thrift.TSCreateMultiTimeseriesReq;
import org.apache.iotdb.service.rpc.thrift.TSCreateSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSCreateTimeseriesReq;
import org.apache.iotdb.service.rpc.thrift.TSDeleteDataReq;
import org.apache.iotdb.service.rpc.thrift.TSDropSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertRecordReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertRecordsOfOneDeviceReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertRecordsReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertStringRecordReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertStringRecordsOfOneDeviceReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertStringRecordsReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertTabletReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertTabletsReq;
import org.apache.iotdb.service.rpc.thrift.TSOperationSyncWriteReq;
import org.apache.iotdb.service.rpc.thrift.TSProtocolVersion;
import org.apache.iotdb.service.rpc.thrift.TSPruneSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSQueryTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSQueryTemplateResp;
import org.apache.iotdb.service.rpc.thrift.TSSetSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSSetUsingTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSUnsetSchemaTemplateReq;
import org.apache.iotdb.session.Config;
import org.apache.iotdb.session.InsertConsumer;
import org.apache.iotdb.session.SessionConnection;
import org.apache.iotdb.session.SessionDataSet;
import org.apache.iotdb.session.template.MeasurementNode;
import org.apache.iotdb.session.template.Template;
import org.apache.iotdb.session.template.TemplateQueryType;
import org.apache.iotdb.session.util.SessionUtils;
import org.apache.iotdb.session.util.SystemStatus;
import org.apache.iotdb.session.util.ThreadUtils;
import org.apache.iotdb.session.util.Version;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.BitMap;
import org.apache.iotdb.tsfile.write.record.Tablet;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Session {
    private static final Logger logger = LoggerFactory.getLogger(Session.class);
    protected static final TSProtocolVersion protocolVersion = TSProtocolVersion.IOTDB_SERVICE_PROTOCOL_V3;
    public static final String MSG_UNSUPPORTED_DATA_TYPE = "Unsupported data type:";
    public static final String MSG_DONOT_ENABLE_REDIRECT = "Query do not enable redirect, please confirm the session and server conf.";
    private static final ThreadPoolExecutor OPERATION_EXECUTOR = new ThreadPoolExecutor(Config.DEFAULT_SESSION_EXECUTOR_THREAD_NUM, Config.DEFAULT_SESSION_EXECUTOR_THREAD_NUM, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1000), ThreadUtils.createThreadFactory("SessionExecutor", true));
    protected List<String> nodeUrls;
    protected String username;
    protected String password;
    protected int fetchSize;
    private static final byte TYPE_NULL = -2;
    private long queryTimeoutInMs = -1L;
    protected boolean enableRPCCompression;
    protected int connectionTimeoutInMs;
    protected ZoneId zoneId;
    protected int thriftDefaultBufferSize;
    protected int thriftMaxFrameSize;
    protected EndPoint defaultEndPoint;
    protected SessionConnection defaultSessionConnection;
    private boolean isClosed = true;
    protected boolean enableCacheLeader;
    protected SessionConnection metaSessionConnection;
    protected volatile Map<String, EndPoint> deviceIdToEndpoint;
    protected volatile Map<EndPoint, SessionConnection> endPointToSessionConnection;
    protected boolean enableQueryRedirection = false;
    protected Version version;

    public Session(String host, int rpcPort) {
        this(host, rpcPort, "root", "root", 5000, null, 1024, 0x4000000, true, Config.DEFAULT_VERSION);
    }

    public Session(String host, String rpcPort, String username, String password) {
        this(host, Integer.parseInt(rpcPort), username, password, 5000, null, 1024, 0x4000000, true, Config.DEFAULT_VERSION);
    }

    public Session(String host, int rpcPort, String username, String password) {
        this(host, rpcPort, username, password, 5000, null, 1024, 0x4000000, true, Config.DEFAULT_VERSION);
    }

    public Session(String host, int rpcPort, String username, String password, int fetchSize) {
        this(host, rpcPort, username, password, fetchSize, null, 1024, 0x4000000, true, Config.DEFAULT_VERSION);
    }

    public Session(String host, int rpcPort, String username, String password, int fetchSize, long queryTimeoutInMs) {
        this(host, rpcPort, username, password, fetchSize, null, 1024, 0x4000000, true, Config.DEFAULT_VERSION);
        this.queryTimeoutInMs = queryTimeoutInMs;
    }

    public Session(String host, int rpcPort, String username, String password, ZoneId zoneId) {
        this(host, rpcPort, username, password, 5000, zoneId, 1024, 0x4000000, true, Config.DEFAULT_VERSION);
    }

    public Session(String host, int rpcPort, String username, String password, boolean enableCacheLeader) {
        this(host, rpcPort, username, password, 5000, null, 1024, 0x4000000, enableCacheLeader, Config.DEFAULT_VERSION);
    }

    public Session(String host, int rpcPort, String username, String password, int fetchSize, ZoneId zoneId, boolean enableCacheLeader) {
        this(host, rpcPort, username, password, fetchSize, zoneId, 1024, 0x4000000, enableCacheLeader, Config.DEFAULT_VERSION);
    }

    public Session(String host, int rpcPort, String username, String password, int fetchSize, ZoneId zoneId, int thriftDefaultBufferSize, int thriftMaxFrameSize, boolean enableCacheLeader, Version version) {
        this.defaultEndPoint = new EndPoint(host, rpcPort);
        this.username = username;
        this.password = password;
        this.fetchSize = fetchSize;
        this.zoneId = zoneId;
        this.thriftDefaultBufferSize = thriftDefaultBufferSize;
        this.thriftMaxFrameSize = thriftMaxFrameSize;
        this.enableCacheLeader = enableCacheLeader;
        this.version = version;
    }

    public Session(List<String> nodeUrls, String username, String password) {
        this(nodeUrls, username, password, 5000, null, 1024, 0x4000000, true, Config.DEFAULT_VERSION);
    }

    public Session(List<String> nodeUrls, String username, String password, int fetchSize) {
        this(nodeUrls, username, password, fetchSize, null, 1024, 0x4000000, true, Config.DEFAULT_VERSION);
    }

    public Session(List<String> nodeUrls, String username, String password, ZoneId zoneId) {
        this(nodeUrls, username, password, 5000, zoneId, 1024, 0x4000000, true, Config.DEFAULT_VERSION);
    }

    public Session(List<String> nodeUrls, String username, String password, int fetchSize, ZoneId zoneId, int thriftDefaultBufferSize, int thriftMaxFrameSize, boolean enableCacheLeader, Version version) {
        this.nodeUrls = nodeUrls;
        this.username = username;
        this.password = password;
        this.fetchSize = fetchSize;
        this.zoneId = zoneId;
        this.thriftDefaultBufferSize = thriftDefaultBufferSize;
        this.thriftMaxFrameSize = thriftMaxFrameSize;
        this.enableCacheLeader = enableCacheLeader;
        this.version = version;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public synchronized void open() throws IoTDBConnectionException {
        this.open(false, 0);
    }

    public synchronized void open(boolean enableRPCCompression) throws IoTDBConnectionException {
        this.open(enableRPCCompression, 0);
    }

    public synchronized void open(boolean enableRPCCompression, int connectionTimeoutInMs) throws IoTDBConnectionException {
        if (!this.isClosed) {
            return;
        }
        this.enableRPCCompression = enableRPCCompression;
        this.connectionTimeoutInMs = connectionTimeoutInMs;
        this.defaultSessionConnection = this.constructSessionConnection(this, this.defaultEndPoint, this.zoneId);
        this.defaultSessionConnection.setEnableRedirect(this.enableQueryRedirection);
        this.metaSessionConnection = this.defaultSessionConnection;
        this.isClosed = false;
        if (this.enableCacheLeader || this.enableQueryRedirection) {
            this.deviceIdToEndpoint = new ConcurrentHashMap<String, EndPoint>();
            this.endPointToSessionConnection = new ConcurrentHashMap<EndPoint, SessionConnection>();
            this.endPointToSessionConnection.put(this.defaultEndPoint, this.defaultSessionConnection);
        }
    }

    public synchronized void close() throws IoTDBConnectionException {
        if (this.isClosed) {
            return;
        }
        try {
            if (this.enableCacheLeader) {
                for (SessionConnection sessionConnection : this.endPointToSessionConnection.values()) {
                    sessionConnection.close();
                }
            } else {
                this.defaultSessionConnection.close();
            }
        }
        finally {
            this.isClosed = true;
        }
    }

    public SessionConnection constructSessionConnection(Session session, EndPoint endpoint, ZoneId zoneId) throws IoTDBConnectionException {
        if (endpoint == null) {
            return new SessionConnection(session, zoneId);
        }
        return new SessionConnection(session, endpoint, zoneId);
    }

    public SystemStatus getSystemStatus() throws IoTDBConnectionException {
        return this.defaultSessionConnection.getSystemStatus();
    }

    public synchronized String getTimeZone() {
        return this.defaultSessionConnection.getTimeZone();
    }

    public synchronized void setTimeZone(String zoneId) throws StatementExecutionException, IoTDBConnectionException {
        this.defaultSessionConnection.setTimeZone(zoneId);
    }

    public void setStorageGroup(String storageGroup) throws IoTDBConnectionException, StatementExecutionException {
        try {
            this.metaSessionConnection.setStorageGroup(storageGroup);
        }
        catch (RedirectException e) {
            this.handleMetaRedirection(storageGroup, e);
        }
    }

    public void deleteStorageGroup(String storageGroup) throws IoTDBConnectionException, StatementExecutionException {
        try {
            this.metaSessionConnection.deleteStorageGroups(Collections.singletonList(storageGroup));
        }
        catch (RedirectException e) {
            this.handleMetaRedirection(storageGroup, e);
        }
    }

    public void deleteStorageGroups(List<String> storageGroups) throws IoTDBConnectionException, StatementExecutionException {
        try {
            this.metaSessionConnection.deleteStorageGroups(storageGroups);
        }
        catch (RedirectException e) {
            this.handleMetaRedirection(storageGroups.toString(), e);
        }
    }

    public void createTimeseries(String path, TSDataType dataType, TSEncoding encoding, CompressionType compressor) throws IoTDBConnectionException, StatementExecutionException {
        TSCreateTimeseriesReq request = this.genTSCreateTimeseriesReq(path, dataType, encoding, compressor, null, null, null, null);
        this.defaultSessionConnection.createTimeseries(request);
    }

    public void createTimeseries(String path, TSDataType dataType, TSEncoding encoding, CompressionType compressor, Map<String, String> props, Map<String, String> tags, Map<String, String> attributes, String measurementAlias) throws IoTDBConnectionException, StatementExecutionException {
        TSCreateTimeseriesReq request = this.genTSCreateTimeseriesReq(path, dataType, encoding, compressor, props, tags, attributes, measurementAlias);
        this.defaultSessionConnection.createTimeseries(request);
    }

    private TSCreateTimeseriesReq genTSCreateTimeseriesReq(String path, TSDataType dataType, TSEncoding encoding, CompressionType compressor, Map<String, String> props, Map<String, String> tags, Map<String, String> attributes, String measurementAlias) {
        TSCreateTimeseriesReq request = new TSCreateTimeseriesReq();
        request.setPath(path);
        request.setDataType(dataType.ordinal());
        request.setEncoding(encoding.ordinal());
        request.setCompressor(compressor.ordinal());
        request.setProps(props);
        request.setTags(tags);
        request.setAttributes(attributes);
        request.setMeasurementAlias(measurementAlias);
        return request;
    }

    public void createAlignedTimeseries(String deviceId, List<String> measurements, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors, List<String> measurementAliasList) throws IoTDBConnectionException, StatementExecutionException {
        TSCreateAlignedTimeseriesReq request = this.getTSCreateAlignedTimeseriesReq(deviceId, measurements, dataTypes, encodings, compressors, measurementAliasList);
        this.defaultSessionConnection.createAlignedTimeseries(request);
    }

    private TSCreateAlignedTimeseriesReq getTSCreateAlignedTimeseriesReq(String prefixPath, List<String> measurements, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors, List<String> measurementAliasList) {
        TSCreateAlignedTimeseriesReq request = new TSCreateAlignedTimeseriesReq();
        request.setPrefixPath(prefixPath);
        request.setMeasurements(measurements);
        request.setDataTypes(dataTypes.stream().map(Enum::ordinal).collect(Collectors.toList()));
        request.setEncodings(encodings.stream().map(Enum::ordinal).collect(Collectors.toList()));
        request.setCompressors(compressors.stream().map(Enum::ordinal).collect(Collectors.toList()));
        request.setMeasurementAlias(measurementAliasList);
        return request;
    }

    public void createMultiTimeseries(List<String> paths, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors, List<Map<String, String>> propsList, List<Map<String, String>> tagsList, List<Map<String, String>> attributesList, List<String> measurementAliasList) throws IoTDBConnectionException, StatementExecutionException {
        TSCreateMultiTimeseriesReq request = this.genTSCreateMultiTimeseriesReq(paths, dataTypes, encodings, compressors, propsList, tagsList, attributesList, measurementAliasList);
        this.defaultSessionConnection.createMultiTimeseries(request);
    }

    private TSCreateMultiTimeseriesReq genTSCreateMultiTimeseriesReq(List<String> paths, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors, List<Map<String, String>> propsList, List<Map<String, String>> tagsList, List<Map<String, String>> attributesList, List<String> measurementAliasList) {
        TSCreateMultiTimeseriesReq request = new TSCreateMultiTimeseriesReq();
        request.setPaths(paths);
        ArrayList<Integer> dataTypeOrdinals = new ArrayList<Integer>(dataTypes.size());
        for (TSDataType tSDataType : dataTypes) {
            dataTypeOrdinals.add(tSDataType.ordinal());
        }
        request.setDataTypes(dataTypeOrdinals);
        ArrayList<Integer> encodingOrdinals = new ArrayList<Integer>(dataTypes.size());
        for (TSEncoding encoding : encodings) {
            encodingOrdinals.add(encoding.ordinal());
        }
        request.setEncodings(encodingOrdinals);
        ArrayList<Integer> arrayList = new ArrayList<Integer>(paths.size());
        for (CompressionType compression : compressors) {
            arrayList.add(compression.ordinal());
        }
        request.setCompressors(arrayList);
        request.setPropsList(propsList);
        request.setTagsList(tagsList);
        request.setAttributesList(attributesList);
        request.setMeasurementAliasList(measurementAliasList);
        return request;
    }

    public boolean checkTimeseriesExists(String path) throws IoTDBConnectionException, StatementExecutionException {
        return this.defaultSessionConnection.checkTimeseriesExists(path, this.queryTimeoutInMs);
    }

    public void setQueryTimeout(long timeoutInMs) {
        this.queryTimeoutInMs = timeoutInMs;
    }

    public long getQueryTimeout() {
        return this.queryTimeoutInMs;
    }

    public SessionDataSet executeQueryStatement(String sql) throws StatementExecutionException, IoTDBConnectionException {
        return this.executeStatementMayRedirect(sql, this.queryTimeoutInMs);
    }

    public SessionDataSet executeQueryStatement(String sql, long timeoutInMs) throws StatementExecutionException, IoTDBConnectionException {
        return this.executeStatementMayRedirect(sql, timeoutInMs);
    }

    private SessionDataSet executeStatementMayRedirect(String sql, long timeoutInMs) throws StatementExecutionException, IoTDBConnectionException {
        try {
            logger.debug("{} execute sql {}", (Object)this.defaultSessionConnection.getEndPoint(), (Object)sql);
            return this.defaultSessionConnection.executeQueryStatement(sql, timeoutInMs);
        }
        catch (RedirectException e) {
            this.handleQueryRedirection(e.getEndPoint());
            if (this.enableQueryRedirection) {
                logger.debug("{} redirect query {} to {}", new Object[]{this.defaultSessionConnection.getEndPoint(), sql, e.getEndPoint()});
                try {
                    return this.defaultSessionConnection.executeQueryStatement(sql, this.queryTimeoutInMs);
                }
                catch (RedirectException redirectException) {
                    logger.error("{} redirect twice", (Object)sql, (Object)redirectException);
                    throw new StatementExecutionException(sql + " redirect twice, please try again.");
                }
            }
            throw new StatementExecutionException(MSG_DONOT_ENABLE_REDIRECT);
        }
    }

    public void executeNonQueryStatement(String sql) throws IoTDBConnectionException, StatementExecutionException {
        this.defaultSessionConnection.executeNonQueryStatement(sql);
    }

    public SessionDataSet executeRawDataQuery(List<String> paths, long startTime, long endTime) throws StatementExecutionException, IoTDBConnectionException {
        try {
            return this.defaultSessionConnection.executeRawDataQuery(paths, startTime, endTime);
        }
        catch (RedirectException e) {
            this.handleQueryRedirection(e.getEndPoint());
            if (this.enableQueryRedirection) {
                logger.debug("redirect query {} to {}", paths, (Object)e.getEndPoint());
                try {
                    return this.defaultSessionConnection.executeRawDataQuery(paths, startTime, endTime);
                }
                catch (RedirectException redirectException) {
                    logger.error("Redirect twice", (Throwable)redirectException);
                    throw new StatementExecutionException("Redirect twice, please try again.");
                }
            }
            throw new StatementExecutionException(MSG_DONOT_ENABLE_REDIRECT);
        }
    }

    public SessionDataSet executeLastDataQuery(List<String> paths, long LastTime) throws StatementExecutionException, IoTDBConnectionException {
        try {
            return this.defaultSessionConnection.executeLastDataQuery(paths, LastTime);
        }
        catch (RedirectException e) {
            this.handleQueryRedirection(e.getEndPoint());
            if (this.enableQueryRedirection) {
                try {
                    return this.defaultSessionConnection.executeLastDataQuery(paths, LastTime);
                }
                catch (RedirectException redirectException) {
                    logger.error("redirect twice", (Throwable)redirectException);
                    throw new StatementExecutionException("redirect twice, please try again.");
                }
            }
            throw new StatementExecutionException(MSG_DONOT_ENABLE_REDIRECT);
        }
    }

    public SessionDataSet executeLastDataQuery(List<String> paths) throws StatementExecutionException, IoTDBConnectionException {
        long time = 0L;
        return this.executeLastDataQuery(paths, time);
    }

    public void insertRecord(String deviceId, long time, List<String> measurements, List<TSDataType> types, Object ... values) throws IoTDBConnectionException, StatementExecutionException {
        TSInsertRecordReq request = this.genTSInsertRecordReq(deviceId, time, measurements, types, Arrays.asList(values), false);
        this.insertRecord(deviceId, request);
    }

    private void insertRecord(String prefixPath, TSInsertRecordReq request) throws IoTDBConnectionException, StatementExecutionException {
        try {
            this.getSessionConnection(prefixPath).insertRecord(request);
        }
        catch (RedirectException e) {
            this.handleRedirection(prefixPath, e.getEndPoint());
        }
    }

    private void insertRecord(String deviceId, TSInsertStringRecordReq request) throws IoTDBConnectionException, StatementExecutionException {
        try {
            this.getSessionConnection(deviceId).insertRecord(request);
        }
        catch (RedirectException e) {
            this.handleRedirection(deviceId, e.getEndPoint());
        }
    }

    private SessionConnection getSessionConnection(String deviceId) {
        EndPoint endPoint;
        if (this.enableCacheLeader && !this.deviceIdToEndpoint.isEmpty() && (endPoint = this.deviceIdToEndpoint.get(deviceId)) != null) {
            return this.endPointToSessionConnection.get(endPoint);
        }
        return this.defaultSessionConnection;
    }

    public String getTimestampPrecision() throws TException {
        return this.defaultSessionConnection.getClient().getProperties().getTimestampPrecision();
    }

    private void removeBrokenSessionConnection(SessionConnection sessionConnection) {
        if (this.enableCacheLeader) {
            Map.Entry<Object, Object> entry;
            EndPoint endPoint = null;
            Iterator<Map.Entry<Object, Object>> it = this.endPointToSessionConnection.entrySet().iterator();
            while (it.hasNext()) {
                entry = it.next();
                if (!entry.getValue().equals(sessionConnection)) continue;
                endPoint = entry.getKey();
                it.remove();
                break;
            }
            it = this.deviceIdToEndpoint.entrySet().iterator();
            while (it.hasNext()) {
                entry = it.next();
                if (!((EndPoint)entry.getValue()).equals(endPoint)) continue;
                it.remove();
            }
        }
    }

    private void handleMetaRedirection(String storageGroup, RedirectException e) throws IoTDBConnectionException {
        if (this.enableCacheLeader) {
            logger.debug("storageGroup[{}]:{}", (Object)storageGroup, (Object)e.getMessage());
            AtomicReference exceptionReference = new AtomicReference();
            SessionConnection connection = this.endPointToSessionConnection.computeIfAbsent(e.getEndPoint(), k -> {
                try {
                    return this.constructSessionConnection(this, e.getEndPoint(), this.zoneId);
                }
                catch (IoTDBConnectionException ex) {
                    exceptionReference.set(ex);
                    return null;
                }
            });
            if (connection == null) {
                throw new IoTDBConnectionException((Throwable)exceptionReference.get());
            }
            this.metaSessionConnection = connection;
        }
    }

    private void handleRedirection(String deviceId, EndPoint endpoint) throws IoTDBConnectionException {
        if (this.enableCacheLeader) {
            AtomicReference exceptionReference = new AtomicReference();
            this.deviceIdToEndpoint.put(deviceId, endpoint);
            SessionConnection connection = this.endPointToSessionConnection.computeIfAbsent(endpoint, k -> {
                try {
                    return this.constructSessionConnection(this, endpoint, this.zoneId);
                }
                catch (IoTDBConnectionException ex) {
                    exceptionReference.set(ex);
                    return null;
                }
            });
            if (connection == null) {
                this.deviceIdToEndpoint.remove(deviceId);
                throw new IoTDBConnectionException((Throwable)exceptionReference.get());
            }
        }
    }

    private void handleQueryRedirection(EndPoint endPoint) throws IoTDBConnectionException {
        if (this.enableQueryRedirection) {
            AtomicReference exceptionReference = new AtomicReference();
            SessionConnection connection = this.endPointToSessionConnection.computeIfAbsent(endPoint, k -> {
                try {
                    SessionConnection sessionConnection = this.constructSessionConnection(this, endPoint, this.zoneId);
                    sessionConnection.setEnableRedirect(this.enableQueryRedirection);
                    return sessionConnection;
                }
                catch (IoTDBConnectionException ex) {
                    exceptionReference.set(ex);
                    return null;
                }
            });
            if (connection == null) {
                throw new IoTDBConnectionException((Throwable)exceptionReference.get());
            }
            this.defaultSessionConnection = connection;
        }
    }

    public void insertRecord(String deviceId, long time, List<String> measurements, List<TSDataType> types, List<Object> values) throws IoTDBConnectionException, StatementExecutionException {
        TSInsertRecordReq request = this.genTSInsertRecordReq(deviceId, time, measurements, types, values, false);
        this.insertRecord(deviceId, request);
    }

    public void insertAlignedRecord(String deviceId, long time, List<String> measurements, List<TSDataType> types, List<Object> values) throws IoTDBConnectionException, StatementExecutionException {
        TSInsertRecordReq request = this.genTSInsertRecordReq(deviceId, time, measurements, types, values, true);
        this.insertRecord(deviceId, request);
    }

    private TSInsertRecordReq genTSInsertRecordReq(String prefixPath, long time, List<String> measurements, List<TSDataType> types, List<Object> values, boolean isAligned) throws IoTDBConnectionException {
        TSInsertRecordReq request = new TSInsertRecordReq();
        request.setPrefixPath(prefixPath);
        request.setTimestamp(time);
        request.setMeasurements(measurements);
        ByteBuffer buffer = SessionUtils.getValueBuffer(types, values);
        request.setValues(buffer);
        request.setIsAligned(isAligned);
        return request;
    }

    public void insertRecord(String deviceId, long time, List<String> measurements, List<String> values) throws IoTDBConnectionException, StatementExecutionException {
        TSInsertStringRecordReq request = this.genTSInsertStringRecordReq(deviceId, time, measurements, values, false);
        this.insertRecord(deviceId, request);
    }

    public void insertAlignedRecord(String deviceId, long time, List<String> measurements, List<String> values) throws IoTDBConnectionException, StatementExecutionException {
        TSInsertStringRecordReq request = this.genTSInsertStringRecordReq(deviceId, time, measurements, values, true);
        this.insertRecord(deviceId, request);
    }

    private TSInsertStringRecordReq genTSInsertStringRecordReq(String prefixPath, long time, List<String> measurements, List<String> values, boolean isAligned) {
        TSInsertStringRecordReq request = new TSInsertStringRecordReq();
        request.setPrefixPath(prefixPath);
        request.setTimestamp(time);
        request.setMeasurements(measurements);
        request.setValues(values);
        request.setIsAligned(isAligned);
        return request;
    }

    public void insertRecords(List<String> deviceIds, List<Long> times, List<List<String>> measurementsList, List<List<String>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        int len = deviceIds.size();
        if (len != times.size() || len != measurementsList.size() || len != valuesList.size()) {
            throw new IllegalArgumentException("deviceIds, times, measurementsList and valuesList's size should be equal");
        }
        if (this.enableCacheLeader) {
            this.insertStringRecordsWithLeaderCache(deviceIds, times, measurementsList, valuesList, false);
        } else {
            TSInsertStringRecordsReq request = this.genTSInsertStringRecordsReq(deviceIds, times, measurementsList, valuesList, false);
            try {
                this.defaultSessionConnection.insertRecords(request);
            }
            catch (RedirectException e) {
                Map<String, EndPoint> deviceEndPointMap = e.getDeviceEndPointMap();
                for (Map.Entry<String, EndPoint> deviceEndPointEntry : deviceEndPointMap.entrySet()) {
                    this.handleRedirection(deviceEndPointEntry.getKey(), deviceEndPointEntry.getValue());
                }
            }
        }
    }

    public void insertAlignedRecords(List<String> deviceIds, List<Long> times, List<List<String>> measurementsList, List<List<String>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        int len = deviceIds.size();
        if (len != times.size() || len != measurementsList.size() || len != valuesList.size()) {
            throw new IllegalArgumentException("prefixPaths, times, subMeasurementsList and valuesList's size should be equal");
        }
        if (this.enableCacheLeader) {
            this.insertStringRecordsWithLeaderCache(deviceIds, times, measurementsList, valuesList, true);
        } else {
            TSInsertStringRecordsReq request = this.genTSInsertStringRecordsReq(deviceIds, times, measurementsList, valuesList, true);
            try {
                this.defaultSessionConnection.insertRecords(request);
            }
            catch (RedirectException e) {
                Map<String, EndPoint> deviceEndPointMap = e.getDeviceEndPointMap();
                for (Map.Entry<String, EndPoint> deviceEndPointEntry : deviceEndPointMap.entrySet()) {
                    this.handleRedirection(deviceEndPointEntry.getKey(), deviceEndPointEntry.getValue());
                }
            }
        }
    }

    private void insertStringRecordsWithLeaderCache(List<String> deviceIds, List<Long> times, List<List<String>> measurementsList, List<List<String>> valuesList, boolean isAligned) throws IoTDBConnectionException, StatementExecutionException {
        HashMap<SessionConnection, TSInsertStringRecordsReq> recordsGroup = new HashMap<SessionConnection, TSInsertStringRecordsReq>();
        for (int i = 0; i < deviceIds.size(); ++i) {
            SessionConnection connection = this.getSessionConnection(deviceIds.get(i));
            TSInsertStringRecordsReq request = recordsGroup.computeIfAbsent(connection, k -> new TSInsertStringRecordsReq());
            request.setIsAligned(isAligned);
            this.updateTSInsertStringRecordsReq(request, deviceIds.get(i), times.get(i), measurementsList.get(i), valuesList.get(i));
        }
        this.insertByGroup(recordsGroup, SessionConnection::insertRecords);
    }

    private TSInsertStringRecordsReq genTSInsertStringRecordsReq(List<String> prefixPaths, List<Long> time, List<List<String>> measurements, List<List<String>> values, boolean isAligned) {
        TSInsertStringRecordsReq request = new TSInsertStringRecordsReq();
        request.setPrefixPaths(prefixPaths);
        request.setTimestamps(time);
        request.setMeasurementsList(measurements);
        request.setValuesList(values);
        request.setIsAligned(isAligned);
        return request;
    }

    private void updateTSInsertStringRecordsReq(TSInsertStringRecordsReq request, String deviceId, long time, List<String> measurements, List<String> values) {
        request.addToPrefixPaths(deviceId);
        request.addToTimestamps(time);
        request.addToMeasurementsList(measurements);
        request.addToValuesList(values);
    }

    public void insertRecords(List<String> deviceIds, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        int len = deviceIds.size();
        if (len != times.size() || len != measurementsList.size() || len != valuesList.size()) {
            throw new IllegalArgumentException("deviceIds, times, measurementsList and valuesList's size should be equal");
        }
        if (this.enableCacheLeader) {
            this.insertRecordsWithLeaderCache(deviceIds, times, measurementsList, typesList, valuesList, false);
        } else {
            TSInsertRecordsReq request = this.genTSInsertRecordsReq(deviceIds, times, measurementsList, typesList, valuesList, false);
            try {
                this.defaultSessionConnection.insertRecords(request);
            }
            catch (RedirectException e) {
                Map<String, EndPoint> deviceEndPointMap = e.getDeviceEndPointMap();
                for (Map.Entry<String, EndPoint> deviceEndPointEntry : deviceEndPointMap.entrySet()) {
                    this.handleRedirection(deviceEndPointEntry.getKey(), deviceEndPointEntry.getValue());
                }
            }
        }
    }

    public void insertAlignedRecords(List<String> deviceIds, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        int len = deviceIds.size();
        if (len != times.size() || len != measurementsList.size() || len != valuesList.size()) {
            throw new IllegalArgumentException("prefixPaths, times, subMeasurementsList and valuesList's size should be equal");
        }
        if (this.enableCacheLeader) {
            this.insertRecordsWithLeaderCache(deviceIds, times, measurementsList, typesList, valuesList, true);
        } else {
            TSInsertRecordsReq request = this.genTSInsertRecordsReq(deviceIds, times, measurementsList, typesList, valuesList, true);
            try {
                this.defaultSessionConnection.insertRecords(request);
            }
            catch (RedirectException e) {
                Map<String, EndPoint> deviceEndPointMap = e.getDeviceEndPointMap();
                for (Map.Entry<String, EndPoint> deviceEndPointEntry : deviceEndPointMap.entrySet()) {
                    this.handleRedirection(deviceEndPointEntry.getKey(), deviceEndPointEntry.getValue());
                }
            }
        }
    }

    public void insertRecordsOfOneDevice(String deviceId, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        this.insertRecordsOfOneDevice(deviceId, times, measurementsList, typesList, valuesList, false);
    }

    public void insertRecordsOfOneDevice(String deviceId, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList, boolean haveSorted) throws IoTDBConnectionException, StatementExecutionException {
        int len = times.size();
        if (len != measurementsList.size() || len != valuesList.size()) {
            throw new IllegalArgumentException("times, measurementsList and valuesList's size should be equal");
        }
        TSInsertRecordsOfOneDeviceReq request = this.genTSInsertRecordsOfOneDeviceReq(deviceId, times, measurementsList, typesList, valuesList, haveSorted, false);
        try {
            this.getSessionConnection(deviceId).insertRecordsOfOneDevice(request);
        }
        catch (RedirectException e) {
            this.handleRedirection(deviceId, e.getEndPoint());
        }
    }

    public void insertStringRecordsOfOneDevice(String deviceId, List<Long> times, List<List<String>> measurementsList, List<List<String>> valuesList, boolean haveSorted) throws IoTDBConnectionException, StatementExecutionException {
        int len = times.size();
        if (len != measurementsList.size() || len != valuesList.size()) {
            throw new IllegalArgumentException("times, measurementsList and valuesList's size should be equal");
        }
        TSInsertStringRecordsOfOneDeviceReq req = this.genTSInsertStringRecordsOfOneDeviceReq(deviceId, times, measurementsList, valuesList, haveSorted, false);
        try {
            this.getSessionConnection(deviceId).insertStringRecordsOfOneDevice(req);
        }
        catch (RedirectException e) {
            this.handleRedirection(deviceId, e.getEndPoint());
        }
    }

    public void insertStringRecordsOfOneDevice(String deviceId, List<Long> times, List<List<String>> measurementsList, List<List<String>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        this.insertStringRecordsOfOneDevice(deviceId, times, measurementsList, valuesList, false);
    }

    public void insertAlignedRecordsOfOneDevice(String deviceId, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        this.insertAlignedRecordsOfOneDevice(deviceId, times, measurementsList, typesList, valuesList, false);
    }

    public void insertAlignedRecordsOfOneDevice(String deviceId, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList, boolean haveSorted) throws IoTDBConnectionException, StatementExecutionException {
        int len = times.size();
        if (len != measurementsList.size() || len != valuesList.size()) {
            throw new IllegalArgumentException("times, subMeasurementsList and valuesList's size should be equal");
        }
        TSInsertRecordsOfOneDeviceReq request = this.genTSInsertRecordsOfOneDeviceReq(deviceId, times, measurementsList, typesList, valuesList, haveSorted, true);
        try {
            this.getSessionConnection(deviceId).insertRecordsOfOneDevice(request);
        }
        catch (RedirectException e) {
            this.handleRedirection(deviceId, e.getEndPoint());
        }
    }

    public void insertAlignedStringRecordsOfOneDevice(String deviceId, List<Long> times, List<List<String>> measurementsList, List<List<String>> valuesList, boolean haveSorted) throws IoTDBConnectionException, StatementExecutionException {
        int len = times.size();
        if (len != measurementsList.size() || len != valuesList.size()) {
            throw new IllegalArgumentException("times, measurementsList and valuesList's size should be equal");
        }
        TSInsertStringRecordsOfOneDeviceReq req = this.genTSInsertStringRecordsOfOneDeviceReq(deviceId, times, measurementsList, valuesList, haveSorted, true);
        try {
            this.getSessionConnection(deviceId).insertStringRecordsOfOneDevice(req);
        }
        catch (RedirectException e) {
            this.handleRedirection(deviceId, e.getEndPoint());
        }
    }

    public void insertAlignedStringRecordsOfOneDevice(String deviceId, List<Long> times, List<List<String>> measurementsList, List<List<String>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        this.insertAlignedStringRecordsOfOneDevice(deviceId, times, measurementsList, valuesList, false);
    }

    private TSInsertRecordsOfOneDeviceReq genTSInsertRecordsOfOneDeviceReq(String prefixPath, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList, boolean haveSorted, boolean isAligned) throws IoTDBConnectionException, BatchExecutionException {
        int len = times.size();
        if (len != measurementsList.size() || len != valuesList.size()) {
            throw new IllegalArgumentException("times, measurementsList and valuesList's size should be equal");
        }
        if (!this.checkSorted(times)) {
            Integer[] index = new Integer[times.size()];
            for (int i = 0; i < times.size(); ++i) {
                index[i] = i;
            }
            Arrays.sort(index, Comparator.comparingLong(times::get));
            times.sort(Long::compareTo);
            measurementsList = Session.sortList(measurementsList, index);
            typesList = Session.sortList(typesList, index);
            valuesList = Session.sortList(valuesList, index);
        }
        TSInsertRecordsOfOneDeviceReq request = new TSInsertRecordsOfOneDeviceReq();
        request.setPrefixPath(prefixPath);
        request.setTimestamps(times);
        request.setMeasurementsList(measurementsList);
        List<ByteBuffer> buffersList = this.objectValuesListToByteBufferList(valuesList, typesList);
        request.setValuesList(buffersList);
        request.setIsAligned(isAligned);
        return request;
    }

    private TSInsertStringRecordsOfOneDeviceReq genTSInsertStringRecordsOfOneDeviceReq(String prefixPath, List<Long> times, List<List<String>> measurementsList, List<List<String>> valuesList, boolean haveSorted, boolean isAligned) {
        int len = times.size();
        if (len != measurementsList.size() || len != valuesList.size()) {
            throw new IllegalArgumentException("times, measurementsList and valuesList's size should be equal");
        }
        if (!this.checkSorted(times)) {
            Integer[] index = new Integer[times.size()];
            for (int i = 0; i < index.length; ++i) {
                index[i] = i;
            }
            Arrays.sort(index, Comparator.comparingLong(times::get));
            times.sort(Long::compareTo);
            measurementsList = Session.sortList(measurementsList, index);
            valuesList = Session.sortList(valuesList, index);
        }
        TSInsertStringRecordsOfOneDeviceReq req = new TSInsertStringRecordsOfOneDeviceReq();
        req.setPrefixPath(prefixPath);
        req.setTimestamps(times);
        req.setMeasurementsList(measurementsList);
        req.setValuesList(valuesList);
        req.setIsAligned(isAligned);
        return req;
    }

    private static <T> List<T> sortList(List<T> source, Integer[] index) {
        return Arrays.stream(index).map(source::get).collect(Collectors.toList());
    }

    private List<ByteBuffer> objectValuesListToByteBufferList(List<List<Object>> valuesList, List<List<TSDataType>> typesList) throws IoTDBConnectionException {
        ArrayList<ByteBuffer> buffersList = new ArrayList<ByteBuffer>();
        for (int i = 0; i < valuesList.size(); ++i) {
            ByteBuffer buffer = SessionUtils.getValueBuffer(typesList.get(i), valuesList.get(i));
            buffersList.add(buffer);
        }
        return buffersList;
    }

    private void insertRecordsWithLeaderCache(List<String> deviceIds, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList, boolean isAligned) throws IoTDBConnectionException, StatementExecutionException {
        HashMap<SessionConnection, TSInsertRecordsReq> recordsGroup = new HashMap<SessionConnection, TSInsertRecordsReq>();
        for (int i = 0; i < deviceIds.size(); ++i) {
            SessionConnection connection = this.getSessionConnection(deviceIds.get(i));
            TSInsertRecordsReq request = recordsGroup.computeIfAbsent(connection, k -> new TSInsertRecordsReq());
            request.setIsAligned(isAligned);
            this.updateTSInsertRecordsReq(request, deviceIds.get(i), times.get(i), measurementsList.get(i), typesList.get(i), valuesList.get(i));
        }
        this.insertByGroup(recordsGroup, SessionConnection::insertRecords);
    }

    private TSInsertRecordsReq genTSInsertRecordsReq(List<String> deviceIds, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList, boolean isAligned) throws IoTDBConnectionException {
        TSInsertRecordsReq request = new TSInsertRecordsReq();
        request.setPrefixPaths(deviceIds);
        request.setTimestamps(times);
        request.setMeasurementsList(measurementsList);
        request.setIsAligned(isAligned);
        List<ByteBuffer> buffersList = this.objectValuesListToByteBufferList(valuesList, typesList);
        request.setValuesList(buffersList);
        return request;
    }

    private void updateTSInsertRecordsReq(TSInsertRecordsReq request, String deviceId, Long time, List<String> measurements, List<TSDataType> types, List<Object> values) throws IoTDBConnectionException {
        request.addToPrefixPaths(deviceId);
        request.addToTimestamps(time);
        request.addToMeasurementsList(measurements);
        ByteBuffer buffer = SessionUtils.getValueBuffer(types, values);
        request.addToValuesList(buffer);
    }

    public void insertTablet(Tablet tablet) throws StatementExecutionException, IoTDBConnectionException {
        this.insertTablet(tablet, false);
    }

    public void insertTablet(Tablet tablet, boolean sorted) throws IoTDBConnectionException, StatementExecutionException {
        TSInsertTabletReq request = this.genTSInsertTabletReq(tablet, sorted, false);
        try {
            this.getSessionConnection(tablet.deviceId).insertTablet(request);
        }
        catch (RedirectException e) {
            this.handleRedirection(tablet.deviceId, e.getEndPoint());
        }
    }

    public void insertAlignedTablet(Tablet tablet) throws StatementExecutionException, IoTDBConnectionException {
        this.insertAlignedTablet(tablet, false);
    }

    public void insertAlignedTablet(Tablet tablet, boolean sorted) throws IoTDBConnectionException, StatementExecutionException {
        TSInsertTabletReq request = this.genTSInsertTabletReq(tablet, sorted, true);
        try {
            this.getSessionConnection(tablet.deviceId).insertTablet(request);
        }
        catch (RedirectException e) {
            this.handleRedirection(tablet.deviceId, e.getEndPoint());
        }
    }

    private TSInsertTabletReq genTSInsertTabletReq(Tablet tablet, boolean sorted, boolean isAligned) throws BatchExecutionException {
        if (!this.checkSorted(tablet)) {
            this.sortTablet(tablet);
        }
        TSInsertTabletReq request = new TSInsertTabletReq();
        for (IMeasurementSchema iMeasurementSchema : tablet.getSchemas()) {
            request.addToMeasurements(iMeasurementSchema.getMeasurementId());
            request.addToTypes(iMeasurementSchema.getType().ordinal());
        }
        request.setPrefixPath(tablet.deviceId);
        request.setIsAligned(isAligned);
        request.setTimestamps(SessionUtils.getTimeBuffer(tablet));
        request.setValues(SessionUtils.getValueBuffer(tablet));
        request.setSize(tablet.rowSize);
        return request;
    }

    public void insertTablets(Map<String, Tablet> tablets) throws IoTDBConnectionException, StatementExecutionException {
        this.insertTablets(tablets, false);
    }

    public void insertTablets(Map<String, Tablet> tablets, boolean sorted) throws IoTDBConnectionException, StatementExecutionException {
        if (this.enableCacheLeader) {
            this.insertTabletsWithLeaderCache(tablets, sorted, false);
        } else {
            TSInsertTabletsReq request = this.genTSInsertTabletsReq(new ArrayList<Tablet>(tablets.values()), sorted, false);
            try {
                this.defaultSessionConnection.insertTablets(request);
            }
            catch (RedirectException e) {
                Map<String, EndPoint> deviceEndPointMap = e.getDeviceEndPointMap();
                for (Map.Entry<String, EndPoint> deviceEndPointEntry : deviceEndPointMap.entrySet()) {
                    this.handleRedirection(deviceEndPointEntry.getKey(), deviceEndPointEntry.getValue());
                }
            }
        }
    }

    public void insertAlignedTablets(Map<String, Tablet> tablets) throws IoTDBConnectionException, StatementExecutionException {
        this.insertAlignedTablets(tablets, false);
    }

    public void insertAlignedTablets(Map<String, Tablet> tablets, boolean sorted) throws IoTDBConnectionException, StatementExecutionException {
        if (this.enableCacheLeader) {
            this.insertTabletsWithLeaderCache(tablets, sorted, true);
        } else {
            TSInsertTabletsReq request = this.genTSInsertTabletsReq(new ArrayList<Tablet>(tablets.values()), sorted, true);
            try {
                this.defaultSessionConnection.insertTablets(request);
            }
            catch (RedirectException e) {
                Map<String, EndPoint> deviceEndPointMap = e.getDeviceEndPointMap();
                for (Map.Entry<String, EndPoint> deviceEndPointEntry : deviceEndPointMap.entrySet()) {
                    this.handleRedirection(deviceEndPointEntry.getKey(), deviceEndPointEntry.getValue());
                }
            }
        }
    }

    private void insertTabletsWithLeaderCache(Map<String, Tablet> tablets, boolean sorted, boolean isAligned) throws IoTDBConnectionException, StatementExecutionException {
        HashMap<SessionConnection, TSInsertTabletsReq> tabletGroup = new HashMap<SessionConnection, TSInsertTabletsReq>();
        for (Map.Entry<String, Tablet> entry : tablets.entrySet()) {
            SessionConnection connection = this.getSessionConnection(entry.getKey());
            TSInsertTabletsReq request = tabletGroup.computeIfAbsent(connection, k -> new TSInsertTabletsReq());
            this.updateTSInsertTabletsReq(request, entry.getValue(), sorted, isAligned);
        }
        this.insertByGroup(tabletGroup, SessionConnection::insertTablets);
    }

    private TSInsertTabletsReq genTSInsertTabletsReq(List<Tablet> tablets, boolean sorted, boolean isAligned) throws BatchExecutionException {
        TSInsertTabletsReq request = new TSInsertTabletsReq();
        if (tablets.isEmpty()) {
            throw new BatchExecutionException("No tablet is inserting!");
        }
        for (Tablet tablet : tablets) {
            this.updateTSInsertTabletsReq(request, tablet, sorted, isAligned);
        }
        return request;
    }

    private void updateTSInsertTabletsReq(TSInsertTabletsReq request, Tablet tablet, boolean sorted, boolean isAligned) throws BatchExecutionException {
        if (!this.checkSorted(tablet)) {
            this.sortTablet(tablet);
        }
        request.addToPrefixPaths(tablet.deviceId);
        ArrayList<String> measurements = new ArrayList<String>();
        ArrayList<Integer> dataTypes = new ArrayList<Integer>();
        request.setIsAligned(isAligned);
        for (IMeasurementSchema iMeasurementSchema : tablet.getSchemas()) {
            measurements.add(iMeasurementSchema.getMeasurementId());
            dataTypes.add(iMeasurementSchema.getType().ordinal());
        }
        request.addToMeasurementsList(measurements);
        request.addToTypesList(dataTypes);
        request.addToTimestampsList(SessionUtils.getTimeBuffer(tablet));
        request.addToValuesList(SessionUtils.getValueBuffer(tablet));
        request.addToSizeList(tablet.rowSize);
    }

    public void testInsertTablet(Tablet tablet) throws IoTDBConnectionException, StatementExecutionException {
        this.testInsertTablet(tablet, false);
    }

    public void testInsertTablet(Tablet tablet, boolean sorted) throws IoTDBConnectionException, StatementExecutionException {
        TSInsertTabletReq request = this.genTSInsertTabletReq(tablet, sorted, false);
        this.defaultSessionConnection.testInsertTablet(request);
    }

    public void testInsertTablets(Map<String, Tablet> tablets) throws IoTDBConnectionException, StatementExecutionException {
        this.testInsertTablets(tablets, false);
    }

    public void testInsertTablets(Map<String, Tablet> tablets, boolean sorted) throws IoTDBConnectionException, StatementExecutionException {
        TSInsertTabletsReq request = this.genTSInsertTabletsReq(new ArrayList<Tablet>(tablets.values()), sorted, false);
        this.defaultSessionConnection.testInsertTablets(request);
    }

    public void testInsertRecords(List<String> deviceIds, List<Long> times, List<List<String>> measurementsList, List<List<String>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        TSInsertStringRecordsReq request = this.genTSInsertStringRecordsReq(deviceIds, times, measurementsList, valuesList, false);
        this.defaultSessionConnection.testInsertRecords(request);
    }

    public void testInsertRecords(List<String> deviceIds, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        TSInsertRecordsReq request = this.genTSInsertRecordsReq(deviceIds, times, measurementsList, typesList, valuesList, false);
        this.defaultSessionConnection.testInsertRecords(request);
    }

    public void testInsertRecord(String deviceId, long time, List<String> measurements, List<String> values) throws IoTDBConnectionException, StatementExecutionException {
        TSInsertStringRecordReq request = this.genTSInsertStringRecordReq(deviceId, time, measurements, values, false);
        this.defaultSessionConnection.testInsertRecord(request);
    }

    public void testInsertRecord(String deviceId, long time, List<String> measurements, List<TSDataType> types, List<Object> values) throws IoTDBConnectionException, StatementExecutionException {
        TSInsertRecordReq request = this.genTSInsertRecordReq(deviceId, time, measurements, types, values, false);
        this.defaultSessionConnection.testInsertRecord(request);
    }

    public void deleteTimeseries(String path) throws IoTDBConnectionException, StatementExecutionException {
        this.defaultSessionConnection.deleteTimeseries(Collections.singletonList(path));
    }

    public void deleteTimeseries(List<String> paths) throws IoTDBConnectionException, StatementExecutionException {
        this.defaultSessionConnection.deleteTimeseries(paths);
    }

    public void deleteData(String path, long endTime) throws IoTDBConnectionException, StatementExecutionException {
        this.deleteData(Collections.singletonList(path), Long.MIN_VALUE, endTime);
    }

    public void deleteData(List<String> paths, long endTime) throws IoTDBConnectionException, StatementExecutionException {
        this.deleteData(paths, Long.MIN_VALUE, endTime);
    }

    public void deleteData(List<String> paths, long startTime, long endTime) throws IoTDBConnectionException, StatementExecutionException {
        TSDeleteDataReq request = this.genTSDeleteDataReq(paths, startTime, endTime);
        this.defaultSessionConnection.deleteData(request);
    }

    private TSDeleteDataReq genTSDeleteDataReq(List<String> paths, long startTime, long endTime) {
        TSDeleteDataReq request = new TSDeleteDataReq();
        request.setPaths(paths);
        request.setStartTime(startTime);
        request.setEndTime(endTime);
        return request;
    }

    private boolean checkSorted(Tablet tablet) {
        for (int i = 1; i < tablet.rowSize; ++i) {
            if (tablet.timestamps[i] >= tablet.timestamps[i - 1]) continue;
            return false;
        }
        return true;
    }

    private boolean checkSorted(List<Long> times) {
        for (int i = 1; i < times.size(); ++i) {
            if (times.get(i) >= times.get(i - 1)) continue;
            return false;
        }
        return true;
    }

    private void checkSortedThrowable(Tablet tablet) throws BatchExecutionException {
        if (!this.checkSorted(tablet)) {
            throw new BatchExecutionException("Times in Tablet are not in ascending order");
        }
    }

    protected void sortTablet(Tablet tablet) {
        Integer[] index = new Integer[tablet.rowSize];
        for (int i = 0; i < tablet.rowSize; ++i) {
            index[i] = i;
        }
        Arrays.sort(index, Comparator.comparingLong(o -> tablet.timestamps[o]));
        Arrays.sort(tablet.timestamps, 0, tablet.rowSize);
        int columnIndex = 0;
        for (int i = 0; i < tablet.getSchemas().size(); ++i) {
            IMeasurementSchema schema = tablet.getSchemas().get(i);
            if (schema instanceof MeasurementSchema) {
                tablet.values[columnIndex] = this.sortList(tablet.values[columnIndex], schema.getType(), index);
                if (tablet.bitMaps != null && tablet.bitMaps[columnIndex] != null) {
                    tablet.bitMaps[columnIndex] = this.sortBitMap(tablet.bitMaps[columnIndex], index);
                }
                ++columnIndex;
                continue;
            }
            int measurementSize = schema.getSubMeasurementsList().size();
            for (int j = 0; j < measurementSize; ++j) {
                tablet.values[columnIndex] = this.sortList(tablet.values[columnIndex], schema.getSubMeasurementsTSDataTypeList().get(j), index);
                if (tablet.bitMaps != null && tablet.bitMaps[columnIndex] != null) {
                    tablet.bitMaps[columnIndex] = this.sortBitMap(tablet.bitMaps[columnIndex], index);
                }
                ++columnIndex;
            }
        }
    }

    private Object sortList(Object valueList, TSDataType dataType, Integer[] index) {
        switch (dataType) {
            case BOOLEAN: {
                boolean[] boolValues = (boolean[])valueList;
                boolean[] sortedValues = new boolean[boolValues.length];
                for (int i = 0; i < index.length; ++i) {
                    sortedValues[i] = boolValues[index[i]];
                }
                return sortedValues;
            }
            case INT32: {
                int[] intValues = (int[])valueList;
                int[] sortedIntValues = new int[intValues.length];
                for (int i = 0; i < index.length; ++i) {
                    sortedIntValues[i] = intValues[index[i]];
                }
                return sortedIntValues;
            }
            case INT64: {
                long[] longValues = (long[])valueList;
                long[] sortedLongValues = new long[longValues.length];
                for (int i = 0; i < index.length; ++i) {
                    sortedLongValues[i] = longValues[index[i]];
                }
                return sortedLongValues;
            }
            case FLOAT: {
                float[] floatValues = (float[])valueList;
                float[] sortedFloatValues = new float[floatValues.length];
                for (int i = 0; i < index.length; ++i) {
                    sortedFloatValues[i] = floatValues[index[i]];
                }
                return sortedFloatValues;
            }
            case DOUBLE: {
                double[] doubleValues = (double[])valueList;
                double[] sortedDoubleValues = new double[doubleValues.length];
                for (int i = 0; i < index.length; ++i) {
                    sortedDoubleValues[i] = doubleValues[index[i]];
                }
                return sortedDoubleValues;
            }
            case TEXT: {
                Binary[] binaryValues = (Binary[])valueList;
                Binary[] sortedBinaryValues = new Binary[binaryValues.length];
                for (int i = 0; i < index.length; ++i) {
                    sortedBinaryValues[i] = binaryValues[index[i]];
                }
                return sortedBinaryValues;
            }
        }
        throw new UnSupportedDataTypeException(MSG_UNSUPPORTED_DATA_TYPE + (Object)((Object)dataType));
    }

    private BitMap sortBitMap(BitMap bitMap, Integer[] index) {
        BitMap sortedBitMap = new BitMap(bitMap.getSize());
        for (int i = 0; i < index.length; ++i) {
            if (!bitMap.isMarked(index[i])) continue;
            sortedBitMap.mark(i);
        }
        return sortedBitMap;
    }

    public void setSchemaTemplate(String templateName, String prefixPath) throws IoTDBConnectionException, StatementExecutionException {
        TSSetSchemaTemplateReq request = this.getTSSetSchemaTemplateReq(templateName, prefixPath);
        this.defaultSessionConnection.setSchemaTemplate(request);
    }

    public void createSchemaTemplate(Template template) throws IOException, IoTDBConnectionException, StatementExecutionException {
        TSCreateSchemaTemplateReq req = new TSCreateSchemaTemplateReq();
        req.setName(template.getName());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        template.serialize(baos);
        req.setSerializedTemplate(baos.toByteArray());
        baos.close();
        this.defaultSessionConnection.createSchemaTemplate(req);
    }

    public void createSchemaTemplate(String templateName, List<String> measurements, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors, boolean isAligned) throws IOException, IoTDBConnectionException, StatementExecutionException {
        Template temp = new Template(templateName, isAligned);
        int len = measurements.size();
        if (len != dataTypes.size() || len != encodings.size() || len != compressors.size()) {
            throw new StatementExecutionException("Different length of measurements, datatypes, encodings or compressors when create schema tempalte.");
        }
        for (int idx = 0; idx < measurements.size(); ++idx) {
            MeasurementNode mNode = new MeasurementNode(measurements.get(idx), dataTypes.get(idx), encodings.get(idx), compressors.get(idx));
            temp.addToTemplate(mNode);
        }
        this.createSchemaTemplate(temp);
    }

    @Deprecated
    public void createSchemaTemplate(String name, List<String> schemaNames, List<List<String>> measurements, List<List<TSDataType>> dataTypes, List<List<TSEncoding>> encodings, List<CompressionType> compressors) throws IoTDBConnectionException, StatementExecutionException {
        ArrayList<String> flatMeasurements = new ArrayList<String>();
        ArrayList<TSDataType> flatDataTypes = new ArrayList<TSDataType>();
        ArrayList<TSEncoding> flatEncodings = new ArrayList<TSEncoding>();
        for (int idx = 0; idx < measurements.size(); ++idx) {
            flatMeasurements.add(measurements.get(idx).get(0));
            flatDataTypes.add(dataTypes.get(idx).get(0));
            flatEncodings.add(encodings.get(idx).get(0));
        }
        try {
            this.createSchemaTemplate(name, flatMeasurements, flatDataTypes, flatEncodings, compressors, false);
        }
        catch (IOException e) {
            throw new StatementExecutionException(e.getMessage());
        }
    }

    public void addAlignedMeasurementsInTemplate(String templateName, List<String> measurementsPath, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors) throws IOException, IoTDBConnectionException, StatementExecutionException {
        TSAppendSchemaTemplateReq req = new TSAppendSchemaTemplateReq();
        req.setName(templateName);
        req.setMeasurements(measurementsPath);
        req.setDataTypes(dataTypes.stream().map(Enum::ordinal).collect(Collectors.toList()));
        req.setEncodings(encodings.stream().map(Enum::ordinal).collect(Collectors.toList()));
        req.setCompressors(compressors.stream().map(Enum::ordinal).collect(Collectors.toList()));
        req.setIsAligned(true);
        this.defaultSessionConnection.appendSchemaTemplate(req);
    }

    public void addAlignedMeasurementInTemplate(String templateName, String measurementPath, TSDataType dataType, TSEncoding encoding, CompressionType compressor) throws IOException, IoTDBConnectionException, StatementExecutionException {
        TSAppendSchemaTemplateReq req = new TSAppendSchemaTemplateReq();
        req.setName(templateName);
        req.setMeasurements(Collections.singletonList(measurementPath));
        req.setDataTypes(Collections.singletonList(dataType.ordinal()));
        req.setEncodings(Collections.singletonList(encoding.ordinal()));
        req.setCompressors(Collections.singletonList(compressor.ordinal()));
        req.setIsAligned(true);
        this.defaultSessionConnection.appendSchemaTemplate(req);
    }

    public void addUnalignedMeasurementsInTemplate(String templateName, List<String> measurementsPath, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors) throws IOException, IoTDBConnectionException, StatementExecutionException {
        TSAppendSchemaTemplateReq req = new TSAppendSchemaTemplateReq();
        req.setName(templateName);
        req.setMeasurements(measurementsPath);
        req.setDataTypes(dataTypes.stream().map(Enum::ordinal).collect(Collectors.toList()));
        req.setEncodings(encodings.stream().map(Enum::ordinal).collect(Collectors.toList()));
        req.setCompressors(compressors.stream().map(Enum::ordinal).collect(Collectors.toList()));
        req.setIsAligned(false);
        this.defaultSessionConnection.appendSchemaTemplate(req);
    }

    public void addUnalignedMeasurementInTemplate(String templateName, String measurementPath, TSDataType dataType, TSEncoding encoding, CompressionType compressor) throws IOException, IoTDBConnectionException, StatementExecutionException {
        TSAppendSchemaTemplateReq req = new TSAppendSchemaTemplateReq();
        req.setName(templateName);
        req.setMeasurements(Collections.singletonList(measurementPath));
        req.setDataTypes(Collections.singletonList(dataType.ordinal()));
        req.setEncodings(Collections.singletonList(encoding.ordinal()));
        req.setCompressors(Collections.singletonList(compressor.ordinal()));
        req.setIsAligned(false);
        this.defaultSessionConnection.appendSchemaTemplate(req);
    }

    public void deleteNodeInTemplate(String templateName, String path) throws IOException, IoTDBConnectionException, StatementExecutionException {
        TSPruneSchemaTemplateReq req = new TSPruneSchemaTemplateReq();
        req.setName(templateName);
        req.setPath(path);
        this.defaultSessionConnection.pruneSchemaTemplate(req);
    }

    public int countMeasurementsInTemplate(String name) throws StatementExecutionException, IoTDBConnectionException {
        TSQueryTemplateReq req = new TSQueryTemplateReq();
        req.setName(name);
        req.setQueryType(TemplateQueryType.COUNT_MEASUREMENTS.ordinal());
        TSQueryTemplateResp resp = this.defaultSessionConnection.querySchemaTemplate(req);
        return resp.getCount();
    }

    public boolean isMeasurementInTemplate(String templateName, String path) throws StatementExecutionException, IoTDBConnectionException {
        TSQueryTemplateReq req = new TSQueryTemplateReq();
        req.setName(templateName);
        req.setQueryType(TemplateQueryType.IS_MEASUREMENT.ordinal());
        req.setMeasurement(path);
        TSQueryTemplateResp resp = this.defaultSessionConnection.querySchemaTemplate(req);
        return resp.result;
    }

    public boolean isPathExistInTemplate(String templateName, String path) throws StatementExecutionException, IoTDBConnectionException {
        TSQueryTemplateReq req = new TSQueryTemplateReq();
        req.setName(templateName);
        req.setQueryType(TemplateQueryType.PATH_EXIST.ordinal());
        req.setMeasurement(path);
        TSQueryTemplateResp resp = this.defaultSessionConnection.querySchemaTemplate(req);
        return resp.result;
    }

    public List<String> showMeasurementsInTemplate(String templateName) throws StatementExecutionException, IoTDBConnectionException {
        TSQueryTemplateReq req = new TSQueryTemplateReq();
        req.setName(templateName);
        req.setQueryType(TemplateQueryType.SHOW_MEASUREMENTS.ordinal());
        req.setMeasurement("");
        TSQueryTemplateResp resp = this.defaultSessionConnection.querySchemaTemplate(req);
        return resp.getMeasurements();
    }

    public List<String> showMeasurementsInTemplate(String templateName, String pattern) throws StatementExecutionException, IoTDBConnectionException {
        TSQueryTemplateReq req = new TSQueryTemplateReq();
        req.setName(templateName);
        req.setQueryType(TemplateQueryType.SHOW_MEASUREMENTS.ordinal());
        req.setMeasurement(pattern);
        TSQueryTemplateResp resp = this.defaultSessionConnection.querySchemaTemplate(req);
        return resp.getMeasurements();
    }

    public List<String> showAllTemplates() throws StatementExecutionException, IoTDBConnectionException {
        TSQueryTemplateReq req = new TSQueryTemplateReq();
        req.setName("");
        req.setQueryType(TemplateQueryType.SHOW_TEMPLATES.ordinal());
        TSQueryTemplateResp resp = this.defaultSessionConnection.querySchemaTemplate(req);
        return resp.getMeasurements();
    }

    public List<String> showPathsTemplateSetOn(String templateName) throws StatementExecutionException, IoTDBConnectionException {
        TSQueryTemplateReq req = new TSQueryTemplateReq();
        req.setName(templateName);
        req.setQueryType(TemplateQueryType.SHOW_SET_TEMPLATES.ordinal());
        TSQueryTemplateResp resp = this.defaultSessionConnection.querySchemaTemplate(req);
        return resp.getMeasurements();
    }

    public List<String> showPathsTemplateUsingOn(String templateName) throws StatementExecutionException, IoTDBConnectionException {
        TSQueryTemplateReq req = new TSQueryTemplateReq();
        req.setName(templateName);
        req.setQueryType(TemplateQueryType.SHOW_USING_TEMPLATES.ordinal());
        TSQueryTemplateResp resp = this.defaultSessionConnection.querySchemaTemplate(req);
        return resp.getMeasurements();
    }

    public void unsetSchemaTemplate(String prefixPath, String templateName) throws IoTDBConnectionException, StatementExecutionException {
        TSUnsetSchemaTemplateReq request = this.getTSUnsetSchemaTemplateReq(prefixPath, templateName);
        this.defaultSessionConnection.unsetSchemaTemplate(request);
    }

    public void createTimeseriesOfTemplateOnPath(String path) throws IoTDBConnectionException, StatementExecutionException {
        TSSetUsingTemplateReq request = new TSSetUsingTemplateReq();
        request.setDstPath(path);
        this.defaultSessionConnection.setUsingTemplate(request);
    }

    public void deactivateTemplateOn(String templateName, String prefixPath) throws IoTDBConnectionException, StatementExecutionException {
        this.defaultSessionConnection.deactivateTemplate(templateName, prefixPath);
    }

    public void dropSchemaTemplate(String templateName) throws IoTDBConnectionException, StatementExecutionException {
        TSDropSchemaTemplateReq request = this.getTSDropSchemaTemplateReq(templateName);
        this.defaultSessionConnection.dropSchemaTemplate(request);
    }

    private TSSetSchemaTemplateReq getTSSetSchemaTemplateReq(String templateName, String prefixPath) {
        TSSetSchemaTemplateReq request = new TSSetSchemaTemplateReq();
        request.setTemplateName(templateName);
        request.setPrefixPath(prefixPath);
        return request;
    }

    private TSUnsetSchemaTemplateReq getTSUnsetSchemaTemplateReq(String prefixPath, String templateName) {
        TSUnsetSchemaTemplateReq request = new TSUnsetSchemaTemplateReq();
        request.setPrefixPath(prefixPath);
        request.setTemplateName(templateName);
        return request;
    }

    private TSDropSchemaTemplateReq getTSDropSchemaTemplateReq(String templateName) {
        TSDropSchemaTemplateReq request = new TSDropSchemaTemplateReq();
        request.setTemplateName(templateName);
        return request;
    }

    private <T> void insertByGroup(Map<SessionConnection, T> recordsGroup, InsertConsumer<T> insertConsumer) throws IoTDBConnectionException, StatementExecutionException {
        List completableFutures = recordsGroup.entrySet().stream().map(entry -> {
            SessionConnection connection = (SessionConnection)entry.getKey();
            Object recordsReq = entry.getValue();
            return CompletableFuture.runAsync(() -> {
                try {
                    insertConsumer.insert(connection, recordsReq);
                }
                catch (RedirectException e) {
                    e.getDeviceEndPointMap().forEach((deviceId, endpoint) -> {
                        try {
                            this.handleRedirection((String)deviceId, (EndPoint)endpoint);
                        }
                        catch (IoTDBConnectionException ioTDBConnectionException) {
                            throw new CompletionException(ioTDBConnectionException);
                        }
                    });
                }
                catch (StatementExecutionException e) {
                    throw new CompletionException(e);
                }
                catch (IoTDBConnectionException e) {
                    this.removeBrokenSessionConnection(connection);
                    throw new CompletionException(e);
                }
            }, OPERATION_EXECUTOR);
        }).collect(Collectors.toList());
        StringBuilder errMsgBuilder = new StringBuilder();
        for (CompletableFuture completableFuture : completableFutures) {
            try {
                completableFuture.join();
            }
            catch (CompletionException completionException) {
                Throwable cause = completionException.getCause();
                if (cause instanceof IoTDBConnectionException) {
                    throw (IoTDBConnectionException)cause;
                }
                errMsgBuilder.append(cause.getMessage());
            }
        }
        if (errMsgBuilder.length() > 0) {
            throw new StatementExecutionException(errMsgBuilder.toString());
        }
    }

    public void operationSyncTransmit(ByteBuffer buffer) throws IoTDBConnectionException, StatementExecutionException {
        try {
            TSOperationSyncWriteReq request = this.genTSExecuteOperationSyncReq(buffer);
            this.defaultSessionConnection.executeOperationSync(request);
        }
        catch (RedirectException redirectException) {
            // empty catch block
        }
    }

    private TSOperationSyncWriteReq genTSExecuteOperationSyncReq(ByteBuffer buffer) {
        TSOperationSyncWriteReq request = new TSOperationSyncWriteReq();
        request.setOperationSyncType((byte)0);
        request.setPhysicalPlan(buffer);
        return request;
    }

    public boolean isEnableQueryRedirection() {
        return this.enableQueryRedirection;
    }

    public void setEnableQueryRedirection(boolean enableQueryRedirection) {
        this.enableQueryRedirection = enableQueryRedirection;
    }

    public boolean isEnableCacheLeader() {
        return this.enableCacheLeader;
    }

    public void setEnableCacheLeader(boolean enableCacheLeader) {
        this.enableCacheLeader = enableCacheLeader;
    }

    public static class Builder {
        private String host = "localhost";
        private int rpcPort = 6667;
        private String username = "root";
        private String password = "root";
        private int fetchSize = 5000;
        private ZoneId zoneId = null;
        private int thriftDefaultBufferSize = 1024;
        private int thriftMaxFrameSize = 0x4000000;
        private boolean enableCacheLeader = true;
        private Version version = Config.DEFAULT_VERSION;
        private List<String> nodeUrls = null;

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder port(int port) {
            this.rpcPort = port;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder fetchSize(int fetchSize) {
            this.fetchSize = fetchSize;
            return this;
        }

        public Builder zoneId(ZoneId zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public Builder thriftDefaultBufferSize(int thriftDefaultBufferSize) {
            this.thriftDefaultBufferSize = thriftDefaultBufferSize;
            return this;
        }

        public Builder thriftMaxFrameSize(int thriftMaxFrameSize) {
            this.thriftMaxFrameSize = thriftMaxFrameSize;
            return this;
        }

        public Builder enableCacheLeader(boolean enableCacheLeader) {
            this.enableCacheLeader = enableCacheLeader;
            return this;
        }

        public Builder nodeUrls(List<String> nodeUrls) {
            this.nodeUrls = nodeUrls;
            return this;
        }

        public Builder version(Version version) {
            this.version = version;
            return this;
        }

        public Session build() {
            if (!(this.nodeUrls == null || "localhost".equals(this.host) && this.rpcPort == 6667)) {
                throw new IllegalArgumentException("You should specify either nodeUrls or (host + rpcPort), but not both");
            }
            if (this.nodeUrls != null) {
                Session newSession = new Session(this.nodeUrls, this.username, this.password, this.fetchSize, this.zoneId, this.thriftDefaultBufferSize, this.thriftMaxFrameSize, this.enableCacheLeader, this.version);
                newSession.setEnableQueryRedirection(true);
                return newSession;
            }
            return new Session(this.host, this.rpcPort, this.username, this.password, this.fetchSize, this.zoneId, this.thriftDefaultBufferSize, this.thriftMaxFrameSize, this.enableCacheLeader, this.version);
        }
    }
}

