/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.google.sheets.source;

import java.util.Collections;
import java.util.List;
import org.apache.seatunnel.api.serialization.DeserializationSchema;
import org.apache.seatunnel.api.source.Boundedness;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.connectors.seatunnel.common.source.AbstractSingleSplitReader;
import org.apache.seatunnel.connectors.seatunnel.common.source.AbstractSingleSplitSource;
import org.apache.seatunnel.connectors.seatunnel.common.source.SingleSplitReaderContext;
import org.apache.seatunnel.connectors.seatunnel.google.sheets.config.SheetsParameters;
import org.apache.seatunnel.connectors.seatunnel.google.sheets.source.SheetsSourceReader;
import org.apache.seatunnel.format.json.JsonDeserializationSchema;

public class SheetsSource
extends AbstractSingleSplitSource<SeaTunnelRow> {
    private final CatalogTable catalogTable;
    private final SheetsParameters sheetsParameters;
    private final DeserializationSchema<SeaTunnelRow> deserializationSchema;

    public SheetsSource(CatalogTable catalogTable, SheetsParameters sheetsParameters) {
        this.catalogTable = catalogTable;
        this.sheetsParameters = sheetsParameters;
        this.deserializationSchema = new JsonDeserializationSchema(catalogTable, false, false);
    }

    public String getPluginName() {
        return "GoogleSheets";
    }

    public Boundedness getBoundedness() {
        return Boundedness.BOUNDED;
    }

    public List<CatalogTable> getProducedCatalogTables() {
        return Collections.singletonList(this.catalogTable);
    }

    @Override
    public AbstractSingleSplitReader<SeaTunnelRow> createReader(SingleSplitReaderContext readerContext) throws Exception {
        return new SheetsSourceReader(this.sheetsParameters, readerContext, this.deserializationSchema, this.catalogTable.getSeaTunnelRowType());
    }
}

