/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.source;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.apache.seatunnel.api.source.Collector;
import org.apache.seatunnel.api.source.SourceReader;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.connectors.seatunnel.file.source.reader.ReadStrategy;
import org.apache.seatunnel.connectors.seatunnel.file.source.split.FileSourceSplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseFileSourceReader
implements SourceReader<SeaTunnelRow, FileSourceSplit> {
    private static final Logger log = LoggerFactory.getLogger(BaseFileSourceReader.class);
    private final ReadStrategy readStrategy;
    private final SourceReader.Context context;
    private final Deque<FileSourceSplit> sourceSplits = new ConcurrentLinkedDeque<FileSourceSplit>();
    private volatile boolean noMoreSplit;

    public BaseFileSourceReader(ReadStrategy readStrategy, SourceReader.Context context) {
        this.readStrategy = readStrategy;
        this.context = context;
    }

    public void open() throws Exception {
    }

    public void close() throws IOException {
        this.readStrategy.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pollNext(Collector<SeaTunnelRow> output) throws Exception {
        Object object = output.getCheckpointLock();
        synchronized (object) {
            FileSourceSplit split = this.sourceSplits.poll();
            if (null != split) {
                try {
                    this.readStrategy.read(split.splitId(), "", output);
                }
                catch (Exception e) {
                    throw CommonError.fileOperationFailed((String)"SeaTunnel", (String)"read", (String)split.splitId(), (Throwable)e);
                }
            } else if (this.noMoreSplit && this.sourceSplits.isEmpty()) {
                log.info("Closed the bounded File source");
                this.context.signalNoMoreElement();
            } else {
                Thread.sleep(1000L);
            }
        }
    }

    public List<FileSourceSplit> snapshotState(long checkpointId) throws Exception {
        return new ArrayList<FileSourceSplit>(this.sourceSplits);
    }

    public void addSplits(List<FileSourceSplit> splits) {
        this.sourceSplits.addAll(splits);
    }

    public void handleNoMoreSplits() {
        this.noMoreSplit = true;
    }

    public void notifyCheckpointComplete(long checkpointId) throws Exception {
    }
}

