/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.excel;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.exception.ExcelDataConvertException;
import com.alibaba.excel.metadata.Cell;
import com.alibaba.excel.metadata.data.ReadCellData;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.seatunnel.api.source.Collector;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.connectors.seatunnel.file.excel.ExcelCellUtils;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelReaderListener
extends AnalysisEventListener<Map<Integer, Object>>
implements Serializable,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(ExcelReaderListener.class);
    private final String tableId;
    private final Collector<SeaTunnelRow> output;
    private int cellCount;
    private final ObjectMapper objectMapper = new ObjectMapper();
    protected Config pluginConfig;
    protected SeaTunnelRowType seaTunnelRowType;
    private SeaTunnelDataType<?>[] fieldTypes;
    private ExcelCellUtils excelCellUtils;
    Map<Integer, String> customHeaders = new HashMap<Integer, String>();

    public ExcelReaderListener(String tableId, Collector<SeaTunnelRow> output, ExcelCellUtils excelCellUtils, SeaTunnelRowType seaTunnelRowType) {
        this.tableId = tableId;
        this.output = output;
        this.excelCellUtils = excelCellUtils;
        this.seaTunnelRowType = seaTunnelRowType;
        this.fieldTypes = seaTunnelRowType.getFieldTypes();
    }

    public void invokeHead(Map<Integer, ReadCellData<?>> headMap, AnalysisContext context) {
        for (int i = 0; i < headMap.size(); ++i) {
            String header = headMap.get(i).getStringValue();
            if ("null".equals(header)) continue;
            this.customHeaders.put(i, header);
        }
    }

    public void invoke(Map<Integer, Object> data, AnalysisContext context) {
        this.cellCount = data.size();
        SeaTunnelRow seaTunnelRow = new SeaTunnelRow(this.fieldTypes.length);
        Map cellMap = context.readRowHolder().getCellMap();
        for (int i = 0; i < this.fieldTypes.length; ++i) {
            if (cellMap.get(i) == null) {
                seaTunnelRow.setField(i, null);
                continue;
            }
            Object cell = this.excelCellUtils.convert(data.get(i), this.fieldTypes[i], (Cell)cellMap.get(i));
            seaTunnelRow.setField(i, cell);
        }
        seaTunnelRow.setTableId(this.tableId);
        this.output.collect((Object)seaTunnelRow);
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
        log.info("excel parsing completed");
    }

    public void onException(Exception exception, AnalysisContext context) {
        log.debug("cell parsing exception :{}", (Object)exception.getMessage());
        if (exception instanceof ExcelDataConvertException) {
            ExcelDataConvertException excelDataConvertException = (ExcelDataConvertException)exception;
            log.debug("row:{},cell:{},data:{}", new Object[]{excelDataConvertException.getRowIndex(), excelDataConvertException.getColumnIndex(), excelDataConvertException.getCellData()});
        }
    }

    @Override
    public void close() throws IOException {
    }
}

