/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.source.reader;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.FileStatus;
import org.apache.seatunnel.api.source.Collector;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.connectors.seatunnel.file.config.ArchiveCompressFormat;
import org.apache.seatunnel.connectors.seatunnel.file.config.FileBaseSourceOptions;
import org.apache.seatunnel.connectors.seatunnel.file.config.FileFormat;
import org.apache.seatunnel.connectors.seatunnel.file.config.HadoopConf;
import org.apache.seatunnel.connectors.seatunnel.file.hadoop.HadoopFileSystemProxy;
import org.apache.seatunnel.connectors.seatunnel.file.source.reader.ReadStrategy;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReadStrategy
implements ReadStrategy {
    private static final Logger log = LoggerFactory.getLogger(AbstractReadStrategy.class);
    protected static final String[] TYPE_ARRAY_STRING = new String[0];
    protected static final Boolean[] TYPE_ARRAY_BOOLEAN = new Boolean[0];
    protected static final Byte[] TYPE_ARRAY_BYTE = new Byte[0];
    protected static final Short[] TYPE_ARRAY_SHORT = new Short[0];
    protected static final Integer[] TYPE_ARRAY_INTEGER = new Integer[0];
    protected static final Long[] TYPE_ARRAY_LONG = new Long[0];
    protected static final Float[] TYPE_ARRAY_FLOAT = new Float[0];
    protected static final Double[] TYPE_ARRAY_DOUBLE = new Double[0];
    protected static final BigDecimal[] TYPE_ARRAY_BIG_DECIMAL = new BigDecimal[0];
    protected static final LocalDate[] TYPE_ARRAY_LOCAL_DATE = new LocalDate[0];
    protected static final LocalDateTime[] TYPE_ARRAY_LOCAL_DATETIME = new LocalDateTime[0];
    protected HadoopConf hadoopConf;
    protected SeaTunnelRowType seaTunnelRowType;
    protected SeaTunnelRowType seaTunnelRowTypeWithPartition;
    protected Config pluginConfig;
    protected List<String> fileNames = new ArrayList<String>();
    protected List<String> readPartitions = new ArrayList<String>();
    protected List<String> readColumns = new ArrayList<String>();
    protected boolean isMergePartition = true;
    protected long skipHeaderNumber = (Long)FileBaseSourceOptions.SKIP_HEADER_ROW_NUMBER.defaultValue();
    protected transient boolean isKerberosAuthorization = false;
    protected String filenameExtension;
    protected HadoopFileSystemProxy hadoopFileSystemProxy;
    protected ArchiveCompressFormat archiveCompressFormat = (ArchiveCompressFormat)((Object)FileBaseSourceOptions.ARCHIVE_COMPRESS_CODEC.defaultValue());
    protected Pattern pattern;

    @Override
    public void init(HadoopConf conf) {
        this.hadoopConf = conf;
        this.hadoopFileSystemProxy = new HadoopFileSystemProxy(this.hadoopConf);
    }

    @Override
    public void setCatalogTable(CatalogTable catalogTable) {
        this.seaTunnelRowType = catalogTable.getSeaTunnelRowType();
        this.seaTunnelRowTypeWithPartition = this.mergePartitionTypes(this.fileNames.get(0), catalogTable.getSeaTunnelRowType());
    }

    boolean checkFileType(String path) {
        return true;
    }

    @Override
    public List<String> getFileNamesByPath(String path) throws IOException {
        FileStatus[] stats;
        ArrayList<String> fileNames = new ArrayList<String>();
        block0: for (FileStatus fileStatus : stats = this.hadoopFileSystemProxy.listStatus(path)) {
            if (fileStatus.isDirectory()) {
                if (fileStatus.getPath().getName().startsWith(".")) continue;
                fileNames.addAll(this.getFileNamesByPath(fileStatus.getPath().toString()));
                continue;
            }
            if (!fileStatus.isFile() || !this.filterFileByPattern(fileStatus) || fileStatus.getLen() <= 0L || fileStatus.getPath().getName().equals("_SUCCESS") || fileStatus.getPath().getName().startsWith(".")) continue;
            String filePath = fileStatus.getPath().toString();
            if (!this.readPartitions.isEmpty()) {
                for (String readPartition : this.readPartitions) {
                    if (!filePath.contains(readPartition)) continue;
                    fileNames.add(filePath);
                    this.fileNames.add(filePath);
                    continue block0;
                }
                continue;
            }
            fileNames.add(filePath);
            this.fileNames.add(filePath);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.filenameExtension)) {
            this.fileNames.removeIf(fileName -> !fileName.endsWith(this.filenameExtension));
            fileNames.removeIf(fileName -> !fileName.endsWith(this.filenameExtension));
        }
        return fileNames;
    }

    @Override
    public void setPluginConfig(Config pluginConfig) {
        this.pluginConfig = pluginConfig;
        if (pluginConfig.hasPath(FileBaseSourceOptions.ARCHIVE_COMPRESS_CODEC.key())) {
            String archiveCompressCodec = pluginConfig.getString(FileBaseSourceOptions.ARCHIVE_COMPRESS_CODEC.key());
            this.archiveCompressFormat = ArchiveCompressFormat.valueOf(archiveCompressCodec.toUpperCase());
        }
        if (pluginConfig.hasPath(FileBaseSourceOptions.PARSE_PARTITION_FROM_PATH.key())) {
            this.isMergePartition = pluginConfig.getBoolean(FileBaseSourceOptions.PARSE_PARTITION_FROM_PATH.key());
        }
        if (pluginConfig.hasPath(FileBaseSourceOptions.SKIP_HEADER_ROW_NUMBER.key())) {
            this.skipHeaderNumber = pluginConfig.getLong(FileBaseSourceOptions.SKIP_HEADER_ROW_NUMBER.key());
        }
        if (pluginConfig.hasPath(FileBaseSourceOptions.FILENAME_EXTENSION.key())) {
            this.filenameExtension = pluginConfig.getString(FileBaseSourceOptions.FILENAME_EXTENSION.key());
        }
        if (pluginConfig.hasPath(FileBaseSourceOptions.READ_PARTITIONS.key())) {
            this.readPartitions.addAll(pluginConfig.getStringList(FileBaseSourceOptions.READ_PARTITIONS.key()));
        }
        if (pluginConfig.hasPath(FileBaseSourceOptions.READ_COLUMNS.key())) {
            this.readColumns.addAll(pluginConfig.getStringList(FileBaseSourceOptions.READ_COLUMNS.key()));
        }
        if (pluginConfig.hasPath(FileBaseSourceOptions.FILE_FILTER_PATTERN.key())) {
            String filterPattern = pluginConfig.getString(FileBaseSourceOptions.FILE_FILTER_PATTERN.key());
            this.pattern = Pattern.compile(Matcher.quoteReplacement(filterPattern));
        }
    }

    @Override
    public SeaTunnelRowType getActualSeaTunnelRowTypeInfo() {
        return this.isMergePartition ? this.seaTunnelRowTypeWithPartition : this.seaTunnelRowType;
    }

    /*
     * Unable to fully structure code
     */
    protected void resolveArchiveCompressedInputStream(String path, String tableId, Collector<SeaTunnelRow> output, Map<String, String> partitionsMap, FileFormat fileFormat) throws IOException {
        switch (1.$SwitchMap$org$apache$seatunnel$connectors$seatunnel$file$config$ArchiveCompressFormat[this.archiveCompressFormat.ordinal()]) {
            case 1: {
                zis = new ZipInputStream((InputStream)this.hadoopFileSystemProxy.getInputStream(path));
                var7_10 = null;
                while ((entry = zis.getNextEntry()) != null) {
                    if (!entry.isDirectory() && this.checkFileType(entry.getName(), fileFormat)) {
                        this.readProcess(path, tableId, output, AbstractReadStrategy.copyInputStream(zis), partitionsMap, entry.getName());
                    }
                    zis.closeEntry();
                }
                if (zis == null) break;
                if (var7_10 == null) ** GOTO lbl19
                try {
                    zis.close();
                }
                catch (Throwable entry) {
                    var7_10.addSuppressed(entry);
                }
                break;
lbl19:
                // 1 sources

                zis.close();
                break;
                catch (Throwable entry) {
                    try {
                        var7_10 = entry;
                        throw entry;
                    }
                    catch (Throwable var9_24) {
                        if (zis != null) {
                            if (var7_10 != null) {
                                try {
                                    zis.close();
                                }
                                catch (Throwable var10_26) {
                                    var7_10.addSuppressed(var10_26);
                                }
                            } else {
                                zis.close();
                            }
                        }
                        throw var9_24;
                    }
                }
            }
            case 2: {
                tarInput = new TarArchiveInputStream((InputStream)this.hadoopFileSystemProxy.getInputStream(path));
                var7_11 = null;
                while ((entry = tarInput.getNextTarEntry()) != null) {
                    if (entry.isDirectory() || !this.checkFileType(entry.getName(), fileFormat)) continue;
                    this.readProcess(path, tableId, output, AbstractReadStrategy.copyInputStream((InputStream)tarInput), partitionsMap, entry.getName());
                }
                if (tarInput == null) break;
                if (var7_11 == null) ** GOTO lbl52
                try {
                    tarInput.close();
                }
                catch (Throwable entry) {
                    var7_11.addSuppressed(entry);
                }
                break;
lbl52:
                // 1 sources

                tarInput.close();
                break;
                catch (Throwable entry) {
                    try {
                        var7_11 = entry;
                        throw entry;
                    }
                    catch (Throwable var11_30) {
                        if (tarInput != null) {
                            if (var7_11 != null) {
                                try {
                                    tarInput.close();
                                }
                                catch (Throwable var12_31) {
                                    var7_11.addSuppressed(var12_31);
                                }
                            } else {
                                tarInput.close();
                            }
                        }
                        throw var11_30;
                    }
                }
            }
            case 3: {
                gzipIn = new GzipCompressorInputStream((InputStream)this.hadoopFileSystemProxy.getInputStream(path));
                var7_12 = null;
                tarIn = new TarArchiveInputStream((InputStream)gzipIn);
                var9_25 = null;
                try {
                    while ((entry = tarIn.getNextTarEntry()) != null) {
                        if (entry.isDirectory() || !this.checkFileType(entry.getName(), fileFormat)) continue;
                        this.readProcess(path, tableId, output, AbstractReadStrategy.copyInputStream((InputStream)tarIn), partitionsMap, entry.getName());
                    }
                }
                catch (Throwable var10_29) {
                    var9_25 = var10_29;
                    throw var10_29;
                }
                finally {
                    if (tarIn != null) {
                        if (var9_25 != null) {
                            try {
                                tarIn.close();
                            }
                            catch (Throwable var10_28) {
                                var9_25.addSuppressed(var10_28);
                            }
                        } else {
                            tarIn.close();
                        }
                    }
                }
                if (gzipIn == null) break;
                if (var7_12 == null) ** GOTO lbl103
                try {
                    gzipIn.close();
                }
                catch (Throwable tarIn) {
                    var7_12.addSuppressed(tarIn);
                }
                break;
lbl103:
                // 1 sources

                gzipIn.close();
                break;
                catch (Throwable tarIn) {
                    try {
                        var7_12 = tarIn;
                        throw tarIn;
                    }
                    catch (Throwable var15_34) {
                        if (gzipIn != null) {
                            if (var7_12 != null) {
                                try {
                                    gzipIn.close();
                                }
                                catch (Throwable var16_35) {
                                    var7_12.addSuppressed(var16_35);
                                }
                            } else {
                                gzipIn.close();
                            }
                        }
                        throw var15_34;
                    }
                }
            }
            case 4: {
                gzipIn = new GzipCompressorInputStream((InputStream)this.hadoopFileSystemProxy.getInputStream(path));
                parameters = gzipIn.getMetaData();
                fileName = parameters.getFilename();
                if (fileName != null) ** GOTO lbl131
                if (fileFormat != FileFormat.EXCEL) ** GOTO lbl130
                if (path.endsWith(".gz")) {
                    fileName = path.substring(0, path.length() - 3);
                } else {
                    throw new IllegalArgumentException("Excel file must have a .gz extension. File: " + path);
lbl130:
                    // 1 sources

                    fileName = path;
                }
lbl131:
                // 3 sources

                this.readProcess(path, tableId, output, AbstractReadStrategy.copyInputStream((InputStream)gzipIn), partitionsMap, fileName);
                break;
            }
            case 5: {
                this.readProcess(path, tableId, output, (InputStream)this.hadoopFileSystemProxy.getInputStream(path), partitionsMap, path);
                break;
            }
            default: {
                AbstractReadStrategy.log.warn("The file does not support this archive compress type: {}", (Object)this.archiveCompressFormat);
                this.readProcess(path, tableId, output, (InputStream)this.hadoopFileSystemProxy.getInputStream(path), partitionsMap, path);
            }
        }
    }

    protected void readProcess(String path, String tableId, Collector<SeaTunnelRow> output, InputStream inputStream, Map<String, String> partitionsMap, String currentFileName) throws IOException {
        throw new UnsupportedOperationException("The file does not support the compressed file reading");
    }

    protected Map<String, String> parsePartitionsByPath(String path) {
        LinkedHashMap<String, String> partitions = new LinkedHashMap<String, String>();
        Arrays.stream(path.split("/", -1)).filter(split -> split.contains("=")).map(split -> split.split("=", -1)).forEach(kv -> partitions.put(kv[0], kv[1]));
        return partitions;
    }

    protected SeaTunnelRowType mergePartitionTypes(String path, SeaTunnelRowType seaTunnelRowType) {
        Map<String, String> partitionsMap = this.parsePartitionsByPath(path);
        if (partitionsMap.isEmpty()) {
            return seaTunnelRowType;
        }
        String[] partitionNames = partitionsMap.keySet().toArray(TYPE_ARRAY_STRING);
        Object[] partitionTypes = new SeaTunnelDataType[partitionNames.length];
        Arrays.fill(partitionTypes, BasicType.STRING_TYPE);
        String[] fieldNames = seaTunnelRowType.getFieldNames();
        SeaTunnelDataType[] fieldTypes = seaTunnelRowType.getFieldTypes();
        String[] newFieldNames = new String[fieldNames.length + partitionNames.length];
        SeaTunnelDataType[] newFieldTypes = new SeaTunnelDataType[fieldTypes.length + partitionTypes.length];
        System.arraycopy(fieldNames, 0, newFieldNames, 0, fieldNames.length);
        System.arraycopy(partitionNames, 0, newFieldNames, fieldNames.length, partitionNames.length);
        System.arraycopy(fieldTypes, 0, newFieldTypes, 0, fieldTypes.length);
        System.arraycopy(partitionTypes, 0, newFieldTypes, fieldTypes.length, partitionTypes.length);
        return new SeaTunnelRowType(newFieldNames, newFieldTypes);
    }

    protected boolean filterFileByPattern(FileStatus fileStatus) {
        if (Objects.nonNull(this.pattern)) {
            return this.pattern.matcher(fileStatus.getPath().getName()).matches();
        }
        return true;
    }

    protected static InputStream copyInputStream(InputStream inputStream) throws IOException {
        int bytesRead;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            byteArrayOutputStream.write(buffer, 0, bytesRead);
        }
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    protected boolean checkFileType(String fileName, FileFormat fileFormat) {
        for (String suffix : fileFormat.getAllSuffix()) {
            if (!fileName.endsWith(suffix)) continue;
            return true;
        }
        log.warn("The {} file format is incorrect. Please check the format in the compressed file.", (Object)fileName);
        return false;
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.hadoopFileSystemProxy != null) {
                this.hadoopFileSystemProxy.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

