/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.source.reader;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.common.SeaTunnelAPIErrorCode;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.source.Collector;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.api.table.type.SqlType;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.common.utils.DateTimeUtils;
import org.apache.seatunnel.common.utils.DateUtils;
import org.apache.seatunnel.common.utils.TimeUtils;
import org.apache.seatunnel.connectors.seatunnel.file.config.BaseSourceConfigOptions;
import org.apache.seatunnel.connectors.seatunnel.file.config.FileFormat;
import org.apache.seatunnel.connectors.seatunnel.file.config.HadoopConf;
import org.apache.seatunnel.connectors.seatunnel.file.exception.FileConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.file.exception.FileConnectorException;
import org.apache.seatunnel.connectors.seatunnel.file.source.reader.AbstractReadStrategy;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlReadStrategy
extends AbstractReadStrategy {
    private static final Logger log = LoggerFactory.getLogger(XmlReadStrategy.class);
    private String tableRowName;
    private Boolean useAttrFormat;
    private String delimiter;
    private int fieldCount;
    private DateUtils.Formatter dateFormat;
    private DateTimeUtils.Formatter datetimeFormat;
    private TimeUtils.Formatter timeFormat;
    private String encoding = (String)BaseSourceConfigOptions.ENCODING.defaultValue();
    private final ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public void init(HadoopConf conf) {
        super.init(conf);
        this.preCheckAndInitializeConfiguration();
    }

    @Override
    public void read(String path, String tableId, Collector<SeaTunnelRow> output) throws IOException, FileConnectorException {
        Map<String, String> partitionsMap = this.parsePartitionsByPath(path);
        this.resolveArchiveCompressedInputStream(path, tableId, output, partitionsMap, FileFormat.XML);
    }

    @Override
    public void readProcess(String path, String tableId, Collector<SeaTunnelRow> output, InputStream inputStream, Map<String, String> partitionsMap, String currentFileName) throws IOException {
        Document document;
        SAXReader saxReader = new SAXReader();
        try {
            document = saxReader.read((Reader)new InputStreamReader(inputStream, this.encoding));
        }
        catch (DocumentException e) {
            throw new FileConnectorException(FileConnectorErrorCode.FILE_READ_FAILED, "Failed to read xml file: " + path, e);
        }
        Element rootElement = document.getRootElement();
        this.fieldCount = this.isMergePartition ? this.seaTunnelRowTypeWithPartition.getTotalFields() : this.seaTunnelRowType.getTotalFields();
        rootElement.selectNodes(this.getXPathExpression(this.tableRowName)).forEach(node -> {
            SeaTunnelRow seaTunnelRow = new SeaTunnelRow(this.fieldCount);
            List<Node> fields = new ArrayList(this.useAttrFormat != false ? ((Element)node).attributes() : node.selectNodes("./*")).stream().filter(field -> ArrayUtils.contains((Object[])this.seaTunnelRowType.getFieldNames(), (Object)field.getName())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(fields)) {
                return;
            }
            fields.forEach(field -> {
                int fieldIndex = ArrayUtils.indexOf((Object[])this.seaTunnelRowType.getFieldNames(), (Object)field.getName());
                seaTunnelRow.setField(fieldIndex, this.convert(field.getText(), this.seaTunnelRowType.getFieldTypes()[fieldIndex]));
            });
            if (this.isMergePartition) {
                int partitionIndex = this.seaTunnelRowType.getTotalFields();
                for (String value : partitionsMap.values()) {
                    seaTunnelRow.setField(partitionIndex++, (Object)value);
                }
            }
            seaTunnelRow.setTableId(tableId);
            output.collect((Object)seaTunnelRow);
        });
    }

    @Override
    public SeaTunnelRowType getSeaTunnelRowTypeInfo(String path) throws FileConnectorException {
        throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_OPERATION, "User must defined schema for xml file type");
    }

    @Override
    public void setCatalogTable(CatalogTable catalogTable) {
        SeaTunnelRowType rowType = catalogTable.getSeaTunnelRowType();
        if (ArrayUtils.isEmpty((Object[])rowType.getFieldNames()) || ArrayUtils.isEmpty((Object[])rowType.getFieldTypes())) {
            throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.ILLEGAL_ARGUMENT, "Schema information is undefined or misconfigured, please check your configuration file.");
        }
        if (this.readColumns.isEmpty()) {
            this.seaTunnelRowType = rowType;
            this.seaTunnelRowTypeWithPartition = this.mergePartitionTypes((String)this.fileNames.get(0), rowType);
        } else {
            if (this.readColumns.retainAll(Arrays.asList(rowType.getFieldNames()))) {
                log.warn("The read columns configuration will be filtered by the schema configuration, this may cause the actual results to be inconsistent with expectations. This is due to read columns not being a subset of the schema, maybe you should check the schema and read_columns!");
            }
            int[] indexes = new int[this.readColumns.size()];
            String[] fields = new String[this.readColumns.size()];
            SeaTunnelDataType[] types = new SeaTunnelDataType[this.readColumns.size()];
            for (int i = 0; i < this.readColumns.size(); ++i) {
                indexes[i] = rowType.indexOf((String)this.readColumns.get(i));
                fields[i] = rowType.getFieldName(indexes[i]);
                types[i] = rowType.getFieldType(indexes[i]);
            }
            this.seaTunnelRowType = new SeaTunnelRowType(fields, types);
            this.seaTunnelRowTypeWithPartition = this.mergePartitionTypes((String)this.fileNames.get(0), this.seaTunnelRowType);
        }
    }

    private Object convert(String fieldValue, SeaTunnelDataType<?> fieldType) {
        if (StringUtils.isBlank((CharSequence)fieldValue)) {
            return "";
        }
        SqlType sqlType = fieldType.getSqlType();
        switch (sqlType) {
            case STRING: {
                return fieldValue;
            }
            case DATE: {
                return DateUtils.parse((String)fieldValue, (DateUtils.Formatter)this.dateFormat);
            }
            case TIME: {
                return TimeUtils.parse((String)fieldValue, (TimeUtils.Formatter)this.timeFormat);
            }
            case TIMESTAMP: {
                return DateTimeUtils.parse((String)fieldValue, (DateTimeUtils.Formatter)this.datetimeFormat);
            }
            case TINYINT: {
                return (byte)Double.parseDouble(fieldValue);
            }
            case SMALLINT: {
                return (short)Double.parseDouble(fieldValue);
            }
            case INT: {
                return (int)Double.parseDouble(fieldValue);
            }
            case BIGINT: {
                return new BigDecimal(fieldValue).longValue();
            }
            case DOUBLE: {
                return Double.parseDouble(fieldValue);
            }
            case FLOAT: {
                return Float.valueOf((float)Double.parseDouble(fieldValue));
            }
            case DECIMAL: {
                return new BigDecimal(fieldValue);
            }
            case BOOLEAN: {
                return Boolean.parseBoolean(fieldValue);
            }
            case BYTES: {
                return fieldValue.getBytes(StandardCharsets.UTF_8);
            }
            case NULL: {
                return "";
            }
            case ROW: {
                String[] context = fieldValue.split(this.delimiter);
                SeaTunnelRowType ft = (SeaTunnelRowType)fieldType;
                SeaTunnelRow row = new SeaTunnelRow(context.length);
                IntStream.range(0, context.length).forEach(i -> row.setField(i, this.convert(context[i], ft.getFieldTypes()[i])));
                return row;
            }
            case MAP: 
            case ARRAY: {
                return this.objectMapper.readValue(fieldValue, fieldType.getTypeClass());
            }
        }
        throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_DATA_TYPE, String.format("Unsupported data type: %s", sqlType));
    }

    private String getXPathExpression(String tableRowIdentification) {
        return String.format("//%s", tableRowIdentification);
    }

    private void preCheckAndInitializeConfiguration() {
        ReadonlyConfig readonlyConfig = ReadonlyConfig.fromConfig((Config)this.pluginConfig);
        this.tableRowName = (String)readonlyConfig.get(BaseSourceConfigOptions.XML_ROW_TAG);
        this.useAttrFormat = (Boolean)readonlyConfig.get(BaseSourceConfigOptions.XML_USE_ATTR_FORMAT);
        if (StringUtils.isEmpty((CharSequence)this.tableRowName) || this.useAttrFormat == null) {
            throw new FileConnectorException((SeaTunnelErrorCode)SeaTunnelAPIErrorCode.CONFIG_VALIDATION_FAILED, String.format("Mandatory configurations '%s' and '%s' must be specified when reading XML files.", BaseSourceConfigOptions.XML_ROW_TAG.key(), BaseSourceConfigOptions.XML_USE_ATTR_FORMAT.key()));
        }
        this.delimiter = (String)readonlyConfig.get(BaseSourceConfigOptions.FIELD_DELIMITER);
        this.dateFormat = this.getComplexDateConfigValue(BaseSourceConfigOptions.DATE_FORMAT, DateUtils.Formatter::parse);
        this.timeFormat = this.getComplexDateConfigValue(BaseSourceConfigOptions.TIME_FORMAT, TimeUtils.Formatter::parse);
        this.datetimeFormat = this.getComplexDateConfigValue(BaseSourceConfigOptions.DATETIME_FORMAT, DateTimeUtils.Formatter::parse);
        this.encoding = ReadonlyConfig.fromConfig((Config)this.pluginConfig).getOptional(BaseSourceConfigOptions.ENCODING).orElse(StandardCharsets.UTF_8.name());
    }

    private <T> T getComplexDateConfigValue(Option<?> option, Function<String, T> parser) {
        if (!this.pluginConfig.hasPath(option.key())) {
            return (T)option.defaultValue();
        }
        return parser.apply(this.pluginConfig.getString(option.key()));
    }
}

