/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.source.reader;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.builder.ExcelReaderBuilder;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import java.util.stream.IntStream;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.NumberToTextConverter;
import org.apache.poi.xssf.usermodel.XSSFFormulaEvaluator;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.seatunnel.api.source.Collector;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.common.utils.DateTimeUtils;
import org.apache.seatunnel.common.utils.DateUtils;
import org.apache.seatunnel.common.utils.TimeUtils;
import org.apache.seatunnel.connectors.seatunnel.file.config.BaseSourceConfigOptions;
import org.apache.seatunnel.connectors.seatunnel.file.config.ExcelEngine;
import org.apache.seatunnel.connectors.seatunnel.file.config.FileFormat;
import org.apache.seatunnel.connectors.seatunnel.file.excel.ExcelCellUtils;
import org.apache.seatunnel.connectors.seatunnel.file.excel.ExcelReaderListener;
import org.apache.seatunnel.connectors.seatunnel.file.exception.FileConnectorException;
import org.apache.seatunnel.connectors.seatunnel.file.source.reader.AbstractReadStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelReadStrategy
extends AbstractReadStrategy {
    private static final Logger log = LoggerFactory.getLogger(ExcelReadStrategy.class);
    private String dateFormatterPattern = DateUtils.Formatter.YYYY_MM_DD.getValue();
    private String dateTimeFormatterPattern = DateTimeUtils.Formatter.YYYY_MM_DD_HH_MM_SS.getValue();
    private String timeFormatterPattern = TimeUtils.Formatter.HH_MM_SS.getValue();
    private int[] indexes;
    private int cellCount;

    @Override
    public void read(String path, String tableId, Collector<SeaTunnelRow> output) {
        Map<String, String> partitionsMap = this.parsePartitionsByPath(path);
        this.resolveArchiveCompressedInputStream(path, tableId, output, partitionsMap, FileFormat.EXCEL);
    }

    @Override
    protected void readProcess(String path, String tableId, Collector<SeaTunnelRow> output, InputStream inputStream, Map<String, String> partitionsMap, String currentFileName) throws IOException {
        if (this.skipHeaderNumber > Integer.MAX_VALUE || this.skipHeaderNumber < Integer.MIN_VALUE) {
            throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_OPERATION, "Skip the number of rows exceeds the maximum or minimum limit of Sheet");
        }
        if (this.pluginConfig.hasPath(BaseSourceConfigOptions.DATE_FORMAT.key())) {
            this.dateFormatterPattern = this.pluginConfig.getString(BaseSourceConfigOptions.DATE_FORMAT.key());
        }
        if (this.pluginConfig.hasPath(BaseSourceConfigOptions.DATETIME_FORMAT.key())) {
            this.dateTimeFormatterPattern = this.pluginConfig.getString(BaseSourceConfigOptions.DATETIME_FORMAT.key());
        }
        if (this.pluginConfig.hasPath(BaseSourceConfigOptions.TIME_FORMAT.key())) {
            this.timeFormatterPattern = this.pluginConfig.getString(BaseSourceConfigOptions.TIME_FORMAT.key());
        }
        ExcelCellUtils excelCellUtils = new ExcelCellUtils(this.pluginConfig, this.dateFormatterPattern, this.dateTimeFormatterPattern, this.timeFormatterPattern);
        if (this.pluginConfig.hasPath(BaseSourceConfigOptions.EXCEL_ENGINE.key()) && this.pluginConfig.getString(BaseSourceConfigOptions.EXCEL_ENGINE.key()).equals(ExcelEngine.EASY_EXCEL.getExcelEngineName())) {
            log.info("Parsing Excel with EasyExcel");
            ExcelReaderBuilder read = EasyExcel.read((InputStream)inputStream, (ReadListener)new ExcelReaderListener(tableId, output, excelCellUtils, this.seaTunnelRowType));
            if (this.pluginConfig.hasPath(BaseSourceConfigOptions.SHEET_NAME.key())) {
                ((ExcelReaderSheetBuilder)read.sheet(this.pluginConfig.getString(BaseSourceConfigOptions.SHEET_NAME.key())).headRowNumber(Integer.valueOf((int)this.skipHeaderNumber))).doReadSync();
            } else {
                ((ExcelReaderSheetBuilder)read.sheet(Integer.valueOf(0)).headRowNumber(Integer.valueOf((int)this.skipHeaderNumber))).doReadSync();
            }
        } else {
            FormulaEvaluator formulaEvaluator;
            HSSFWorkbook workbook;
            log.info("Parsing Excel with POI");
            if (currentFileName.endsWith(".xls")) {
                workbook = new HSSFWorkbook(inputStream);
                formulaEvaluator = workbook.getCreationHelper().createFormulaEvaluator();
            } else if (currentFileName.endsWith(".xlsx")) {
                workbook = new XSSFWorkbook(inputStream);
                formulaEvaluator = new XSSFFormulaEvaluator((XSSFWorkbook)workbook);
            } else {
                throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_OPERATION, "Only support read excel file");
            }
            DataFormatter formatter = new DataFormatter();
            Sheet sheet = this.pluginConfig.hasPath(BaseSourceConfigOptions.SHEET_NAME.key()) ? workbook.getSheet(this.pluginConfig.getString(BaseSourceConfigOptions.SHEET_NAME.key())) : workbook.getSheetAt(0);
            this.cellCount = this.seaTunnelRowType.getTotalFields();
            this.cellCount = partitionsMap.isEmpty() ? this.cellCount : this.cellCount + partitionsMap.size();
            SeaTunnelDataType[] fieldTypes = this.seaTunnelRowType.getFieldTypes();
            int rowCount = sheet.getPhysicalNumberOfRows();
            if (this.skipHeaderNumber > (long)rowCount) {
                throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_OPERATION, "Skip the number of rows exceeds the maximum or minimum limit of Sheet");
            }
            IntStream.range((int)this.skipHeaderNumber, rowCount).mapToObj(arg_0 -> ((Sheet)sheet).getRow(arg_0)).filter(Objects::nonNull).forEach(rowData -> {
                int[] cellIndexes = this.indexes == null ? IntStream.range(0, this.cellCount).toArray() : this.indexes;
                int z = 0;
                SeaTunnelRow seaTunnelRow = new SeaTunnelRow(this.cellCount);
                for (int j : cellIndexes) {
                    Cell cell = rowData.getCell(j);
                    seaTunnelRow.setField(z++, cell == null ? null : excelCellUtils.convert(this.getCellValue(cell.getCellType(), cell, formulaEvaluator, formatter), fieldTypes[z - 1], null));
                }
                if (this.isMergePartition) {
                    int index = this.seaTunnelRowType.getTotalFields();
                    for (String value : partitionsMap.values()) {
                        seaTunnelRow.setField(index++, (Object)value);
                    }
                }
                seaTunnelRow.setTableId(tableId);
                output.collect((Object)seaTunnelRow);
            });
        }
    }

    @Override
    public void setCatalogTable(CatalogTable catalogTable) {
        SeaTunnelRowType rowType = catalogTable.getSeaTunnelRowType();
        if (this.isNullOrEmpty(rowType.getFieldNames()) || this.isNullOrEmpty(rowType.getFieldTypes())) {
            throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_OPERATION, "Schema information is not set or incorrect Schema settings");
        }
        SeaTunnelRowType userDefinedRowTypeWithPartition = this.mergePartitionTypes((String)this.fileNames.get(0), rowType);
        if (this.pluginConfig.hasPath(BaseSourceConfigOptions.READ_COLUMNS.key())) {
            this.indexes = new int[this.readColumns.size()];
            String[] fields = new String[this.readColumns.size()];
            SeaTunnelDataType[] types = new SeaTunnelDataType[this.readColumns.size()];
            for (int i = 0; i < this.indexes.length; ++i) {
                this.indexes[i] = rowType.indexOf((String)this.readColumns.get(i));
                fields[i] = rowType.getFieldName(this.indexes[i]);
                types[i] = rowType.getFieldType(this.indexes[i]);
            }
            this.seaTunnelRowType = new SeaTunnelRowType(fields, types);
            this.seaTunnelRowTypeWithPartition = this.mergePartitionTypes((String)this.fileNames.get(0), this.seaTunnelRowType);
        } else {
            this.seaTunnelRowType = rowType;
            this.seaTunnelRowTypeWithPartition = userDefinedRowTypeWithPartition;
        }
    }

    @Override
    public SeaTunnelRowType getSeaTunnelRowTypeInfo(String path) throws FileConnectorException {
        throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_OPERATION, "User must defined schema for json file type");
    }

    private Object getCellValue(CellType cellType, Cell cell, FormulaEvaluator formulaEvaluator, DataFormatter formatter) {
        switch (cellType) {
            case STRING: {
                return cell.getStringCellValue();
            }
            case BOOLEAN: {
                return cell.getBooleanCellValue();
            }
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    return cell.getLocalDateTimeCellValue();
                }
                return formatter.formatCellValue(cell);
            }
            case BLANK: {
                return "";
            }
            case ERROR: {
                break;
            }
            case FORMULA: {
                CellValue evaluate = formulaEvaluator.evaluate(cell);
                if (evaluate.getCellType().equals((Object)CellType.NUMERIC)) {
                    return NumberToTextConverter.toText((double)evaluate.getNumberValue());
                }
                return evaluate.formatAsString();
            }
            default: {
                throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_DATA_TYPE, String.format("[%s] type not support ", cellType));
            }
        }
        return null;
    }

    private <T> boolean isNullOrEmpty(T[] arr) {
        return arr == null || arr.length == 0;
    }

    public String getDateFormatterPattern() {
        return this.dateFormatterPattern;
    }

    public String getDateTimeFormatterPattern() {
        return this.dateTimeFormatterPattern;
    }

    public String getTimeFormatterPattern() {
        return this.timeFormatterPattern;
    }

    public int[] getIndexes() {
        return this.indexes;
    }

    public int getCellCount() {
        return this.cellCount;
    }
}

