/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.source.reader;

import io.airlift.compress.lzo.LzopCodec;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.seatunnel.api.common.SeaTunnelAPIErrorCode;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.source.Collector;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.CatalogTableUtil;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.common.utils.DateTimeUtils;
import org.apache.seatunnel.common.utils.DateUtils;
import org.apache.seatunnel.common.utils.TimeUtils;
import org.apache.seatunnel.connectors.seatunnel.file.config.BaseSourceConfigOptions;
import org.apache.seatunnel.connectors.seatunnel.file.config.CompressFormat;
import org.apache.seatunnel.connectors.seatunnel.file.config.FileFormat;
import org.apache.seatunnel.connectors.seatunnel.file.exception.FileConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.file.exception.FileConnectorException;
import org.apache.seatunnel.connectors.seatunnel.file.source.reader.AbstractReadStrategy;
import org.apache.seatunnel.format.csv.CsvDeserializationSchema;
import org.apache.seatunnel.format.csv.processor.CsvLineProcessor;
import org.apache.seatunnel.format.csv.processor.DefaultCsvLineProcessor;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvReadStrategy
extends AbstractReadStrategy {
    private static final Logger log = LoggerFactory.getLogger(CsvReadStrategy.class);
    private CsvDeserializationSchema deserializationSchema;
    private String fieldDelimiter = (String)BaseSourceConfigOptions.FIELD_DELIMITER.defaultValue();
    private DateUtils.Formatter dateFormat = (DateUtils.Formatter)BaseSourceConfigOptions.DATE_FORMAT.defaultValue();
    private DateTimeUtils.Formatter datetimeFormat = (DateTimeUtils.Formatter)BaseSourceConfigOptions.DATETIME_FORMAT.defaultValue();
    private TimeUtils.Formatter timeFormat = (TimeUtils.Formatter)BaseSourceConfigOptions.TIME_FORMAT.defaultValue();
    private CompressFormat compressFormat = (CompressFormat)BaseSourceConfigOptions.COMPRESS_CODEC.defaultValue();
    private CsvLineProcessor processor;
    private int[] indexes;
    private String encoding = (String)BaseSourceConfigOptions.ENCODING.defaultValue();
    private CatalogTable inputCatalogTable;

    @Override
    public void read(String path, String tableId, Collector<SeaTunnelRow> output) throws FileConnectorException, IOException {
        Map<String, String> partitionsMap = this.parsePartitionsByPath(path);
        this.resolveArchiveCompressedInputStream(path, tableId, output, partitionsMap, FileFormat.CSV);
    }

    @Override
    public void readProcess(String path, String tableId, Collector<SeaTunnelRow> output, InputStream inputStream, Map<String, String> partitionsMap, String currentFileName) throws IOException {
        InputStream actualInputStream;
        switch (this.compressFormat) {
            case LZO: {
                LzopCodec lzo = new LzopCodec();
                actualInputStream = lzo.createInputStream(inputStream);
                break;
            }
            case NONE: {
                actualInputStream = inputStream;
                break;
            }
            default: {
                log.warn("Csv file does not support this compress type: {}", (Object)this.compressFormat.getCompressCodec());
                actualInputStream = inputStream;
            }
        }
        CSVFormat csvFormat = CSVFormat.DEFAULT;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(actualInputStream, this.encoding));
             CSVParser csvParser = new CSVParser((Reader)reader, csvFormat);){
            int i = 0;
            while ((long)i < this.skipHeaderNumber) {
                if (reader.readLine() == null) {
                    throw new IOException(String.format("File [%s] has fewer lines than expected to skip.", currentFileName));
                }
                ++i;
            }
            for (CSVRecord csvRecord : csvParser) {
                HashMap<Integer, String> fieldIdValueMap = new HashMap<Integer, String>();
                for (int i2 = 0; i2 < this.inputCatalogTable.getTableSchema().getColumns().size(); ++i2) {
                    fieldIdValueMap.put(i2, csvRecord.get(i2));
                }
                SeaTunnelRow seaTunnelRow = this.deserializationSchema.getSeaTunnelRow(fieldIdValueMap);
                if (!this.readColumns.isEmpty()) {
                    Object[] fields = this.isMergePartition ? new Object[this.readColumns.size() + partitionsMap.size()] : new Object[this.readColumns.size()];
                    for (int i3 = 0; i3 < this.indexes.length; ++i3) {
                        fields[i3] = seaTunnelRow.getField(this.indexes[i3]);
                    }
                    seaTunnelRow = new SeaTunnelRow(fields);
                }
                if (this.isMergePartition) {
                    int index = this.seaTunnelRowType.getTotalFields();
                    for (String value : partitionsMap.values()) {
                        seaTunnelRow.setField(index++, (Object)value);
                    }
                }
                seaTunnelRow.setTableId(tableId);
                output.collect((Object)seaTunnelRow);
            }
        }
        catch (IOException e) {
            String errorMsg = String.format("Deserialize this file [%s] failed, please check the origin data", currentFileName);
            throw new FileConnectorException(FileConnectorErrorCode.DATA_DESERIALIZE_FAILED, errorMsg, e);
        }
    }

    @Override
    public SeaTunnelRowType getSeaTunnelRowTypeInfo(String path) {
        this.seaTunnelRowType = CatalogTableUtil.buildSimpleTextSchema();
        this.seaTunnelRowTypeWithPartition = this.mergePartitionTypes((String)this.fileNames.get(0), this.seaTunnelRowType);
        this.initFormatter();
        if (this.pluginConfig.hasPath(BaseSourceConfigOptions.READ_COLUMNS.key())) {
            throw new FileConnectorException((SeaTunnelErrorCode)SeaTunnelAPIErrorCode.CONFIG_VALIDATION_FAILED, "When reading csv files, if user has not specified schema information, SeaTunnel will not support column projection");
        }
        ReadonlyConfig readonlyConfig = ReadonlyConfig.fromConfig((Config)this.pluginConfig);
        CsvDeserializationSchema.Builder builder = CsvDeserializationSchema.builder().delimiter("\b").csvLineProcessor(this.processor).nullFormat((String)readonlyConfig.getOptional(BaseSourceConfigOptions.NULL_FORMAT).orElse(null));
        this.deserializationSchema = this.isMergePartition ? builder.seaTunnelRowType(this.seaTunnelRowTypeWithPartition).build() : builder.seaTunnelRowType(this.seaTunnelRowType).build();
        return this.getActualSeaTunnelRowTypeInfo();
    }

    @Override
    public void setCatalogTable(CatalogTable catalogTable) {
        SeaTunnelRowType rowType = catalogTable.getSeaTunnelRowType();
        this.inputCatalogTable = catalogTable;
        SeaTunnelRowType userDefinedRowTypeWithPartition = this.mergePartitionTypes((String)this.fileNames.get(0), rowType);
        ReadonlyConfig readonlyConfig = ReadonlyConfig.fromConfig((Config)this.pluginConfig);
        Optional fieldDelimiterOptional = readonlyConfig.getOptional(BaseSourceConfigOptions.FIELD_DELIMITER);
        this.encoding = readonlyConfig.getOptional(BaseSourceConfigOptions.ENCODING).orElse(StandardCharsets.UTF_8.name());
        this.fieldDelimiter = ",";
        this.initFormatter();
        CsvDeserializationSchema.Builder builder = CsvDeserializationSchema.builder().delimiter(this.fieldDelimiter).csvLineProcessor(this.processor).nullFormat((String)readonlyConfig.getOptional(BaseSourceConfigOptions.NULL_FORMAT).orElse(null));
        this.deserializationSchema = this.isMergePartition ? builder.seaTunnelRowType(userDefinedRowTypeWithPartition).build() : builder.seaTunnelRowType(rowType).build();
        if (this.pluginConfig.hasPath(BaseSourceConfigOptions.READ_COLUMNS.key())) {
            this.indexes = new int[this.readColumns.size()];
            String[] fields = new String[this.readColumns.size()];
            SeaTunnelDataType[] types = new SeaTunnelDataType[this.readColumns.size()];
            for (int i = 0; i < this.indexes.length; ++i) {
                this.indexes[i] = rowType.indexOf((String)this.readColumns.get(i));
                fields[i] = rowType.getFieldName(this.indexes[i]);
                types[i] = rowType.getFieldType(this.indexes[i]);
            }
            this.seaTunnelRowType = new SeaTunnelRowType(fields, types);
            this.seaTunnelRowTypeWithPartition = this.mergePartitionTypes((String)this.fileNames.get(0), this.seaTunnelRowType);
        } else {
            this.seaTunnelRowType = rowType;
            this.seaTunnelRowTypeWithPartition = userDefinedRowTypeWithPartition;
        }
    }

    private void initFormatter() {
        if (this.pluginConfig.hasPath(BaseSourceConfigOptions.DATE_FORMAT.key())) {
            this.dateFormat = DateUtils.Formatter.parse((String)this.pluginConfig.getString(BaseSourceConfigOptions.DATE_FORMAT.key()));
        }
        if (this.pluginConfig.hasPath(BaseSourceConfigOptions.DATETIME_FORMAT.key())) {
            this.datetimeFormat = DateTimeUtils.Formatter.parse((String)this.pluginConfig.getString(BaseSourceConfigOptions.DATETIME_FORMAT.key()));
        }
        if (this.pluginConfig.hasPath(BaseSourceConfigOptions.TIME_FORMAT.key())) {
            this.timeFormat = TimeUtils.Formatter.parse((String)this.pluginConfig.getString(BaseSourceConfigOptions.TIME_FORMAT.key()));
        }
        if (this.pluginConfig.hasPath(BaseSourceConfigOptions.COMPRESS_CODEC.key())) {
            String compressCodec = this.pluginConfig.getString(BaseSourceConfigOptions.COMPRESS_CODEC.key());
            this.compressFormat = CompressFormat.valueOf(compressCodec.toUpperCase());
        }
        this.processor = new DefaultCsvLineProcessor();
    }
}

