/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.hadoop;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;

public class HadoopLoginFactory {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T loginWithKerberos(Configuration configuration, String krb5FilePath, String kerberosPrincipal, String kerberosKeytabPath, LoginFunction<T> action) throws IOException, InterruptedException {
        if (!configuration.get("hadoop.security.authentication").equals("kerberos")) {
            throw new IllegalArgumentException("hadoop.security.authentication must be kerberos");
        }
        Class<UserGroupInformation> clazz = UserGroupInformation.class;
        synchronized (UserGroupInformation.class) {
            if (StringUtils.isNotEmpty((CharSequence)krb5FilePath)) {
                System.setProperty("java.security.krb5.conf", krb5FilePath);
            }
            UserGroupInformation.setConfiguration((Configuration)configuration);
            UserGroupInformation userGroupInformation = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)kerberosPrincipal, (String)kerberosKeytabPath);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return (T)userGroupInformation.doAs(() -> action.run(configuration, userGroupInformation));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T loginWithRemoteUser(Configuration configuration, String remoteUser, LoginFunction<T> action) throws Exception {
        Class<UserGroupInformation> clazz = UserGroupInformation.class;
        synchronized (UserGroupInformation.class) {
            UserGroupInformation userGroupInformation = UserGroupInformation.createRemoteUser((String)remoteUser);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return (T)userGroupInformation.doAs(() -> action.run(configuration, userGroupInformation));
        }
    }

    public static interface LoginFunction<T> {
        public T run(Configuration var1, UserGroupInformation var2) throws Exception;
    }
}

