/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.sink;

import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.request.OapiRobotSendRequest;
import com.dingtalk.api.response.OapiRobotSendResponse;
import com.taobao.api.ApiException;
import java.io.IOException;
import java.io.Serializable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.connectors.seatunnel.common.sink.AbstractSinkWriter;
import org.apache.seatunnel.connectors.seatunnel.exception.DingTalkConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.exception.DingTalkConnectorException;

public class DingTalkWriter
extends AbstractSinkWriter<SeaTunnelRow, Void> {
    private RobotClient robotClient;

    public DingTalkWriter(String url, String secret) {
        this.robotClient = new RobotClient(url, secret);
    }

    public void write(SeaTunnelRow element) throws IOException {
        this.robotClient.send(element.toString());
    }

    public void close() throws IOException {
    }

    private static class RobotClient
    implements Serializable {
        private String url;
        private String secret;
        private DefaultDingTalkClient client;

        public RobotClient(String url, String secret) {
            this.url = url;
            this.secret = secret;
        }

        public OapiRobotSendResponse send(String message) throws IOException {
            if (null == this.client) {
                this.client = new DefaultDingTalkClient(this.getUrl());
            }
            OapiRobotSendRequest request = new OapiRobotSendRequest();
            request.setMsgtype("text");
            OapiRobotSendRequest.Text text = new OapiRobotSendRequest.Text();
            text.setContent(message);
            request.setText(text);
            try {
                return this.client.execute(request);
            }
            catch (ApiException e) {
                throw new DingTalkConnectorException(DingTalkConnectorErrorCode.SEND_RESPONSE_FAILED, "Send response message to DinkTalk server failed", e);
            }
        }

        public String getUrl() throws IOException {
            Long timestamp = System.currentTimeMillis();
            String sign = this.getSign(timestamp);
            return this.url + "&timestamp=" + timestamp + "&sign=" + sign;
        }

        public String getSign(Long timestamp) throws IOException {
            try {
                String stringToSign = timestamp + "\n" + this.secret;
                Mac mac = Mac.getInstance("HmacSHA256");
                mac.init(new SecretKeySpec(this.secret.getBytes(StandardCharsets.UTF_8), "HmacSHA256"));
                byte[] signData = mac.doFinal(stringToSign.getBytes(StandardCharsets.UTF_8));
                return URLEncoder.encode(Base64.getEncoder().encodeToString(signData), "UTF-8");
            }
            catch (Exception e) {
                throw new DingTalkConnectorException(DingTalkConnectorErrorCode.GET_SIGN_FAILED, "Get signature from DinkTalk server failed", e);
            }
        }
    }
}

