/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.client.impl;

import com.aliyun.datahub.client.DatahubClient;
import com.aliyun.datahub.client.auth.Account;
import com.aliyun.datahub.client.exception.AuthorizationFailureException;
import com.aliyun.datahub.client.exception.DatahubClientException;
import com.aliyun.datahub.client.exception.ExpiredAccessTokenException;
import com.aliyun.datahub.client.exception.InvalidParameterException;
import com.aliyun.datahub.client.exception.LimitExceededException;
import com.aliyun.datahub.client.exception.MalformedRecordException;
import com.aliyun.datahub.client.exception.NoPermissionException;
import com.aliyun.datahub.client.exception.OperationDeniedException;
import com.aliyun.datahub.client.exception.ResourceAlreadyExistException;
import com.aliyun.datahub.client.exception.ResourceNotFoundException;
import com.aliyun.datahub.client.exception.ResourceOfflineException;
import com.aliyun.datahub.client.exception.SeekOutOfRangeException;
import com.aliyun.datahub.client.exception.ServiceInProcessException;
import com.aliyun.datahub.client.exception.ShardNotFoundException;
import com.aliyun.datahub.client.exception.ShardSealedException;
import com.aliyun.datahub.client.exception.SubscriptionOfflineException;
import com.aliyun.datahub.client.exception.SubscriptionOffsetResetException;
import com.aliyun.datahub.client.exception.SubscriptionSessionInvalidException;
import com.aliyun.datahub.client.http.HttpClient;
import com.aliyun.datahub.client.http.HttpConfig;
import com.aliyun.datahub.client.http.interceptor.InterceptorWrapper;
import com.aliyun.datahub.client.impl.DataHubService;
import com.aliyun.datahub.client.impl.interceptor.DatahubAuthInterceptor;
import com.aliyun.datahub.client.impl.interceptor.DatahubResponseInterceptor;
import com.aliyun.datahub.client.metircs.ClientMetrics;
import com.aliyun.datahub.client.model.BaseResult;
import com.aliyun.datahub.shaded.retrofit2.Call;
import com.aliyun.datahub.shaded.retrofit2.Response;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDatahubClient
implements DatahubClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDatahubClient.class);
    protected static final int MAX_FETCH_SIZE = 1000;
    protected static final int MIN_FETCH_SIZE = 1;
    protected static final String MAX_SHARD_ID = String.valueOf(0xFFFFFFFFL);
    protected static final int MAX_WAITING_TIME_IN_MS = 30000;
    protected Meter PUT_QPS_METER = ClientMetrics.getMeter(ClientMetrics.MetricType.PUT_QPS);
    protected Meter PUT_RPS_METER = ClientMetrics.getMeter(ClientMetrics.MetricType.PUT_RPS);
    protected Timer PUT_LATENCY_TIMER = ClientMetrics.getTimer(ClientMetrics.MetricType.PUT_LATENCY);
    protected Meter GET_QPS_METER = ClientMetrics.getMeter(ClientMetrics.MetricType.GET_QPS);
    protected Meter GET_RPS_METER = ClientMetrics.getMeter(ClientMetrics.MetricType.GET_RPS);
    protected Timer GET_LATENCY_TIMER = ClientMetrics.getTimer(ClientMetrics.MetricType.GET_LATENCY);
    private String endpoint;
    private Account account;
    protected HttpConfig httpConfig;
    private InterceptorWrapper interceptorWrapper;

    public AbstractDatahubClient(String endpoint, Account account, HttpConfig httpConfig, String userAgent) {
        this.endpoint = endpoint;
        this.account = account;
        this.httpConfig = httpConfig;
        this.interceptorWrapper = new InterceptorWrapper().setAuth(new DatahubAuthInterceptor(account, userAgent)).setResponse(new DatahubResponseInterceptor());
    }

    protected <T> T getService(Class<T> cls) {
        return HttpClient.createClient(this.endpoint, this.httpConfig, this.interceptorWrapper).create(cls);
    }

    protected DataHubService getService() {
        return this.getService(DataHubService.class);
    }

    protected final <T> T callWrapper(Call<T> call) {
        try {
            return this.retryExecute(call);
        }
        catch (DatahubClientException ex) {
            LOGGER.debug("Request fail. error:", (Throwable)ex);
            this.checkAndThrow(ex);
        }
        catch (Exception ex) {
            LOGGER.warn("Request fail. error:", (Throwable)ex);
            throw new DatahubClientException(ex.getMessage() == null ? this.getExceptionStack(ex) : ex.getMessage(), ex);
        }
        return null;
    }

    private final <T> T retryExecute(Call<T> call) {
        int count = 1;
        int httpStatus = 5001;
        String requestId = null;
        while (true) {
            try {
                Response<T> response = call.execute();
                httpStatus = response.code();
                requestId = response.headers().get("x-datahub-request-id");
                if (response.body() instanceof BaseResult) {
                    ((BaseResult)response.body()).setRequestId(requestId);
                }
                return response.body();
            }
            catch (DatahubClientException ex) {
                if (count >= this.httpConfig.getMaxRetryCount()) {
                    ex.setHttpStatus(httpStatus);
                    throw ex;
                }
                ++count;
                call = call.clone();
                continue;
            }
            catch (IOException ex) {
                LOGGER.warn("Request fail. endpoint: {}", (Object)this.endpoint, (Object)ex);
                throw new DatahubClientException(httpStatus, requestId, null, ex.getMessage() + ", endpoint: " + this.endpoint, ex);
            }
            break;
        }
    }

    private void checkAndThrow(DatahubClientException ex) {
        String errCode = ex.getErrorCode();
        if ("InvalidParameter".equalsIgnoreCase(errCode) || "InvalidCursor".equalsIgnoreCase(errCode)) {
            throw new InvalidParameterException(ex);
        }
        if ("NoSuchShard".equalsIgnoreCase(errCode)) {
            throw new ShardNotFoundException(ex);
        }
        if ("ResourceNotFound".equalsIgnoreCase(errCode) || "NoSuchProject".equalsIgnoreCase(errCode) || "NoSuchTopic".equalsIgnoreCase(errCode) || "NoSuchConnector".equalsIgnoreCase(errCode) || "NoSuchSubscription".equalsIgnoreCase(errCode) || "NoSuchConsumer".equalsIgnoreCase(errCode) || "NoSuchMeteringInfo".equalsIgnoreCase(errCode)) {
            throw new ResourceNotFoundException(ex);
        }
        if ("ResourceAlreadyExist".equalsIgnoreCase(errCode) || "ProjectAlreadyExist".equalsIgnoreCase(errCode) || "TopicAlreadyExist".equalsIgnoreCase(errCode) || "ConnectorAlreadyExist".equalsIgnoreCase(errCode)) {
            throw new ResourceAlreadyExistException(ex);
        }
        if ("SeekOutOfRange".equalsIgnoreCase(errCode)) {
            throw new SeekOutOfRangeException(ex);
        }
        if ("Unauthorized".equalsIgnoreCase(errCode)) {
            throw new AuthorizationFailureException(ex);
        }
        if ("NoPermission".equalsIgnoreCase(errCode)) {
            throw new NoPermissionException(ex);
        }
        if ("OperationDenied".equalsIgnoreCase(errCode)) {
            throw new OperationDeniedException(ex);
        }
        if ("InvalidShardOperation".equalsIgnoreCase(errCode)) {
            throw new ShardSealedException(ex);
        }
        if ("LimitExceeded".equalsIgnoreCase(errCode)) {
            throw new LimitExceededException(ex);
        }
        if ("SubscriptionOffline".equalsIgnoreCase(errCode)) {
            throw new SubscriptionOfflineException(ex);
        }
        if ("OffsetSessionChanged".equalsIgnoreCase(errCode) || "OffsetSessionClosed".equalsIgnoreCase(errCode)) {
            throw new SubscriptionSessionInvalidException(ex);
        }
        if ("OffsetReseted".equalsIgnoreCase(errCode)) {
            throw new SubscriptionOffsetResetException(ex);
        }
        if ("MalformedRecord".equalsIgnoreCase(errCode)) {
            throw new MalformedRecordException(ex);
        }
        if ("ConsumerGroupInProcess".equalsIgnoreCase(errCode)) {
            throw new ServiceInProcessException(ex);
        }
        if ("ExpiredAccessToken".equalsIgnoreCase(errCode)) {
            throw new ExpiredAccessTokenException(ex);
        }
        if ("TopicOffline".equalsIgnoreCase(errCode)) {
            throw new ResourceOfflineException(ex);
        }
        throw ex;
    }

    private String getExceptionStack(Exception ex) {
        if (ex.getMessage() != null) {
            return ex.getMessage();
        }
        StackTraceElement element = ex.getStackTrace()[0];
        StringBuilder sb = new StringBuilder().append("Exception:").append(ex.getClass().getName()).append("|").append("ClassName:").append(element.getClassName()).append("|").append("File:").append(element.getFileName()).append("|").append("Line:").append(element.getLineNumber()).append("|").append("Method:").append(element.getMethodName());
        return sb.toString();
    }

    public void innerSetInterceptor(InterceptorWrapper interceptor) {
        this.interceptorWrapper = interceptor;
    }
}

