/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.client.exception;

public class DatahubClientException
extends RuntimeException {
    private int httpStatus = 5001;
    private String requestId;
    private String errorCode;
    private String errorMessage;

    public DatahubClientException(String message, Throwable cause) {
        super(message, cause);
        this.errorMessage = message;
    }

    public DatahubClientException(String message) {
        this(message, null);
    }

    public DatahubClientException(int httpStatus, String requestId, String errorCode, String errorMessage, Throwable cause) {
        super(errorMessage, cause);
        this.httpStatus = httpStatus;
        this.requestId = requestId;
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    public DatahubClientException(int httpStatus, String requestId, String errorCode, String errorMessage) {
        this(httpStatus, requestId, errorCode, errorMessage, null);
    }

    public DatahubClientException(DatahubClientException ex) {
        this(ex.getHttpStatus(), ex.getRequestId(), ex.getErrorCode(), ex.getErrorMessage());
    }

    public void setHttpStatus(int httpStatus) {
        if (httpStatus != 5001) {
            this.httpStatus = httpStatus;
        }
    }

    public int getHttpStatus() {
        return this.httpStatus;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public String getMessage() {
        return "[httpStatus:" + this.httpStatus + ", requestId:" + this.requestId + ", errorCode:" + this.errorCode + ", errorMessage:" + this.errorMessage + "]";
    }
}

