/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.client.example.examples;

import com.aliyun.datahub.client.DatahubClient;
import com.aliyun.datahub.client.DatahubClientBuilder;
import com.aliyun.datahub.client.auth.AliyunAccount;
import com.aliyun.datahub.client.common.DatahubConfig;
import com.aliyun.datahub.client.exception.AuthorizationFailureException;
import com.aliyun.datahub.client.exception.DatahubClientException;
import com.aliyun.datahub.client.exception.InvalidParameterException;
import com.aliyun.datahub.client.exception.ResourceNotFoundException;
import com.aliyun.datahub.client.model.ListShardResult;
import com.aliyun.datahub.client.model.MergeShardResult;
import com.aliyun.datahub.client.model.ShardEntry;
import com.aliyun.datahub.client.model.SplitShardResult;

public class ShardExample {
    private static DatahubClient datahubClient;

    public static void init() {
        datahubClient = DatahubClientBuilder.newBuilder().setDatahubConfig(new DatahubConfig("", new AliyunAccount("", ""), true)).build();
    }

    public static void listShard() {
        try {
            ListShardResult listShardResult = datahubClient.listShard("", "");
            if (listShardResult.getShards().size() > 0) {
                for (ShardEntry entry : listShardResult.getShards()) {
                    System.out.println(entry.getShardId() + "\t" + (Object)((Object)entry.getState()) + "\t" + entry.getLeftShardId() + "\t" + entry.getRightShardId() + "\t" + entry.getAddress());
                }
            }
        }
        catch (InvalidParameterException e) {
            e.printStackTrace();
            throw e;
        }
        catch (AuthorizationFailureException e) {
            e.printStackTrace();
            throw e;
        }
        catch (ResourceNotFoundException e) {
            e.printStackTrace();
            throw e;
        }
        catch (DatahubClientException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void splitShard() {
        try {
            String shardId = "0";
            SplitShardResult splitShardResult = datahubClient.splitShard("", "", shardId);
            for (ShardEntry entry : splitShardResult.getNewShards()) {
                System.out.println(entry.getShardId());
            }
        }
        catch (InvalidParameterException e) {
            e.printStackTrace();
            throw e;
        }
        catch (AuthorizationFailureException e) {
            e.printStackTrace();
            throw e;
        }
        catch (ResourceNotFoundException e) {
            e.printStackTrace();
            throw e;
        }
        catch (DatahubClientException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void mergeShard() {
        try {
            String shardId = "0";
            String adjacentShardId = "1";
            MergeShardResult mergeShardResult = datahubClient.mergeShard("", "", shardId, adjacentShardId);
            System.out.println("merge successful");
            System.out.println(mergeShardResult.getShardId());
        }
        catch (InvalidParameterException e) {
            e.printStackTrace();
            throw e;
        }
        catch (AuthorizationFailureException e) {
            e.printStackTrace();
            throw e;
        }
        catch (ResourceNotFoundException e) {
            e.printStackTrace();
            throw e;
        }
        catch (DatahubClientException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void main(String[] args2) {
        ShardExample.init();
        ShardExample.listShard();
        ShardExample.mergeShard();
    }
}

