/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.client.example.examples;

import com.aliyun.datahub.client.DatahubClient;
import com.aliyun.datahub.client.DatahubClientBuilder;
import com.aliyun.datahub.client.auth.AliyunAccount;
import com.aliyun.datahub.client.common.DatahubConfig;
import com.aliyun.datahub.client.exception.AuthorizationFailureException;
import com.aliyun.datahub.client.exception.DatahubClientException;
import com.aliyun.datahub.client.exception.InvalidParameterException;
import com.aliyun.datahub.client.exception.LimitExceededException;
import com.aliyun.datahub.client.exception.ResourceNotFoundException;
import com.aliyun.datahub.client.exception.SubscriptionOfflineException;
import com.aliyun.datahub.client.exception.SubscriptionOffsetResetException;
import com.aliyun.datahub.client.exception.SubscriptionSessionInvalidException;
import com.aliyun.datahub.client.model.GetSubscriptionOffsetResult;
import com.aliyun.datahub.client.model.OpenSubscriptionSessionResult;
import com.aliyun.datahub.client.model.RecordSchema;
import com.aliyun.datahub.client.model.SubscriptionOffset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class OffsetExample {
    private static DatahubClient datahubClient;
    private static String subId;
    private static RecordSchema recordSchema;
    private static String shardId;
    private static List<String> shardIds;

    public static void init() {
        datahubClient = DatahubClientBuilder.newBuilder().setDatahubConfig(new DatahubConfig("", new AliyunAccount("", ""), true)).build();
        subId = "";
        recordSchema = datahubClient.getTopic("", "").getRecordSchema();
        shardId = "";
        shardIds = new ArrayList<String>();
        shardIds.add(shardId);
    }

    public static void openSubscriptionSession() {
        try {
            OpenSubscriptionSessionResult openSubscriptionSessionResult = datahubClient.openSubscriptionSession("", "", subId, shardIds);
            SubscriptionOffset subscriptionOffset = openSubscriptionSessionResult.getOffsets().get(shardId);
            System.out.println(subscriptionOffset.getSessionId() + "\t" + subscriptionOffset.getVersionId() + "\t" + subscriptionOffset.getSequence());
        }
        catch (InvalidParameterException e) {
            e.printStackTrace();
            throw e;
        }
        catch (AuthorizationFailureException e) {
            e.printStackTrace();
            throw e;
        }
        catch (ResourceNotFoundException e) {
            e.printStackTrace();
            throw e;
        }
        catch (DatahubClientException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void getSubscriptionOffset() {
        try {
            GetSubscriptionOffsetResult getSubscriptionOffsetResult = datahubClient.getSubscriptionOffset("", "", subId, shardIds);
            SubscriptionOffset subscriptionOffset = getSubscriptionOffsetResult.getOffsets().get(shardId);
            System.out.println(subscriptionOffset.getVersionId() + "\t" + subscriptionOffset.getSequence());
        }
        catch (InvalidParameterException e) {
            e.printStackTrace();
            throw e;
        }
        catch (AuthorizationFailureException e) {
            e.printStackTrace();
            throw e;
        }
        catch (ResourceNotFoundException e) {
            e.printStackTrace();
            throw e;
        }
        catch (DatahubClientException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void commitSubscriptionOffset(int maxRetry) {
        for (int i = 0; i < maxRetry; ++i) {
            try {
                OpenSubscriptionSessionResult openSubscriptionSessionResult = datahubClient.openSubscriptionSession("", "", subId, shardIds);
                SubscriptionOffset subscriptionOffset = openSubscriptionSessionResult.getOffsets().get(shardId);
                subscriptionOffset.setSequence(10L);
                subscriptionOffset.setTimestamp(100L);
                HashMap<String, SubscriptionOffset> offsets = new HashMap<String, SubscriptionOffset>();
                offsets.put(shardId, subscriptionOffset);
                datahubClient.commitSubscriptionOffset("", "", subId, offsets);
                continue;
            }
            catch (InvalidParameterException e) {
                e.printStackTrace();
                throw e;
            }
            catch (AuthorizationFailureException e) {
                e.printStackTrace();
                throw e;
            }
            catch (ResourceNotFoundException e) {
                e.printStackTrace();
                throw e;
            }
            catch (SubscriptionOffsetResetException e) {
                e.printStackTrace();
                throw e;
            }
            catch (SubscriptionSessionInvalidException e) {
                e.printStackTrace();
                throw e;
            }
            catch (SubscriptionOfflineException e) {
                e.printStackTrace();
                throw e;
            }
            catch (LimitExceededException e) {
                e.printStackTrace();
                continue;
            }
            catch (DatahubClientException e) {
                e.printStackTrace();
            }
        }
    }

    public static void resetSubscriptionOffset() {
        String time = "2019-07-09 10:00:00";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        long timestamp = 0L;
        try {
            Date date = simpleDateFormat.parse(time);
            timestamp = date.getTime();
        }
        catch (ParseException e) {
            System.exit(1);
        }
        try {
            SubscriptionOffset offset = new SubscriptionOffset();
            offset.setTimestamp(timestamp);
            HashMap<String, SubscriptionOffset> offsets = new HashMap<String, SubscriptionOffset>();
            for (String shardId : shardIds) {
                offsets.put(shardId, offset);
            }
        }
        catch (InvalidParameterException e) {
            e.printStackTrace();
            throw e;
        }
        catch (AuthorizationFailureException e) {
            e.printStackTrace();
            throw e;
        }
        catch (ResourceNotFoundException e) {
            e.printStackTrace();
            throw e;
        }
        catch (DatahubClientException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void main(String[] args2) {
        OffsetExample.init();
        OffsetExample.resetSubscriptionOffset();
    }
}

