/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.client.example.examples;

import com.aliyun.datahub.client.DatahubClient;
import com.aliyun.datahub.client.DatahubClientBuilder;
import com.aliyun.datahub.client.auth.AliyunAccount;
import com.aliyun.datahub.client.common.DatahubConfig;
import com.aliyun.datahub.client.example.examples.ConsumerThread;
import com.aliyun.datahub.client.exception.DatahubClientException;
import com.aliyun.datahub.client.model.ListShardResult;
import com.aliyun.datahub.client.model.OpenSubscriptionSessionResult;
import com.aliyun.datahub.client.model.RecordSchema;
import com.aliyun.datahub.client.model.ShardEntry;
import java.util.ArrayList;
import java.util.Iterator;

class Consumption {
    private DatahubClient datahubClient = DatahubClientBuilder.newBuilder().setDatahubConfig(new DatahubConfig("", new AliyunAccount("", ""), true)).build();
    private RecordSchema schema;
    private String subId;

    public Consumption() {
        try {
            this.schema = this.datahubClient.getTopic("", "").getRecordSchema();
        }
        catch (DatahubClientException e) {
            e.printStackTrace();
            throw e;
        }
        this.subId = "";
    }

    public void offset_consumption() {
        try {
            RecordSchema schema = this.datahubClient.getTopic("", "").getRecordSchema();
            ListShardResult listShardResult = this.datahubClient.listShard("", "");
            ArrayList<String> shardIdList = new ArrayList<String>();
            for (ShardEntry entry : listShardResult.getShards()) {
                shardIdList.add(entry.getShardId());
            }
            OpenSubscriptionSessionResult openSubscriptionSessionResult = this.datahubClient.openSubscriptionSession("", "", this.subId, shardIdList);
            ArrayList<ConsumerThread> threadList = new ArrayList<ConsumerThread>();
            Iterator iterator2 = shardIdList.iterator();
            if (iterator2.hasNext()) {
                String string = (String)iterator2.next();
                ConsumerThread thread2 = new ConsumerThread(3, string, this.subId, schema, openSubscriptionSessionResult.getOffsets().get(string), this.datahubClient);
                threadList.add(thread2);
                thread2.start();
                System.out.println(string);
            }
            for (Thread thread2 : threadList) {
                thread2.join();
            }
        }
        catch (DatahubClientException e) {
            e.printStackTrace();
            throw e;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

