/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.client.auth;

import com.aliyun.datahub.client.auth.Account;
import com.aliyun.datahub.client.auth.AliyunAuthSigner;
import com.aliyun.datahub.client.auth.AuthSigner;
import com.aliyun.datahub.shaded.okhttp3.Request;
import com.aliyun.datahub.shaded.org.apache.commons.lang3.StringUtils;
import java.util.Objects;

public class AliyunAccount
implements Account {
    private String accessId;
    private String accessKey;
    private String securityToken;
    private AuthSigner signer;

    public AliyunAccount(String accessId, String accessKey) {
        this.accessId = accessId;
        this.accessKey = accessKey;
        this.signer = new AliyunAuthSigner(accessId, accessKey);
    }

    public AliyunAccount(String accessId, String accessKey, String securityToken) {
        this.accessId = accessId;
        this.accessKey = accessKey;
        this.securityToken = securityToken;
        this.signer = new AliyunAuthSigner(accessId, accessKey);
    }

    @Override
    public void addAuthHeaders(Request.Builder reqBuilder) {
        if (this.securityToken != null) {
            reqBuilder.addHeader("x-datahub-security-token", this.securityToken);
        }
        if (this.isNeedAuth()) {
            Request copyRequest = reqBuilder.build();
            reqBuilder.addHeader("Authorization", this.signer.genAuthSignature(copyRequest));
        }
    }

    private boolean isNeedAuth() {
        return !StringUtils.isEmpty(this.accessId) && !StringUtils.isEmpty(this.accessKey);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AliyunAccount that = (AliyunAccount)o;
        return Objects.equals(this.accessId, that.accessId) && Objects.equals(this.accessKey, that.accessKey) && Objects.equals(this.securityToken, that.securityToken);
    }

    public int hashCode() {
        return Objects.hash(this.accessId, this.accessKey, this.securityToken);
    }
}

