/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.client.http;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class TimeoutCache<K, V> {
    private final Map<K, CacheItem<V>> cache = new ConcurrentHashMap<K, CacheItem<V>>();
    private long timeoutMs;

    public TimeoutCache(long timeoutMs) {
        this.timeoutMs = timeoutMs;
    }

    public void put(K key, V value) {
        long now = System.currentTimeMillis();
        for (Map.Entry<K, CacheItem<V>> kvEntry : this.cache.entrySet()) {
            if (!kvEntry.getValue().isExpired(now)) continue;
            this.cache.remove(kvEntry.getKey());
        }
        this.cache.put(key, new CacheItem<V>(now, value));
    }

    public V get(K key) {
        CacheItem<V> item = this.cache.get(key);
        if (item != null) {
            item.visit();
            return item.getValue();
        }
        return null;
    }

    public V remove(K key) {
        CacheItem<V> item = this.cache.remove(key);
        if (item != null) {
            return item.getValue();
        }
        return null;
    }

    private class CacheItem<T> {
        private volatile long timestamp;
        private volatile boolean visited = true;
        private T value;

        CacheItem(long timestamp, T value) {
            this.timestamp = timestamp;
            this.value = value;
        }

        boolean isExpired(long timestamp) {
            if (this.visited) {
                this.timestamp = timestamp;
                this.visited = false;
                return false;
            }
            return timestamp - this.timestamp > TimeoutCache.this.timeoutMs;
        }

        void visit() {
            this.visited = true;
        }

        public T getValue() {
            return this.value;
        }
    }
}

