/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.client.example.examples;

import com.aliyun.datahub.client.DatahubClient;
import com.aliyun.datahub.client.DatahubClientBuilder;
import com.aliyun.datahub.client.auth.AliyunAccount;
import com.aliyun.datahub.client.common.DatahubConfig;
import com.aliyun.datahub.client.exception.AuthorizationFailureException;
import com.aliyun.datahub.client.exception.DatahubClientException;
import com.aliyun.datahub.client.exception.InvalidParameterException;
import com.aliyun.datahub.client.exception.ResourceAlreadyExistException;
import com.aliyun.datahub.client.exception.ResourceNotFoundException;
import com.aliyun.datahub.client.model.Field;
import com.aliyun.datahub.client.model.FieldType;
import com.aliyun.datahub.client.model.GetTopicResult;
import com.aliyun.datahub.client.model.ListTopicResult;
import com.aliyun.datahub.client.model.RecordSchema;
import com.aliyun.datahub.client.model.RecordType;

public class TopicExample {
    private static DatahubClient datahubClient;
    private static RecordSchema recordSchema;

    public static void init() {
        datahubClient = DatahubClientBuilder.newBuilder().setDatahubConfig(new DatahubConfig("", new AliyunAccount("", ""), true)).build();
        recordSchema = new RecordSchema(){
            {
                this.addField(new Field("bigint_field", FieldType.BIGINT));
                this.addField(new Field("timestamp_field", FieldType.TIMESTAMP));
                this.addField(new Field("string_field", FieldType.STRING));
                this.addField(new Field("double_field", FieldType.DOUBLE));
                this.addField(new Field("boolean_field", FieldType.BOOLEAN));
                this.addField(new Field("decimal_field", FieldType.DECIMAL));
            }
        };
    }

    public static void createTupleTopic() {
        try {
            datahubClient.createTopic("", "", 10, 1, RecordType.TUPLE, recordSchema, "");
            System.out.println("create topic successful");
        }
        catch (InvalidParameterException e) {
            e.printStackTrace();
            throw e;
        }
        catch (AuthorizationFailureException e) {
            e.printStackTrace();
            throw e;
        }
        catch (ResourceAlreadyExistException e) {
            System.out.println("topic already exists, please check if it is consistent");
        }
        catch (ResourceNotFoundException e) {
            e.printStackTrace();
            throw e;
        }
        catch (DatahubClientException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void createBlobTopic() {
        try {
            datahubClient.createTopic("", "", 10, 1, RecordType.BLOB, "");
            System.out.println("create topic successful");
        }
        catch (InvalidParameterException e) {
            e.printStackTrace();
            throw e;
        }
        catch (AuthorizationFailureException e) {
            e.printStackTrace();
            throw e;
        }
        catch (ResourceAlreadyExistException e) {
            System.out.println("topic already exists, please check if it is consistent");
        }
        catch (ResourceNotFoundException e) {
            e.printStackTrace();
            throw e;
        }
        catch (DatahubClientException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void deleteTopic() {
        try {
            datahubClient.deleteTopic("", "");
            System.out.println("delete topic successful");
        }
        catch (InvalidParameterException e) {
            e.printStackTrace();
            throw e;
        }
        catch (AuthorizationFailureException e) {
            e.printStackTrace();
            throw e;
        }
        catch (ResourceNotFoundException e) {
            e.printStackTrace();
            throw e;
        }
        catch (DatahubClientException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void updateTopic() {
        try {
            String newComment = "new topic comment";
            datahubClient.updateTopic("", "", newComment);
            System.out.println("update topic successful");
        }
        catch (InvalidParameterException e) {
            e.printStackTrace();
            throw e;
        }
        catch (AuthorizationFailureException e) {
            e.printStackTrace();
            throw e;
        }
        catch (ResourceNotFoundException e) {
            e.printStackTrace();
            throw e;
        }
        catch (DatahubClientException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void listTopic() {
        try {
            datahubClient.deleteTopic("", "");
            ListTopicResult listTopicResult = datahubClient.listTopic("");
            if (listTopicResult.getTopicNames().size() > 0) {
                for (String tName : listTopicResult.getTopicNames()) {
                    System.out.println(tName);
                }
            }
        }
        catch (InvalidParameterException e) {
            e.printStackTrace();
            throw e;
        }
        catch (AuthorizationFailureException e) {
            e.printStackTrace();
            throw e;
        }
        catch (ResourceNotFoundException e) {
            e.printStackTrace();
            throw e;
        }
        catch (DatahubClientException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void getTopic() {
        try {
            GetTopicResult getTopicResult = datahubClient.getTopic("", "");
            System.out.println(getTopicResult.getShardCount() + "\t" + getTopicResult.getLifeCycle() + "\t" + (Object)((Object)getTopicResult.getRecordType()) + "\t" + getTopicResult.getComment());
        }
        catch (InvalidParameterException e) {
            e.printStackTrace();
            throw e;
        }
        catch (AuthorizationFailureException e) {
            e.printStackTrace();
            throw e;
        }
        catch (ResourceNotFoundException e) {
            e.printStackTrace();
            throw e;
        }
        catch (DatahubClientException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void appendNewField() {
        try {
            Field newField = new Field("newField", FieldType.STRING, true);
            datahubClient.appendField("", "", newField);
            System.out.println("append field successful");
        }
        catch (InvalidParameterException e) {
            e.printStackTrace();
            throw e;
        }
        catch (AuthorizationFailureException e) {
            e.printStackTrace();
            throw e;
        }
        catch (ResourceNotFoundException e) {
            e.printStackTrace();
            throw e;
        }
        catch (DatahubClientException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void main(String[] args) {
        TopicExample.init();
        TopicExample.createTupleTopic();
        TopicExample.createBlobTopic();
    }
}

