/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.client.impl.serializer;

import com.aliyun.datahub.client.model.AlarmRule;
import com.aliyun.datahub.client.model.ConnectorDoneDelayAlarmRule;
import com.aliyun.datahub.client.model.SubReadDelayAlarmRule;
import com.aliyun.datahub.client.model.TopicNoDataAlarmRule;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;

public class AlarmRuleSerializer
extends JsonSerializer<AlarmRule> {
    @Override
    public void serialize(AlarmRule alarmRule, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
        jsonGenerator.writeStartObject();
        if (alarmRule.getPhoneList() != null) {
            jsonGenerator.writeArrayFieldStart("Phone");
            for (String phone : alarmRule.getPhoneList()) {
                jsonGenerator.writeString(phone);
            }
            jsonGenerator.writeEndArray();
        }
        if (alarmRule.getMailList() != null) {
            jsonGenerator.writeArrayFieldStart("Mail");
            for (String mail : alarmRule.getMailList()) {
                jsonGenerator.writeString(mail);
            }
            jsonGenerator.writeEndArray();
        }
        if (alarmRule.getEmpIdList() != null) {
            jsonGenerator.writeArrayFieldStart("EmpId");
            for (String empId : alarmRule.getEmpIdList()) {
                jsonGenerator.writeString(empId);
            }
            jsonGenerator.writeEndArray();
        }
        if (alarmRule.getLevel() != null) {
            jsonGenerator.writeStringField("Level", alarmRule.getLevel().name());
        }
        if (alarmRule instanceof TopicNoDataAlarmRule) {
            this.serializeTopicNoDataAlarmRule((TopicNoDataAlarmRule)alarmRule, jsonGenerator);
        } else if (alarmRule instanceof SubReadDelayAlarmRule) {
            this.serializeSubReadDelayAlarmRule((SubReadDelayAlarmRule)alarmRule, jsonGenerator);
        } else if (alarmRule instanceof ConnectorDoneDelayAlarmRule) {
            this.serializeConnectorDoneDelayAlarmRule((ConnectorDoneDelayAlarmRule)alarmRule, jsonGenerator);
        } else {
            throw new IOException("Unknown alarm rule type");
        }
        jsonGenerator.writeEndObject();
    }

    private void serializeTopicNoDataAlarmRule(TopicNoDataAlarmRule alarmRule, JsonGenerator jsonGenerator) throws IOException {
        if (alarmRule.getSuspendSecond() != null) {
            jsonGenerator.writeNumberField("SuspendSecond", alarmRule.getSuspendSecond());
        }
    }

    private void serializeSubReadDelayAlarmRule(SubReadDelayAlarmRule alarmRule, JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeStringField("SubId", alarmRule.getSubId());
        if (alarmRule.getDelaySecond() != null) {
            jsonGenerator.writeNumberField("DelaySecond", alarmRule.getDelaySecond());
        }
    }

    private void serializeConnectorDoneDelayAlarmRule(ConnectorDoneDelayAlarmRule alarmRule, JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeStringField("ConnectorId", alarmRule.getConnectorId());
        if (alarmRule.getDelaySecond() != null) {
            jsonGenerator.writeNumberField("DelaySecond", alarmRule.getDelaySecond());
        }
    }
}

