/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.client.http.common;

import com.aliyun.datahub.client.http.HttpClient;
import com.aliyun.datahub.client.http.common.HttpInterceptor;
import com.aliyun.datahub.client.http.common.HttpRequest;
import com.aliyun.datahub.client.http.common.HttpRequestConfig;
import com.aliyun.datahub.shaded.okhttp3.ConnectionPool;
import com.aliyun.datahub.shaded.okhttp3.OkHttpClient;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public abstract class HttpRequestBuilder {
    private static int maxIdleConnections = 3;
    private static ConnectionPool connectionPool;
    private static Map<HttpRequestConfig, OkHttpClient> clientMap;

    public static int getMaxIdleConnections() {
        return maxIdleConnections;
    }

    public static void setMaxIdleConnections(int maxIdleConnections) {
        HttpRequestBuilder.maxIdleConnections = maxIdleConnections;
    }

    public static HttpRequest createRequest(String endpoint, HttpRequestConfig config) {
        return HttpRequestBuilder.createRequest(endpoint, config, new HttpInterceptor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HttpRequest createRequest(String endpoint, HttpRequestConfig config, HttpInterceptor interceptor) {
        OkHttpClient client;
        if (!endpoint.startsWith("http")) {
            endpoint = "http://" + endpoint;
        }
        if ((client = clientMap.get(config)) != null) return new HttpRequest(client).endpoint(endpoint).interceptor(interceptor);
        Class<HttpRequestBuilder> clazz = HttpRequestBuilder.class;
        synchronized (HttpRequestBuilder.class) {
            client = clientMap.get(config);
            if (client != null) return new HttpRequest(client).endpoint(endpoint).interceptor(interceptor);
            client = HttpRequestBuilder.createClient(config);
            clientMap.put(config, client);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return new HttpRequest(client).endpoint(endpoint).interceptor(interceptor);
        }
    }

    private static OkHttpClient createClient(HttpRequestConfig config) {
        if (connectionPool == null) {
            connectionPool = new ConnectionPool(maxIdleConnections, 60L, TimeUnit.SECONDS);
        }
        OkHttpClient.Builder builder = new OkHttpClient.Builder().connectionPool(connectionPool).readTimeout(config.getReadTimeout(), TimeUnit.MILLISECONDS).writeTimeout(config.getReadTimeout(), TimeUnit.MILLISECONDS).connectTimeout(config.getConnTimeout(), TimeUnit.MILLISECONDS).sslSocketFactory(HttpClient.sslSocketFactory(), HttpClient.x509TrustManager());
        return builder.build();
    }

    static {
        clientMap = new HashMap<HttpRequestConfig, OkHttpClient>();
    }
}

