/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.client.example;

import com.aliyun.datahub.client.example.BaseExample;
import com.aliyun.datahub.client.model.ConnectorOffset;
import com.aliyun.datahub.client.model.ConnectorState;
import com.aliyun.datahub.client.model.ConnectorType;
import com.aliyun.datahub.client.model.CreateConnectorResult;
import com.aliyun.datahub.client.model.GetConnectorDoneTimeResult;
import com.aliyun.datahub.client.model.GetConnectorResult;
import com.aliyun.datahub.client.model.GetConnectorShardStatusResult;
import com.aliyun.datahub.client.model.SinkMysqlConfig;
import com.aliyun.datahub.client.model.SinkOdpsConfig;
import com.aliyun.datahub.client.model.UpdateConnectorOffsetResult;
import com.aliyun.datahub.client.model.UpdateConnectorStateResult;
import java.util.ArrayList;
import java.util.List;

public class ConnectorExample
extends BaseExample {
    @Override
    public void runExample() {
        this.runWithOdpsType();
        this.runWithAdsType();
    }

    private void runWithOdpsType() {
        SinkOdpsConfig config = new SinkOdpsConfig(){
            {
                this.setEndpoint("** odps endpoint **");
                this.setTunnelEndpoint("** tunnel endpoint **");
                this.setProject("** odps project **");
                this.setTable("** odps table **");
                this.setAccessId("** access id **");
                this.setAccessKey("** access key **");
                this.setPartitionMode(SinkOdpsConfig.PartitionMode.SYSTEM_TIME);
                SinkOdpsConfig.PartitionConfig partitionConfig = new SinkOdpsConfig.PartitionConfig(){
                    {
                        this.addConfig("ds", "%Y%m%d");
                        this.addConfig("hh", "%H");
                        this.addConfig("mm", "%M");
                    }
                };
                this.setPartitionConfig(partitionConfig);
                this.setTimeRange(15);
            }
        };
        ArrayList<String> columnFields = new ArrayList<String>(){
            {
                this.add("field1");
                this.add("field2");
            }
        };
        CreateConnectorResult createConnectorResult = this.client.createConnector("** datahub project **", "** datahub tuple topic **", ConnectorType.SINK_ODPS, (List<String>)columnFields, config);
        String connectorId = createConnectorResult.getConnectorId();
        GetConnectorResult getDataConnectorResult = this.client.getConnector("** datahub project **", "** datahub tuple topic **", connectorId);
        GetConnectorShardStatusResult getDataConnectorShardStatusResult = this.client.getConnectorShardStatus("** datahub project **", "** datahub tuple topic **", connectorId);
        GetConnectorDoneTimeResult getDataConnectorDoneTimeResult = this.client.getConnectorDoneTime("** datahub project **", "** datahub tuple topic **", connectorId);
        this.client.appendConnectorField("** datahub project **", "** datahub tuple topic **", connectorId, "field3");
        this.client.reloadConnector("** datahub project **", "** datahub tuple topic **", connectorId);
        this.client.deleteConnector("** datahub project **", "** datahub tuple topic **", connectorId);
    }

    private void runWithAdsType() {
        SinkMysqlConfig config = new SinkMysqlConfig(){
            {
                this.setHost("** ads hot**");
                this.setPort(9999);
                this.setUser("** ads user **");
                this.setPassword("** ads password **");
                this.setDatabase("** ads database **");
                this.setTable("** ads table **");
            }
        };
        ArrayList<String> columnFields = new ArrayList<String>(){
            {
                this.add("field1");
                this.add("field2");
            }
        };
        CreateConnectorResult createConnectorResult = this.client.createConnector("** datahub project **", "** datahub tuple topic **", ConnectorType.SINK_ADS, 1000L, (List<String>)columnFields, config);
        String connectorId = createConnectorResult.getConnectorId();
        GetConnectorResult getDataConnectorResult = this.client.getConnector("** datahub project **", "** datahub tuple topic **", connectorId);
        GetConnectorShardStatusResult getConnectorShardStatusResult = this.client.getConnectorShardStatus("** datahub project **", "** datahub tuple topic **", connectorId);
        UpdateConnectorStateResult updateConnectorStateResult = this.client.updateConnectorState("** datahub project **", "** datahub tuple topic **", connectorId, ConnectorState.STOPPED);
        UpdateConnectorOffsetResult updateConnectorOffsetResult = this.client.updateConnectorOffset("** datahub project **", "** datahub tuple topic **", connectorId, null, new ConnectorOffset(){
            {
                this.setTimestamp(10L);
                this.setSequence(100L);
            }
        });
        getConnectorShardStatusResult = this.client.getConnectorShardStatus("** datahub project **", "** datahub tuple topic **", connectorId);
        updateConnectorStateResult = this.client.updateConnectorState("** datahub project **", "** datahub tuple topic **", connectorId, ConnectorState.RUNNING);
        this.client.deleteConnector("** datahub project **", "** datahub tuple topic **", connectorId);
    }
}

