/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.databend.sink;

import com.google.auto.service.AutoService;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.connector.TableSink;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.TableSinkFactory;
import org.apache.seatunnel.api.table.factory.TableSinkFactoryContext;
import org.apache.seatunnel.connectors.seatunnel.databend.config.DatabendOptions;
import org.apache.seatunnel.connectors.seatunnel.databend.config.DatabendSinkOptions;
import org.apache.seatunnel.connectors.seatunnel.databend.sink.DatabendSink;

@AutoService(value={Factory.class})
public class DatabendSinkFactory
implements TableSinkFactory {
    public String factoryIdentifier() {
        return "Databend";
    }

    public OptionRule optionRule() {
        return OptionRule.builder().required(new Option[]{DatabendOptions.URL, DatabendOptions.USERNAME, DatabendOptions.PASSWORD}).optional(new Option[]{DatabendOptions.DATABASE, DatabendOptions.TABLE, DatabendOptions.JDBC_CONFIG, DatabendOptions.BATCH_SIZE, DatabendOptions.AUTO_COMMIT, DatabendOptions.MAX_RETRIES, DatabendSinkOptions.SCHEMA_SAVE_MODE, DatabendSinkOptions.DATA_SAVE_MODE, DatabendSinkOptions.CUSTOM_SQL, DatabendSinkOptions.EXECUTE_TIMEOUT_SEC}).build();
    }

    public TableSink createSink(TableSinkFactoryContext context) {
        return () -> {
            CatalogTable catalogTable = context.getCatalogTable();
            return new DatabendSink(catalogTable, context.getOptions());
        };
    }
}

