/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.databend.schema;

import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.converter.BasicTypeDefine;
import org.apache.seatunnel.api.table.schema.event.AlterTableAddColumnEvent;
import org.apache.seatunnel.api.table.schema.event.AlterTableChangeColumnEvent;
import org.apache.seatunnel.api.table.schema.event.AlterTableColumnEvent;
import org.apache.seatunnel.api.table.schema.event.AlterTableColumnsEvent;
import org.apache.seatunnel.api.table.schema.event.AlterTableDropColumnEvent;
import org.apache.seatunnel.api.table.schema.event.AlterTableModifyColumnEvent;
import org.apache.seatunnel.api.table.schema.event.SchemaChangeEvent;
import org.apache.seatunnel.common.utils.SeaTunnelException;
import org.apache.seatunnel.connectors.seatunnel.databend.config.DatabendSinkConfig;
import org.apache.seatunnel.connectors.seatunnel.databend.exception.DatabendConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.databend.exception.DatabendConnectorException;
import org.apache.seatunnel.connectors.seatunnel.databend.util.DatabendTypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaChangeManager
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(SchemaChangeManager.class);
    private static final long serialVersionUID = 1L;
    private static final String CHECK_COLUMN_EXISTS = "SELECT column_name FROM information_schema.columns WHERE table_schema = ? AND table_name = ? AND column_name = ?";
    private final DatabendSinkConfig databendSinkConfig;

    public SchemaChangeManager(DatabendSinkConfig databendSinkConfig) {
        this.databendSinkConfig = databendSinkConfig;
    }

    public void applySchemaChange(TablePath tablePath, SchemaChangeEvent event) throws IOException {
        block17: {
            try (Connection connection = DriverManager.getConnection(String.format("%s/%s", this.databendSinkConfig.getUrl(), tablePath.getDatabaseName()), this.databendSinkConfig.toProperties());){
                if (event instanceof AlterTableColumnsEvent) {
                    for (AlterTableColumnEvent columnEvent : ((AlterTableColumnsEvent)event).getEvents()) {
                        this.applySchemaChange(connection, tablePath, columnEvent);
                    }
                    break block17;
                }
                if (event instanceof AlterTableColumnEvent) {
                    this.applySchemaChange(connection, tablePath, (AlterTableColumnEvent)event);
                    break block17;
                }
                throw new SeaTunnelException("Unsupported schemaChangeEvent: " + event.getClass().getName());
            }
            catch (SQLException e) {
                throw new DatabendConnectorException(DatabendConnectorErrorCode.SQL_OPERATION_FAILED, "Failed to apply schema change: " + e.getMessage(), e);
            }
        }
    }

    private void applySchemaChange(Connection connection, TablePath tablePath, AlterTableColumnEvent event) throws SQLException, IOException {
        if (event instanceof AlterTableChangeColumnEvent) {
            AlterTableChangeColumnEvent changeColumnEvent = (AlterTableChangeColumnEvent)event;
            if (!changeColumnEvent.getOldColumn().equals(changeColumnEvent.getColumn().getName())) {
                if (!this.columnExists(connection, tablePath, changeColumnEvent.getOldColumn()) && this.columnExists(connection, tablePath, changeColumnEvent.getColumn().getName())) {
                    log.warn("Column {} already exists in table {}. Skipping change column operation. event: {}", changeColumnEvent.getColumn().getName(), tablePath.getFullName(), event);
                    return;
                }
                this.applyRenameColumn(connection, tablePath, changeColumnEvent);
            }
        } else if (event instanceof AlterTableModifyColumnEvent) {
            this.applyModifyColumn(connection, tablePath, (AlterTableModifyColumnEvent)event);
        } else if (event instanceof AlterTableAddColumnEvent) {
            AlterTableAddColumnEvent addColumnEvent = (AlterTableAddColumnEvent)event;
            if (this.columnExists(connection, tablePath, addColumnEvent.getColumn().getName())) {
                log.warn("Column {} already exists in table {}. Skipping add column operation. event: {}", addColumnEvent.getColumn().getName(), tablePath.getFullName(), event);
                return;
            }
            this.applyAddColumn(connection, tablePath, addColumnEvent);
        } else if (event instanceof AlterTableDropColumnEvent) {
            AlterTableDropColumnEvent dropColumnEvent = (AlterTableDropColumnEvent)event;
            if (!this.columnExists(connection, tablePath, dropColumnEvent.getColumn())) {
                log.warn("Column {} does not exist in table {}. Skipping drop column operation. event: {}", dropColumnEvent.getColumn(), tablePath.getFullName(), event);
                return;
            }
            this.applyDropColumn(connection, tablePath, dropColumnEvent);
        } else {
            throw new SeaTunnelException("Unsupported AlterTableColumnEvent type: " + event.getClass().getName());
        }
    }

    private void applyRenameColumn(Connection connection, TablePath tablePath, AlterTableChangeColumnEvent event) throws SQLException {
        StringBuilder sqlBuilder = new StringBuilder().append("ALTER TABLE ").append(this.quoteIdentifier(tablePath.getFullName())).append(" RENAME COLUMN ").append(this.quoteIdentifier(event.getOldColumn())).append(" TO ").append(this.quoteIdentifier(event.getColumn().getName()));
        String sql = sqlBuilder.toString();
        log.info("Executing SQL for rename column: {}", (Object)sql);
        try (Statement statement = connection.createStatement();){
            statement.execute(sql);
            log.info("Successfully renamed column from {} to {} in table {}", event.getOldColumn(), event.getColumn().getName(), tablePath.getFullName());
        }
        catch (SQLException e) {
            log.error("Failed to rename column: {}", (Object)sql, (Object)e);
            throw e;
        }
    }

    private void applyModifyColumn(Connection connection, TablePath tablePath, AlterTableModifyColumnEvent event) throws SQLException {
        BasicTypeDefine typeDefine = DatabendTypeConverter.convertToDatabendType(event.getColumn());
        StringBuilder sqlBuilder = new StringBuilder().append("ALTER TABLE ").append(this.quoteIdentifier(tablePath.getFullName())).append(" MODIFY COLUMN ").append(this.quoteIdentifier(event.getColumn().getName())).append(" ").append(typeDefine.getColumnType());
        if (!event.getColumn().isNullable()) {
            sqlBuilder.append(" NOT NULL");
        }
        if (event.getColumn().getComment() != null) {
            sqlBuilder.append(" COMMENT '").append(event.getColumn().getComment()).append("'");
        }
        String sql = sqlBuilder.toString();
        log.info("Executing SQL for modify column: {}", (Object)sql);
        try (Statement statement = connection.createStatement();){
            statement.execute(sql);
            log.info("Successfully modified column {} in table {}", (Object)event.getColumn().getName(), (Object)tablePath.getFullName());
        }
        catch (SQLException e) {
            log.error("Failed to modify column: {}", (Object)sql, (Object)e);
            throw e;
        }
    }

    private void applyAddColumn(Connection connection, TablePath tablePath, AlterTableAddColumnEvent event) throws SQLException {
        BasicTypeDefine typeDefine = DatabendTypeConverter.convertToDatabendType(event.getColumn());
        StringBuilder sqlBuilder = new StringBuilder().append("ALTER TABLE ").append(this.quoteIdentifier(tablePath.getFullName())).append(" ADD COLUMN ").append(this.quoteIdentifier(event.getColumn().getName())).append(" ").append(typeDefine.getColumnType());
        if (!event.getColumn().isNullable()) {
            sqlBuilder.append(" NOT NULL");
        }
        if (event.getColumn().getComment() != null) {
            sqlBuilder.append(" COMMENT '").append(event.getColumn().getComment()).append("'");
        }
        if (event.getColumn().getDefaultValue() != null) {
            sqlBuilder.append(" DEFAULT ").append(this.quoteDefaultValue(event.getColumn().getDefaultValue()));
        }
        if (event.getAfterColumn() != null) {
            sqlBuilder.append(" AFTER ").append(this.quoteIdentifier(event.getAfterColumn()));
        }
        String sql = sqlBuilder.toString();
        log.info("Executing SQL for add column: {}", (Object)sql);
        try (Statement statement = connection.createStatement();){
            statement.execute(sql);
            log.info("Successfully added column {} to table {}", (Object)event.getColumn().getName(), (Object)tablePath.getFullName());
        }
        catch (SQLException e) {
            log.error("Failed to add column: {}", (Object)sql, (Object)e);
            throw e;
        }
    }

    private void applyDropColumn(Connection connection, TablePath tablePath, AlterTableDropColumnEvent event) throws SQLException {
        String sql = String.format("ALTER TABLE %s DROP COLUMN %s", this.quoteIdentifier(tablePath.getFullName()), this.quoteIdentifier(event.getColumn()));
        log.info("Executing SQL for drop column: {}", (Object)sql);
        try (Statement statement = connection.createStatement();){
            statement.execute(sql);
            log.info("Successfully dropped column {} from table {}", (Object)event.getColumn(), (Object)tablePath.getFullName());
        }
        catch (SQLException e) {
            log.error("Failed to drop column: {}", (Object)sql, (Object)e);
            throw e;
        }
    }

    /*
     * Exception decompiling
     */
    private boolean columnExists(Connection connection, TablePath tablePath, String columnName) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String quoteIdentifier(String identifier) {
        return "`" + identifier + "`";
    }

    private String quoteDefaultValue(Object defaultValue) {
        String strValue = String.valueOf(defaultValue);
        if (strValue.equalsIgnoreCase("current_timestamp")) {
            return "NOW()";
        }
        if (strValue.equalsIgnoreCase("null")) {
            return "NULL";
        }
        if (strValue.matches("-?\\d+(\\.\\d+)?")) {
            return strValue;
        }
        return "'" + strValue.replace("'", "''") + "'";
    }
}

