/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.databend.config;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.sink.DataSaveMode;
import org.apache.seatunnel.api.sink.SchemaSaveMode;
import org.apache.seatunnel.connectors.seatunnel.databend.config.DatabendOptions;
import org.apache.seatunnel.connectors.seatunnel.databend.config.DatabendSinkOptions;

public class DatabendSinkConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String url;
    private String username;
    private String password;
    private Boolean ssl;
    private String database;
    private String table;
    private Boolean autoCommit;
    private Integer batchSize;
    private Integer maxRetries;
    private Map<String, String> jdbcConfig;
    private Integer executeTimeoutSec;
    private String customSql;
    private SchemaSaveMode schemaSaveMode;
    private DataSaveMode dataSaveMode;
    private Properties properties;

    public static DatabendSinkConfig of(ReadonlyConfig config) {
        DatabendSinkConfig sinkConfig = new DatabendSinkConfig();
        sinkConfig.setUrl((String)config.get(DatabendOptions.URL));
        sinkConfig.setUsername((String)config.get(DatabendOptions.USERNAME));
        sinkConfig.setPassword((String)config.get(DatabendOptions.PASSWORD));
        sinkConfig.setDatabase((String)config.get(DatabendOptions.DATABASE));
        sinkConfig.setTable((String)config.get(DatabendOptions.TABLE));
        sinkConfig.setAutoCommit((Boolean)config.get(DatabendOptions.AUTO_COMMIT));
        sinkConfig.setBatchSize((Integer)config.get(DatabendOptions.BATCH_SIZE));
        sinkConfig.setMaxRetries((Integer)config.get(DatabendOptions.MAX_RETRIES));
        sinkConfig.setJdbcConfig((Map)config.get(DatabendOptions.JDBC_CONFIG));
        sinkConfig.setExecuteTimeoutSec((Integer)config.get(DatabendSinkOptions.EXECUTE_TIMEOUT_SEC));
        sinkConfig.setCustomSql(config.getOptional(DatabendSinkOptions.CUSTOM_SQL).orElse(null));
        sinkConfig.setSchemaSaveMode((SchemaSaveMode)config.get(DatabendSinkOptions.SCHEMA_SAVE_MODE));
        sinkConfig.setDataSaveMode((DataSaveMode)config.get(DatabendSinkOptions.DATA_SAVE_MODE));
        Properties properties = new Properties();
        if (sinkConfig.getJdbcConfig() != null) {
            sinkConfig.getJdbcConfig().forEach(properties::setProperty);
        }
        if (!properties.containsKey("user")) {
            properties.setProperty("user", sinkConfig.getUsername());
        }
        if (!properties.containsKey("password")) {
            properties.setProperty("password", sinkConfig.getPassword());
        }
        if (sinkConfig.getSsl() != null) {
            properties.setProperty("ssl", sinkConfig.getSsl().toString());
        }
        sinkConfig.setProperties(properties);
        return sinkConfig;
    }

    public Properties toProperties() {
        Properties properties = new Properties();
        properties.put("user", this.username);
        properties.put("password", this.password);
        properties.put("ssl", this.ssl);
        if (this.jdbcConfig != null) {
            this.jdbcConfig.forEach(properties::put);
        }
        return properties;
    }

    public ReadonlyConfig toReadonlyConfig() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(DatabendOptions.URL.key(), this.url);
        map.put(DatabendOptions.USERNAME.key(), this.username);
        map.put(DatabendOptions.PASSWORD.key(), this.password);
        if (this.ssl != null) {
            map.put(DatabendOptions.SSL.key(), this.ssl);
        }
        map.put(DatabendOptions.DATABASE.key(), this.database);
        map.put(DatabendOptions.TABLE.key(), this.table);
        map.put(DatabendOptions.AUTO_COMMIT.key(), this.autoCommit);
        map.put(DatabendOptions.BATCH_SIZE.key(), this.batchSize);
        map.put(DatabendOptions.MAX_RETRIES.key(), this.maxRetries);
        if (this.jdbcConfig != null) {
            map.put(DatabendOptions.JDBC_CONFIG.key(), this.jdbcConfig);
        }
        map.put(DatabendSinkOptions.EXECUTE_TIMEOUT_SEC.key(), this.executeTimeoutSec);
        if (this.customSql != null) {
            map.put(DatabendSinkOptions.CUSTOM_SQL.key(), this.customSql);
        }
        map.put(DatabendSinkOptions.SCHEMA_SAVE_MODE.key(), this.schemaSaveMode);
        map.put(DatabendSinkOptions.DATA_SAVE_MODE.key(), this.dataSaveMode);
        return ReadonlyConfig.fromMap(map);
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setSsl(Boolean ssl) {
        this.ssl = ssl;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public void setAutoCommit(Boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    public void setMaxRetries(Integer maxRetries) {
        this.maxRetries = maxRetries;
    }

    public void setJdbcConfig(Map<String, String> jdbcConfig) {
        this.jdbcConfig = jdbcConfig;
    }

    public void setExecuteTimeoutSec(Integer executeTimeoutSec) {
        this.executeTimeoutSec = executeTimeoutSec;
    }

    public void setCustomSql(String customSql) {
        this.customSql = customSql;
    }

    public void setSchemaSaveMode(SchemaSaveMode schemaSaveMode) {
        this.schemaSaveMode = schemaSaveMode;
    }

    public void setDataSaveMode(DataSaveMode dataSaveMode) {
        this.dataSaveMode = dataSaveMode;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public Boolean getSsl() {
        return this.ssl;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getTable() {
        return this.table;
    }

    public Boolean getAutoCommit() {
        return this.autoCommit;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public Integer getMaxRetries() {
        return this.maxRetries;
    }

    public Map<String, String> getJdbcConfig() {
        return this.jdbcConfig;
    }

    public Integer getExecuteTimeoutSec() {
        return this.executeTimeoutSec;
    }

    public String getCustomSql() {
        return this.customSql;
    }

    public SchemaSaveMode getSchemaSaveMode() {
        return this.schemaSaveMode;
    }

    public DataSaveMode getDataSaveMode() {
        return this.dataSaveMode;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String toString() {
        return "DatabendSinkConfig(url=" + this.getUrl() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", ssl=" + this.getSsl() + ", database=" + this.getDatabase() + ", table=" + this.getTable() + ", autoCommit=" + this.getAutoCommit() + ", batchSize=" + this.getBatchSize() + ", maxRetries=" + this.getMaxRetries() + ", jdbcConfig=" + this.getJdbcConfig() + ", executeTimeoutSec=" + this.getExecuteTimeoutSec() + ", customSql=" + this.getCustomSql() + ", schemaSaveMode=" + this.getSchemaSaveMode() + ", dataSaveMode=" + this.getDataSaveMode() + ", properties=" + this.getProperties() + ")";
    }
}

