/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.databend.config;

import java.util.Map;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.Options;

public class DatabendOptions {
    public static final Option<String> URL = Options.key((String)"url").stringType().noDefaultValue().withDescription("The URL of the Databend database in standard JDBC format");
    public static final Option<Boolean> SSL = Options.key((String)"ssl").booleanType().defaultValue((Object)false).withDescription("Whether to use SSL for the Databend connection");
    public static final Option<String> USERNAME = Options.key((String)"username").stringType().noDefaultValue().withDescription("The username for Databend database authentication");
    public static final Option<String> PASSWORD = Options.key((String)"password").stringType().noDefaultValue().withDescription("The password for Databend database authentication");
    public static final Option<String> DATABASE = Options.key((String)"database").stringType().noDefaultValue().withDescription("The name of the Databend database to connect to");
    public static final Option<String> TABLE = Options.key((String)"table").stringType().noDefaultValue().withDescription("The name of the Databend table to read or write data");
    public static final Option<Map<String, String>> JDBC_CONFIG = Options.key((String)"jdbc_config").mapType().defaultValue(null).withDescription("The additional JDBC connection configuration");
    public static final Option<Integer> BATCH_SIZE = Options.key((String)"batch_size").intType().defaultValue((Object)1000).withDescription("The batch size for writing to Databend");
    public static final Option<Integer> FETCH_SIZE = Options.key((String)"fetch_size").intType().defaultValue((Object)1).withDescription("For queries that return a large number of objects, you can configure the row fetch size used in the query to improve performance by reducing the number database hits required to satisfy the selection criteria. Zero means use jdbc default value.");
    public static final Option<String> QUERY = Options.key((String)"query").stringType().noDefaultValue().withDescription("The SQL query used to read data from Databend");
    public static final Option<Integer> MAX_RETRIES = Options.key((String)"max_retries").intType().defaultValue((Object)3).withDescription("The max retries for Databend client");
    public static final Option<Boolean> AUTO_COMMIT = Options.key((String)"auto_commit").booleanType().defaultValue((Object)true).withDescription("Whether to auto commit for sink");
}

