/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.io.IOException;
import java.net.ConnectException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.Socket;
import java.net.UnknownServiceException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Address;
import okhttp3.CertificatePinner;
import okhttp3.ConnectionSpec;
import okhttp3.EventListener;
import okhttp3.Handshake;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import okhttp3.internal._UtilJvmKt;
import okhttp3.internal.connection.RealCall;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.connection.RealRoutePlanner;
import okhttp3.internal.connection.ReusePlan;
import okhttp3.internal.connection.RoutePlanner;
import okhttp3.internal.connection.TlsHandshakeKt;
import okhttp3.internal.http.ExchangeCodec;
import okhttp3.internal.http1.Http1ExchangeCodec;
import okhttp3.internal.platform.Platform;
import okhttp3.internal.tls.CertificateChainCleaner;
import okhttp3.internal.tls.OkHostnameVerifier;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 M2\u00020\u00012\u00020\u0002:\u0001MBW\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u000e\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\b\u00102\u001a\u000203H\u0016J\u0006\u00104\u001a\u000203J\b\u00105\u001a\u000203H\u0002J\b\u00106\u001a\u000207H\u0016J\u0018\u00108\u001a\u0002032\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0002J\b\u0010=\u001a\u000207H\u0016J\r\u0010>\u001a\u000207H\u0000\u00a2\u0006\u0002\b?J2\u0010@\u001a\u00020\u00002\b\b\u0002\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u000e2\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0002J\n\u0010A\u001a\u0004\u0018\u00010\u0010H\u0002J\b\u0010B\u001a\u00020\u0017H\u0016J%\u0010C\u001a\u0004\u0018\u00010\u00002\f\u0010D\u001a\b\u0012\u0004\u0012\u00020<0\f2\u0006\u00109\u001a\u00020:H\u0000\u00a2\u0006\u0002\bEJ\b\u0010F\u001a\u000203H\u0016J#\u0010G\u001a\u00020\u00002\f\u0010D\u001a\b\u0012\u0004\u0012\u00020<0\f2\u0006\u00109\u001a\u00020:H\u0000\u00a2\u0006\u0002\bHJ\b\u0010I\u001a\u00020\u0001H\u0016J\u001a\u0010J\u001a\u0002032\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010K\u001a\u0004\u0018\u00010LH\u0016R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010\u0012\u001a\u00020\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001fR\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0010\u0010)\u001a\u0004\u0018\u00010*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010+\u001a\u0004\u0018\u00010$X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u0010\u00100\u001a\u0004\u0018\u000101X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"Lokhttp3/internal/connection/ConnectPlan;", "Lokhttp3/internal/connection/RoutePlanner$Plan;", "Lokhttp3/internal/http/ExchangeCodec$Carrier;", "client", "Lokhttp3/OkHttpClient;", "call", "Lokhttp3/internal/connection/RealCall;", "routePlanner", "Lokhttp3/internal/connection/RealRoutePlanner;", "route", "Lokhttp3/Route;", "routes", "", "attempt", "", "tunnelRequest", "Lokhttp3/Request;", "connectionSpecIndex", "isTlsFallback", "", "(Lokhttp3/OkHttpClient;Lokhttp3/internal/connection/RealCall;Lokhttp3/internal/connection/RealRoutePlanner;Lokhttp3/Route;Ljava/util/List;ILokhttp3/Request;IZ)V", "canceled", "connection", "Lokhttp3/internal/connection/RealConnection;", "getConnectionSpecIndex$okhttp", "()I", "eventListener", "Lokhttp3/EventListener;", "handshake", "Lokhttp3/Handshake;", "isReady", "()Z", "isTlsFallback$okhttp", "protocol", "Lokhttp3/Protocol;", "rawSocket", "Ljava/net/Socket;", "getRoute", "()Lokhttp3/Route;", "getRoutes$okhttp", "()Ljava/util/List;", "sink", "Lokio/BufferedSink;", "socket", "getSocket$okhttp", "()Ljava/net/Socket;", "setSocket$okhttp", "(Ljava/net/Socket;)V", "source", "Lokio/BufferedSource;", "cancel", "", "closeQuietly", "connectSocket", "connectTcp", "Lokhttp3/internal/connection/RoutePlanner$ConnectResult;", "connectTls", "sslSocket", "Ljavax/net/ssl/SSLSocket;", "connectionSpec", "Lokhttp3/ConnectionSpec;", "connectTlsEtc", "connectTunnel", "connectTunnel$okhttp", "copy", "createTunnel", "handleSuccess", "nextConnectionSpec", "connectionSpecs", "nextConnectionSpec$okhttp", "noNewExchanges", "planWithCurrentOrInitialConnectionSpec", "planWithCurrentOrInitialConnectionSpec$okhttp", "retry", "trackFailure", "e", "Ljava/io/IOException;", "Companion", "okhttp"})
public final class ConnectPlan
implements RoutePlanner.Plan,
ExchangeCodec.Carrier {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OkHttpClient client;
    @NotNull
    private final RealCall call;
    @NotNull
    private final RealRoutePlanner routePlanner;
    @NotNull
    private final Route route;
    @Nullable
    private final List<Route> routes;
    private final int attempt;
    @Nullable
    private final Request tunnelRequest;
    private final int connectionSpecIndex;
    private final boolean isTlsFallback;
    @NotNull
    private final EventListener eventListener;
    private volatile boolean canceled;
    @Nullable
    private Socket rawSocket;
    @Nullable
    private Socket socket;
    @Nullable
    private Handshake handshake;
    @Nullable
    private Protocol protocol;
    @Nullable
    private BufferedSource source;
    @Nullable
    private BufferedSink sink;
    @Nullable
    private RealConnection connection;
    @NotNull
    private static final String NPE_THROW_WITH_NULL = "throw with null exception";
    private static final int MAX_TUNNEL_ATTEMPTS = 21;

    public ConnectPlan(@NotNull OkHttpClient client, @NotNull RealCall call, @NotNull RealRoutePlanner routePlanner, @NotNull Route route, @Nullable List<Route> routes, int attempt, @Nullable Request tunnelRequest, int connectionSpecIndex, boolean isTlsFallback) {
        Intrinsics.checkNotNullParameter(client, "client");
        Intrinsics.checkNotNullParameter(call, "call");
        Intrinsics.checkNotNullParameter(routePlanner, "routePlanner");
        Intrinsics.checkNotNullParameter(route, "route");
        this.client = client;
        this.call = call;
        this.routePlanner = routePlanner;
        this.route = route;
        this.routes = routes;
        this.attempt = attempt;
        this.tunnelRequest = tunnelRequest;
        this.connectionSpecIndex = connectionSpecIndex;
        this.isTlsFallback = isTlsFallback;
        this.eventListener = this.call.getEventListener$okhttp();
    }

    @Override
    @NotNull
    public Route getRoute() {
        return this.route;
    }

    @Nullable
    public final List<Route> getRoutes$okhttp() {
        return this.routes;
    }

    public final int getConnectionSpecIndex$okhttp() {
        return this.connectionSpecIndex;
    }

    public final boolean isTlsFallback$okhttp() {
        return this.isTlsFallback;
    }

    @Nullable
    public final Socket getSocket$okhttp() {
        return this.socket;
    }

    public final void setSocket$okhttp(@Nullable Socket socket) {
        this.socket = socket;
    }

    @Override
    public boolean isReady() {
        return this.protocol != null;
    }

    private final ConnectPlan copy(int attempt, Request tunnelRequest, int connectionSpecIndex, boolean isTlsFallback) {
        return new ConnectPlan(this.client, this.call, this.routePlanner, this.getRoute(), this.routes, attempt, tunnelRequest, connectionSpecIndex, isTlsFallback);
    }

    static /* synthetic */ ConnectPlan copy$default(ConnectPlan connectPlan, int n, Request request, int n2, boolean bl, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = connectPlan.attempt;
        }
        if ((n3 & 2) != 0) {
            request = connectPlan.tunnelRequest;
        }
        if ((n3 & 4) != 0) {
            n2 = connectPlan.connectionSpecIndex;
        }
        if ((n3 & 8) != 0) {
            bl = connectPlan.isTlsFallback;
        }
        return connectPlan.copy(n, request, n2, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public RoutePlanner.ConnectResult connectTcp() {
        RoutePlanner.ConnectResult $i$a$-check-ConnectPlan$connectTcp$222;
        if (!(this.rawSocket == null)) {
            boolean $i$a$-check-ConnectPlan$connectTcp$222 = false;
            String $i$a$-check-ConnectPlan$connectTcp$222 = "TCP already connected";
            throw new IllegalStateException($i$a$-check-ConnectPlan$connectTcp$222.toString());
        }
        boolean success = false;
        ((Collection)this.call.getPlansToCancel$okhttp()).add(this);
        try {
            this.eventListener.connectStart(this.call, this.getRoute().socketAddress(), this.getRoute().proxy());
            this.connectSocket();
            success = true;
            $i$a$-check-ConnectPlan$connectTcp$222 = new RoutePlanner.ConnectResult(this, null, null, 6, null);
            ((Collection)this.call.getPlansToCancel$okhttp()).remove(this);
        }
        catch (IOException e) {
            this.eventListener.connectFailed(this.call, this.getRoute().socketAddress(), this.getRoute().proxy(), null, e);
            RoutePlanner.ConnectResult connectResult = new RoutePlanner.ConnectResult(this, null, e, 2, null);
            return connectResult;
        }
        finally {
            block7: {
                ((Collection)this.call.getPlansToCancel$okhttp()).remove(this);
                if (success) break block7;
                Socket socket = this.rawSocket;
                if (socket != null) {
                    _UtilJvmKt.closeQuietly(socket);
                }
            }
        }
        return $i$a$-check-ConnectPlan$connectTcp$222;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public RoutePlanner.ConnectResult connectTlsEtc() {
        RoutePlanner.ConnectResult connectResult;
        boolean success;
        block17: {
            if (!(this.rawSocket != null)) {
                boolean $i$a$-check-ConnectPlan$connectTlsEtc$32 = false;
                String $i$a$-check-ConnectPlan$connectTlsEtc$32 = "TCP not connected";
                throw new IllegalStateException($i$a$-check-ConnectPlan$connectTlsEtc$32.toString());
            }
            if (!(!this.isReady())) {
                boolean $i$a$-check-ConnectPlan$connectTlsEtc$42 = false;
                String $i$a$-check-ConnectPlan$connectTlsEtc$42 = "already connected";
                throw new IllegalStateException($i$a$-check-ConnectPlan$connectTlsEtc$42.toString());
            }
            List<ConnectionSpec> connectionSpecs = this.getRoute().address().connectionSpecs();
            ConnectPlan retryTlsConnection = null;
            success = false;
            ((Collection)this.call.getPlansToCancel$okhttp()).add(this);
            try {
                RealConnection connection;
                RoutePlanner.ConnectResult tunnelResult;
                if (this.tunnelRequest != null && ((tunnelResult = this.connectTunnel$okhttp()).getNextPlan() != null || tunnelResult.getThrowable() != null)) {
                    connectResult = tunnelResult;
                    ((Collection)this.call.getPlansToCancel$okhttp()).remove(this);
                    break block17;
                }
                if (this.getRoute().address().sslSocketFactory() != null) {
                    BufferedSource bufferedSource = this.source;
                    if (bufferedSource != null && (bufferedSource = bufferedSource.getBuffer()) != null ? !((Buffer)bufferedSource).exhausted() : false) throw new IOException("TLS tunnel buffered too many bytes!");
                    BufferedSink bufferedSink = this.sink;
                    boolean bl = bufferedSink != null && (bufferedSink = bufferedSink.getBuffer()) != null ? !((Buffer)bufferedSink).exhausted() : false;
                    if (bl) {
                        throw new IOException("TLS tunnel buffered too many bytes!");
                    }
                    this.eventListener.secureConnectStart(this.call);
                    Socket socket = this.getRoute().address().sslSocketFactory().createSocket(this.rawSocket, this.getRoute().address().url().host(), this.getRoute().address().url().port(), true);
                    Intrinsics.checkNotNull(socket, "null cannot be cast to non-null type javax.net.ssl.SSLSocket");
                    SSLSocket sslSocket = (SSLSocket)socket;
                    ConnectPlan tlsEquipPlan = this.planWithCurrentOrInitialConnectionSpec$okhttp(connectionSpecs, sslSocket);
                    ConnectionSpec connectionSpec = connectionSpecs.get(tlsEquipPlan.connectionSpecIndex);
                    retryTlsConnection = tlsEquipPlan.nextConnectionSpec$okhttp(connectionSpecs, sslSocket);
                    connectionSpec.apply$okhttp(sslSocket, tlsEquipPlan.isTlsFallback);
                    this.connectTls(sslSocket, connectionSpec);
                    this.eventListener.secureConnectEnd(this.call, this.handshake);
                } else {
                    this.socket = this.rawSocket;
                    this.protocol = this.getRoute().address().protocols().contains((Object)Protocol.H2_PRIOR_KNOWLEDGE) ? Protocol.H2_PRIOR_KNOWLEDGE : Protocol.HTTP_1_1;
                }
                this.connection = connection = new RealConnection(this.client.getTaskRunner$okhttp(), this.client.connectionPool().getDelegate$okhttp(), this.getRoute(), this.rawSocket, this.socket, this.handshake, this.protocol, this.source, this.sink, this.client.pingIntervalMillis());
                connection.start();
                this.eventListener.connectEnd(this.call, this.getRoute().socketAddress(), this.getRoute().proxy(), this.protocol);
                success = true;
                RoutePlanner.ConnectResult connectResult2 = new RoutePlanner.ConnectResult(this, null, null, 6, null);
                ((Collection)this.call.getPlansToCancel$okhttp()).remove(this);
                return connectResult2;
            }
            catch (IOException e) {
                this.eventListener.connectFailed(this.call, this.getRoute().socketAddress(), this.getRoute().proxy(), null, e);
                if (!this.client.retryOnConnectionFailure() || !TlsHandshakeKt.retryTlsHandshake(e)) {
                    retryTlsConnection = null;
                }
                RoutePlanner.ConnectResult connectResult3 = new RoutePlanner.ConnectResult(this, retryTlsConnection, e);
                return connectResult3;
            }
        }
        Socket socket = this.socket;
        if (socket != null) {
            _UtilJvmKt.closeQuietly(socket);
        }
        Socket socket2 = this.rawSocket;
        if (socket2 == null) return connectResult;
        _UtilJvmKt.closeQuietly(socket2);
        return connectResult;
        finally {
            ((Collection)this.call.getPlansToCancel$okhttp()).remove(this);
            if (!success) {
                Socket socket3 = this.socket;
                if (socket3 != null) {
                    _UtilJvmKt.closeQuietly(socket3);
                }
                Socket socket4 = this.rawSocket;
                if (socket4 != null) {
                    _UtilJvmKt.closeQuietly(socket4);
                }
            }
        }
    }

    private final void connectSocket() throws IOException {
        block8: {
            Socket rawSocket;
            Socket socket;
            Proxy.Type type = this.getRoute().proxy().type();
            switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: 
                case 2: {
                    Socket socket2 = this.getRoute().address().socketFactory().createSocket();
                    socket = socket2;
                    Intrinsics.checkNotNull(socket2);
                    break;
                }
                default: {
                    socket = new Socket(this.getRoute().proxy());
                }
            }
            this.rawSocket = rawSocket = socket;
            if (this.canceled) {
                throw new IOException("canceled");
            }
            rawSocket.setSoTimeout(this.client.readTimeoutMillis());
            try {
                Platform.Companion.get().connectSocket(rawSocket, this.getRoute().socketAddress(), this.client.connectTimeoutMillis());
            }
            catch (ConnectException e) {
                ConnectException connectException;
                ConnectException $this$connectSocket_u24lambda_u2d3 = connectException = new ConnectException("Failed to connect to " + this.getRoute().socketAddress());
                boolean bl = false;
                $this$connectSocket_u24lambda_u2d3.initCause(e);
                throw (Throwable)connectException;
            }
            try {
                this.source = Okio.buffer(Okio.source(rawSocket));
                this.sink = Okio.buffer(Okio.sink(rawSocket));
            }
            catch (NullPointerException npe) {
                if (!Intrinsics.areEqual(npe.getMessage(), NPE_THROW_WITH_NULL)) break block8;
                throw new IOException(npe);
            }
        }
    }

    @NotNull
    public final RoutePlanner.ConnectResult connectTunnel$okhttp() throws IOException {
        Request request = this.createTunnel();
        if (request == null) {
            return new RoutePlanner.ConnectResult(this, null, null, 6, null);
        }
        Request nextTunnelRequest = request;
        Socket socket = this.rawSocket;
        if (socket != null) {
            _UtilJvmKt.closeQuietly(socket);
        }
        int nextAttempt = this.attempt + 1;
        if (nextAttempt >= 21) {
            ProtocolException failure = new ProtocolException("Too many tunnel connections attempted: 21");
            this.eventListener.connectFailed(this.call, this.getRoute().socketAddress(), this.getRoute().proxy(), null, failure);
            return new RoutePlanner.ConnectResult(this, null, failure, 2, null);
        }
        this.eventListener.connectEnd(this.call, this.getRoute().socketAddress(), this.getRoute().proxy(), null);
        return new RoutePlanner.ConnectResult(this, ConnectPlan.copy$default(this, nextAttempt, nextTunnelRequest, 0, false, 12, null), null, 4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void connectTls(SSLSocket sslSocket, ConnectionSpec connectionSpec) throws IOException {
        Address address = this.getRoute().address();
        boolean success = false;
        try {
            Handshake handshake2;
            if (connectionSpec.supportsTlsExtensions()) {
                Platform.Companion.get().configureTlsExtensions(sslSocket, address.url().host(), address.protocols());
            }
            sslSocket.startHandshake();
            SSLSession sslSocketSession = sslSocket.getSession();
            Intrinsics.checkNotNullExpressionValue(sslSocketSession, "sslSocketSession");
            Handshake unverifiedHandshake = Handshake.Companion.get(sslSocketSession);
            HostnameVerifier hostnameVerifier = address.hostnameVerifier();
            Intrinsics.checkNotNull(hostnameVerifier);
            if (!hostnameVerifier.verify(address.url().host(), sslSocketSession)) {
                List<Certificate> peerCertificates2 = unverifiedHandshake.peerCertificates();
                if (!((Collection)peerCertificates2).isEmpty()) {
                    Certificate certificate = peerCertificates2.get(0);
                    Intrinsics.checkNotNull(certificate, "null cannot be cast to non-null type java.security.cert.X509Certificate");
                    X509Certificate cert = (X509Certificate)certificate;
                    throw new SSLPeerUnverifiedException(StringsKt.trimMargin$default("\n            |Hostname " + address.url().host() + " not verified:\n            |    certificate: " + CertificatePinner.Companion.pin(cert) + "\n            |    DN: " + cert.getSubjectDN().getName() + "\n            |    subjectAltNames: " + OkHostnameVerifier.INSTANCE.allSubjectAltNames(cert) + "\n            ", null, 1, null));
                }
                throw new SSLPeerUnverifiedException("Hostname " + address.url().host() + " not verified (no certificates)");
            }
            CertificatePinner certificatePinner = address.certificatePinner();
            Intrinsics.checkNotNull(certificatePinner);
            CertificatePinner certificatePinner2 = certificatePinner;
            this.handshake = handshake2 = new Handshake(unverifiedHandshake.tlsVersion(), unverifiedHandshake.cipherSuite(), unverifiedHandshake.localCertificates(), (Function0<? extends List<? extends Certificate>>)new Function0<List<? extends Certificate>>(certificatePinner2, unverifiedHandshake, address){
                final /* synthetic */ CertificatePinner $certificatePinner;
                final /* synthetic */ Handshake $unverifiedHandshake;
                final /* synthetic */ Address $address;
                {
                    this.$certificatePinner = $certificatePinner;
                    this.$unverifiedHandshake = $unverifiedHandshake;
                    this.$address = $address;
                    super(0);
                }

                @NotNull
                public final List<Certificate> invoke() {
                    CertificateChainCleaner certificateChainCleaner = this.$certificatePinner.getCertificateChainCleaner$okhttp();
                    Intrinsics.checkNotNull(certificateChainCleaner);
                    return certificateChainCleaner.clean(this.$unverifiedHandshake.peerCertificates(), this.$address.url().host());
                }
            });
            certificatePinner2.check$okhttp(address.url().host(), (Function0<? extends List<? extends X509Certificate>>)new Function0<List<? extends X509Certificate>>(handshake2){
                final /* synthetic */ Handshake $handshake;
                {
                    this.$handshake = $handshake;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<X509Certificate> invoke() {
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = this.$handshake.peerCertificates();
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        Certificate certificate = (Certificate)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        Intrinsics.checkNotNull(it, "null cannot be cast to non-null type java.security.cert.X509Certificate");
                        collection.add((X509Certificate)it);
                    }
                    return (List)destination$iv$iv;
                }
            });
            String maybeProtocol = connectionSpec.supportsTlsExtensions() ? Platform.Companion.get().getSelectedProtocol(sslSocket) : (String)null;
            this.socket = sslSocket;
            this.source = Okio.buffer(Okio.source(sslSocket));
            this.sink = Okio.buffer(Okio.sink(sslSocket));
            String string = maybeProtocol;
            this.protocol = string != null ? Protocol.Companion.get(string) : Protocol.HTTP_1_1;
            success = true;
            Platform.Companion.get().afterHandshake(sslSocket);
        }
        catch (Throwable throwable) {
            Platform.Companion.get().afterHandshake(sslSocket);
            _UtilJvmKt.closeQuietly(sslSocket);
            throw throwable;
        }
    }

    private final Request createTunnel() throws IOException {
        Response response;
        Request request = this.tunnelRequest;
        Intrinsics.checkNotNull(request);
        Request nextRequest = request;
        HttpUrl url = this.getRoute().address().url();
        String requestLine = "CONNECT " + _UtilJvmKt.toHostHeader(url, true) + " HTTP/1.1";
        block4: while (true) {
            BufferedSink sink2;
            BufferedSource source2;
            Intrinsics.checkNotNull(this.source);
            Intrinsics.checkNotNull(this.sink);
            Http1ExchangeCodec tunnelCodec = new Http1ExchangeCodec(null, this, source2, sink2);
            source2.timeout().timeout(this.client.readTimeoutMillis(), TimeUnit.MILLISECONDS);
            sink2.timeout().timeout(this.client.writeTimeoutMillis(), TimeUnit.MILLISECONDS);
            tunnelCodec.writeRequest(nextRequest.headers(), requestLine);
            tunnelCodec.finishRequest();
            Response.Builder builder = tunnelCodec.readResponseHeaders(false);
            Intrinsics.checkNotNull(builder);
            response = builder.request(nextRequest).build();
            tunnelCodec.skipConnectBody(response);
            switch (response.code()) {
                case 200: {
                    return null;
                }
                case 407: {
                    if (this.getRoute().address().proxyAuthenticator().authenticate(this.getRoute(), response) != null) continue block4;
                    throw new IOException("Failed to authenticate with proxy");
                    if (!StringsKt.equals("close", Response.header$default(response, "Connection", null, 2, null), true)) continue block4;
                    return nextRequest;
                }
            }
            break;
        }
        throw new IOException("Unexpected response code for CONNECT: " + response.code());
    }

    @NotNull
    public final ConnectPlan planWithCurrentOrInitialConnectionSpec$okhttp(@NotNull List<ConnectionSpec> connectionSpecs, @NotNull SSLSocket sslSocket) throws IOException {
        Intrinsics.checkNotNullParameter(connectionSpecs, "connectionSpecs");
        Intrinsics.checkNotNullParameter(sslSocket, "sslSocket");
        if (this.connectionSpecIndex != -1) {
            return this;
        }
        ConnectPlan connectPlan = this.nextConnectionSpec$okhttp(connectionSpecs, sslSocket);
        if (connectPlan == null) {
            StringBuilder stringBuilder = new StringBuilder().append("Unable to find acceptable protocols. isFallback=").append(this.isTlsFallback).append(", modes=").append(connectionSpecs).append(", supported protocols=");
            Object[] objectArray = sslSocket.getEnabledProtocols();
            Intrinsics.checkNotNull(objectArray);
            String string = Arrays.toString(objectArray);
            Intrinsics.checkNotNullExpressionValue(string, "toString(this)");
            throw new UnknownServiceException(stringBuilder.append(string).toString());
        }
        return connectPlan;
    }

    @Nullable
    public final ConnectPlan nextConnectionSpec$okhttp(@NotNull List<ConnectionSpec> connectionSpecs, @NotNull SSLSocket sslSocket) {
        Intrinsics.checkNotNullParameter(connectionSpecs, "connectionSpecs");
        Intrinsics.checkNotNullParameter(sslSocket, "sslSocket");
        int n = connectionSpecs.size();
        for (int i = this.connectionSpecIndex + 1; i < n; ++i) {
            if (!connectionSpecs.get(i).isCompatible(sslSocket)) continue;
            return ConnectPlan.copy$default(this, 0, null, i, this.connectionSpecIndex != -1, 3, null);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public RealConnection handleSuccess() {
        RealConnection connection;
        this.call.getClient().getRouteDatabase$okhttp().connected(this.getRoute());
        ReusePlan pooled3 = this.routePlanner.planReusePooledConnection$okhttp(this, this.routes);
        if (pooled3 != null) {
            return pooled3.getConnection();
        }
        RealConnection realConnection = this.connection;
        Intrinsics.checkNotNull(realConnection);
        RealConnection realConnection2 = connection = realConnection;
        synchronized (realConnection2) {
            boolean bl = false;
            this.client.connectionPool().getDelegate$okhttp().put(connection);
            this.call.acquireConnectionNoEvents(connection);
            Unit unit = Unit.INSTANCE;
        }
        this.eventListener.connectionAcquired(this.call, connection);
        return connection;
    }

    @Override
    public void trackFailure(@NotNull RealCall call, @Nullable IOException e) {
        Intrinsics.checkNotNullParameter(call, "call");
    }

    @Override
    public void noNewExchanges() {
    }

    @Override
    public void cancel() {
        block0: {
            this.canceled = true;
            Socket socket = this.rawSocket;
            if (socket == null) break block0;
            _UtilJvmKt.closeQuietly(socket);
        }
    }

    @Override
    @NotNull
    public RoutePlanner.Plan retry() {
        return new ConnectPlan(this.client, this.call, this.routePlanner, this.getRoute(), this.routes, this.attempt, this.tunnelRequest, this.connectionSpecIndex, this.isTlsFallback);
    }

    public final void closeQuietly() {
        block0: {
            Socket socket = this.socket;
            if (socket == null) break block0;
            _UtilJvmKt.closeQuietly(socket);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lokhttp3/internal/connection/ConnectPlan$Companion;", "", "()V", "MAX_TUNNEL_ATTEMPTS", "", "NPE_THROW_WITH_NULL", "", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Proxy.Type.values().length];
            nArray[Proxy.Type.DIRECT.ordinal()] = 1;
            nArray[Proxy.Type.HTTP.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

