/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.saphana;

import com.google.auto.service.AutoService;
import java.util.Arrays;
import java.util.List;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.converter.BasicTypeDefine;
import org.apache.seatunnel.api.table.converter.TypeConverter;
import org.apache.seatunnel.api.table.type.ArrayType;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.PrimitiveByteArrayType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.connectors.seatunnel.common.source.TypeDefineUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={TypeConverter.class})
public class SapHanaTypeConverter
implements TypeConverter<BasicTypeDefine> {
    private static final Logger log = LoggerFactory.getLogger(SapHanaTypeConverter.class);
    public static final String HANA_BINARY = "BINARY";
    public static final String HANA_VARBINARY = "VARBINARY";
    public static final String HANA_BOOLEAN = "BOOLEAN";
    public static final String HANA_VARCHAR = "VARCHAR";
    public static final String HANA_NVARCHAR = "NVARCHAR";
    public static final String HANA_ALPHANUM = "ALPHANUM";
    public static final String HANA_SHORTTEXT = "SHORTTEXT";
    public static final String HANA_DATE = "DATE";
    public static final String HANA_TIME = "TIME";
    public static final String HANA_SECONDDATE = "SECONDDATE";
    public static final String HANA_TIMESTAMP = "TIMESTAMP";
    public static final String HANA_BLOB = "BLOB";
    public static final String HANA_CLOB = "CLOB";
    public static final String HANA_NCLOB = "NCLOB";
    public static final String HANA_TEXT = "TEXT";
    public static final String HANA_BINTEXT = "BINTEXT";
    public static final String HANA_ARRAY = "ARRAY";
    public static final String HANA_TINYINT = "TINYINT";
    public static final String HANA_SMALLINT = "SMALLINT";
    public static final String HANA_INTEGER = "INTEGER";
    public static final String HANA_BIGINT = "BIGINT";
    public static final String HANA_SMALLDECIMAL = "SMALLDECIMAL";
    public static final String HANA_DECIMAL = "DECIMAL";
    public static final String HANA_DOUBLE = "DOUBLE";
    public static final String HANA_REAL = "REAL";
    public static final String HANA_ST_POINT = "ST_POINT";
    public static final String HANA_ST_GEOMETRY = "ST_GEOMETRY";
    public static final int MAX_PRECISION = 38;
    public static final int DEFAULT_PRECISION = 38;
    public static final int MAX_SCALE = 6176;
    public static final int MAX_SMALL_DECIMAL_SCALE = 368;
    public static final int DEFAULT_SCALE = 0;
    public static final int TIMESTAMP_DEFAULT_SCALE = 7;
    public static final int MAX_TIMESTAMP_SCALE = 7;
    public static final long MAX_BINARY_LENGTH = 5000L;
    public static final long MAX_LOB_LENGTH = Integer.MAX_VALUE;
    public static final long MAX_NVARCHAR_LENGTH = 5000L;
    public static final List<String> shouldAppendLength = Arrays.asList("BINARY", "VARBINARY", "VARCHAR", "NVARCHAR", "ALPHANUM", "SHORTTEXT");
    public static final SapHanaTypeConverter INSTANCE = new SapHanaTypeConverter();

    public String identifier() {
        return "SapHana";
    }

    public Column convert(BasicTypeDefine typeDefine) {
        PhysicalColumn.PhysicalColumnBuilder builder = PhysicalColumn.builder().name(typeDefine.getName()).sourceType(typeDefine.getColumnType()).nullable(typeDefine.isNullable()).defaultValue(typeDefine.getDefaultValue()).comment(typeDefine.getComment());
        String hanaType = typeDefine.getDataType().toUpperCase();
        if (typeDefine.getColumnType().endsWith(" ARRAY")) {
            ArrayType newType;
            typeDefine.setColumnType(typeDefine.getColumnType().replace(" ARRAY", ""));
            typeDefine.setDataType(SapHanaTypeConverter.removeColumnSizeIfNeed(typeDefine.getColumnType()));
            Column arrayColumn = this.convert(typeDefine);
            switch (arrayColumn.getDataType().getSqlType()) {
                case STRING: {
                    newType = ArrayType.STRING_ARRAY_TYPE;
                    break;
                }
                case BOOLEAN: {
                    newType = ArrayType.BOOLEAN_ARRAY_TYPE;
                    break;
                }
                case TINYINT: {
                    newType = ArrayType.BYTE_ARRAY_TYPE;
                    break;
                }
                case SMALLINT: {
                    newType = ArrayType.SHORT_ARRAY_TYPE;
                    break;
                }
                case INT: {
                    newType = ArrayType.INT_ARRAY_TYPE;
                    break;
                }
                case BIGINT: {
                    newType = ArrayType.LONG_ARRAY_TYPE;
                    break;
                }
                case FLOAT: {
                    newType = ArrayType.FLOAT_ARRAY_TYPE;
                    break;
                }
                case DOUBLE: {
                    newType = ArrayType.DOUBLE_ARRAY_TYPE;
                    break;
                }
                case DATE: {
                    newType = ArrayType.LOCAL_DATE_ARRAY_TYPE;
                    break;
                }
                case TIME: {
                    newType = ArrayType.LOCAL_TIME_ARRAY_TYPE;
                    break;
                }
                case TIMESTAMP: {
                    newType = ArrayType.LOCAL_DATE_TIME_ARRAY_TYPE;
                    break;
                }
                default: {
                    throw CommonError.unsupportedDataType((String)"SeaTunnel", (String)arrayColumn.getDataType().getSqlType().toString(), (String)typeDefine.getName());
                }
            }
            return new PhysicalColumn(arrayColumn.getName(), (SeaTunnelDataType)newType, arrayColumn.getColumnLength(), arrayColumn.getScale(), arrayColumn.isNullable(), arrayColumn.getDefaultValue(), arrayColumn.getComment(), arrayColumn.getSourceType() + " ARRAY", arrayColumn.getOptions());
        }
        switch (hanaType) {
            case "BINARY": 
            case "VARBINARY": {
                builder.dataType((SeaTunnelDataType)PrimitiveByteArrayType.INSTANCE);
                if (typeDefine.getLength() == null || typeDefine.getLength() == 0L) {
                    builder.columnLength(Long.valueOf(5000L));
                    break;
                }
                builder.columnLength(typeDefine.getLength());
                break;
            }
            case "BOOLEAN": {
                builder.dataType((SeaTunnelDataType)BasicType.BOOLEAN_TYPE);
                break;
            }
            case "VARCHAR": 
            case "ALPHANUM": 
            case "CLOB": 
            case "NCLOB": 
            case "TEXT": 
            case "BINTEXT": {
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                if (typeDefine.getLength() == null || typeDefine.getLength() == 0L) {
                    builder.columnLength(Long.valueOf(Integer.MAX_VALUE));
                    break;
                }
                builder.columnLength(typeDefine.getLength());
                break;
            }
            case "NVARCHAR": 
            case "SHORTTEXT": {
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                builder.columnLength(TypeDefineUtils.charTo4ByteLength(typeDefine.getLength()));
                break;
            }
            case "DATE": {
                builder.dataType((SeaTunnelDataType)LocalTimeType.LOCAL_DATE_TYPE);
                break;
            }
            case "TIME": {
                builder.dataType((SeaTunnelDataType)LocalTimeType.LOCAL_TIME_TYPE);
                builder.scale(Integer.valueOf(0));
                break;
            }
            case "SECONDDATE": {
                builder.dataType((SeaTunnelDataType)LocalTimeType.LOCAL_DATE_TIME_TYPE);
                builder.scale(Integer.valueOf(0));
                break;
            }
            case "TIMESTAMP": {
                builder.dataType((SeaTunnelDataType)LocalTimeType.LOCAL_DATE_TIME_TYPE);
                if (typeDefine.getScale() == null) {
                    builder.scale(Integer.valueOf(7));
                    break;
                }
                builder.scale(typeDefine.getScale());
                break;
            }
            case "BLOB": {
                builder.dataType((SeaTunnelDataType)PrimitiveByteArrayType.INSTANCE);
                builder.columnLength(typeDefine.getLength());
                break;
            }
            case "TINYINT": 
            case "SMALLINT": {
                builder.dataType((SeaTunnelDataType)BasicType.SHORT_TYPE);
                break;
            }
            case "INTEGER": {
                builder.dataType((SeaTunnelDataType)BasicType.INT_TYPE);
                break;
            }
            case "BIGINT": {
                builder.dataType((SeaTunnelDataType)BasicType.LONG_TYPE);
                break;
            }
            case "DECIMAL": {
                long precision;
                Integer scale = typeDefine.getScale();
                long l = precision = typeDefine.getLength() != null ? (long)typeDefine.getLength().intValue() : 34L;
                if (scale == null) {
                    builder.dataType((SeaTunnelDataType)new DecimalType((int)precision, 0));
                    builder.columnLength(Long.valueOf(precision));
                    builder.scale(Integer.valueOf(0));
                    break;
                }
                if (scale < 0) {
                    int newPrecision = (int)(precision - (long)scale.intValue());
                    if (newPrecision == 1) {
                        builder.dataType((SeaTunnelDataType)BasicType.SHORT_TYPE);
                        break;
                    }
                    if (newPrecision <= 9) {
                        builder.dataType((SeaTunnelDataType)BasicType.INT_TYPE);
                        break;
                    }
                    if (newPrecision <= 18) {
                        builder.dataType((SeaTunnelDataType)BasicType.LONG_TYPE);
                        break;
                    }
                    if (newPrecision < 38) {
                        builder.dataType((SeaTunnelDataType)new DecimalType(newPrecision, 0));
                        builder.columnLength(Long.valueOf(newPrecision));
                        break;
                    }
                    builder.dataType((SeaTunnelDataType)new DecimalType(38, 0));
                    builder.columnLength(Long.valueOf(38L));
                    break;
                }
                builder.dataType((SeaTunnelDataType)new DecimalType((int)precision, scale.intValue()));
                builder.columnLength(Long.valueOf(precision));
                builder.scale(scale);
                break;
            }
            case "SMALLDECIMAL": {
                int smallDecimalScale;
                int n = smallDecimalScale = typeDefine.getScale() != null ? typeDefine.getScale() : 0;
                if (typeDefine.getPrecision() == null) {
                    builder.dataType((SeaTunnelDataType)new DecimalType(38, smallDecimalScale));
                    builder.columnLength(Long.valueOf(38L));
                    builder.scale(Integer.valueOf(smallDecimalScale));
                    break;
                }
                builder.dataType((SeaTunnelDataType)new DecimalType(typeDefine.getPrecision().intValue(), smallDecimalScale));
                builder.columnLength(typeDefine.getPrecision());
                builder.scale(Integer.valueOf(smallDecimalScale));
                break;
            }
            case "REAL": {
                builder.dataType((SeaTunnelDataType)BasicType.FLOAT_TYPE);
                break;
            }
            case "DOUBLE": {
                builder.dataType((SeaTunnelDataType)BasicType.DOUBLE_TYPE);
                break;
            }
            case "ST_POINT": 
            case "ST_GEOMETRY": {
                builder.columnLength(typeDefine.getLength());
                builder.dataType((SeaTunnelDataType)PrimitiveByteArrayType.INSTANCE);
                break;
            }
            default: {
                throw CommonError.convertToSeaTunnelTypeError((String)"SapHana", (String)hanaType, (String)typeDefine.getName());
            }
        }
        return builder.build();
    }

    public BasicTypeDefine reconvert(Column column) {
        BasicTypeDefine.BasicTypeDefineBuilder builder = BasicTypeDefine.builder().name(column.getName()).nullable(column.isNullable()).comment(column.getComment()).defaultValue(column.getDefaultValue());
        switch (column.getDataType().getSqlType()) {
            case BOOLEAN: {
                builder.columnType(HANA_BOOLEAN);
                builder.dataType(HANA_BOOLEAN);
                builder.length(Long.valueOf(2L));
                break;
            }
            case TINYINT: {
                builder.columnType(HANA_TINYINT);
                builder.dataType(HANA_TINYINT);
                break;
            }
            case SMALLINT: {
                builder.columnType(HANA_SMALLINT);
                builder.dataType(HANA_SMALLINT);
                break;
            }
            case INT: {
                builder.columnType(HANA_INTEGER);
                builder.dataType(HANA_INTEGER);
                break;
            }
            case BIGINT: {
                builder.columnType(HANA_BIGINT);
                builder.dataType(HANA_BIGINT);
                break;
            }
            case FLOAT: {
                builder.columnType(HANA_REAL);
                builder.dataType(HANA_REAL);
                break;
            }
            case DOUBLE: {
                builder.columnType(HANA_DOUBLE);
                builder.dataType(HANA_DOUBLE);
                break;
            }
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)column.getDataType();
                long precision = decimalType.getPrecision();
                int scale = decimalType.getScale();
                if (precision <= 0L) {
                    precision = 38L;
                    scale = 0;
                    log.warn("The decimal column {} type decimal({},{}) is out of range, which is precision less than 0, it will be converted to decimal({},{})", new Object[]{column.getName(), decimalType.getPrecision(), decimalType.getScale(), precision, scale});
                } else if (precision > 38L) {
                    scale = (int)Math.max(0L, (long)scale - (precision - 38L));
                    precision = 38L;
                    log.warn("The decimal column {} type decimal({},{}) is out of range, which exceeds the maximum precision of {}, it will be converted to decimal({},{})", new Object[]{column.getName(), decimalType.getPrecision(), decimalType.getScale(), 38, precision, scale});
                }
                if (scale < 0) {
                    scale = 0;
                    log.warn("The decimal column {} type decimal({},{}) is out of range, which is scale less than 0, it will be converted to decimal({},{})", new Object[]{column.getName(), decimalType.getPrecision(), decimalType.getScale(), precision, scale});
                } else if (scale > 6176) {
                    scale = 6176;
                    log.warn("The decimal column {} type decimal({},{}) is out of range, which exceeds the maximum scale of {}, it will be converted to decimal({},{})", new Object[]{column.getName(), decimalType.getPrecision(), decimalType.getScale(), 6176, precision, scale});
                }
                builder.columnType(String.format("%s(%s,%s)", HANA_DECIMAL, precision, scale));
                builder.dataType(HANA_DECIMAL);
                builder.precision(Long.valueOf(precision));
                builder.scale(Integer.valueOf(scale));
                break;
            }
            case BYTES: {
                builder.columnType(HANA_BLOB);
                builder.dataType(HANA_BLOB);
                break;
            }
            case STRING: {
                if (column.getColumnLength() == null || column.getColumnLength() <= 5000L) {
                    builder.columnType(HANA_NVARCHAR);
                    builder.dataType(HANA_NVARCHAR);
                    builder.length(Long.valueOf(column.getColumnLength() == null ? 5000L : column.getColumnLength()));
                    break;
                }
                builder.columnType(HANA_CLOB);
                builder.dataType(HANA_CLOB);
                break;
            }
            case DATE: {
                builder.columnType(HANA_DATE);
                builder.dataType(HANA_DATE);
                break;
            }
            case TIME: {
                builder.columnType(HANA_TIME);
                builder.dataType(HANA_TIME);
                break;
            }
            case TIMESTAMP: {
                if (column.getScale() == null || column.getScale() <= 0) {
                    builder.columnType(HANA_SECONDDATE);
                    builder.dataType(HANA_SECONDDATE);
                    break;
                }
                int timestampScale = column.getScale();
                if (column.getScale() > 7) {
                    timestampScale = 7;
                    log.warn("The timestamp column {} type timestamp({}) is out of range, which exceeds the maximum scale of {}, it will be converted to timestamp({})", new Object[]{column.getName(), column.getScale(), 7, timestampScale});
                }
                builder.columnType(HANA_TIMESTAMP);
                builder.dataType(HANA_TIMESTAMP);
                builder.scale(Integer.valueOf(timestampScale));
                break;
            }
            default: {
                throw CommonError.convertToConnectorTypeError((String)"SapHana", (String)column.getDataType().getSqlType().name(), (String)column.getName());
            }
        }
        BasicTypeDefine typeDefine = builder.build();
        typeDefine.setColumnType(SapHanaTypeConverter.appendColumnSizeIfNeed(typeDefine.getColumnType(), typeDefine.getLength(), typeDefine.getScale()));
        return typeDefine;
    }

    public static String appendColumnSizeIfNeed(String columnType, Long length, Integer scale) {
        if (shouldAppendLength.contains(columnType) && length != null && length != 0L) {
            return columnType + "(" + length + ")";
        }
        if (columnType.equalsIgnoreCase(HANA_DECIMAL) && length != null && scale != null && length != 0L) {
            return columnType + "(" + length + "," + scale + ")";
        }
        return columnType;
    }

    public static String removeColumnSizeIfNeed(String columnType) {
        for (String s : shouldAppendLength) {
            if (!columnType.startsWith(s)) continue;
            return columnType.split("\\(")[0];
        }
        return columnType;
    }
}

