/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.oceanbase;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.SQLType;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import org.apache.commons.lang3.StringUtils;

public enum OceanBaseMysqlType implements SQLType
{
    DECIMAL("DECIMAL", 3, BigDecimal.class, 64, true, 65L, "[(M[,D])] [UNSIGNED] [ZEROFILL]"),
    DECIMAL_UNSIGNED("DECIMAL UNSIGNED", 3, BigDecimal.class, 96, true, 65L, "[(M[,D])] [UNSIGNED] [ZEROFILL]"),
    TINYINT("TINYINT", -6, Integer.class, 64, true, 3L, "[(M)] [UNSIGNED] [ZEROFILL]"),
    TINYINT_UNSIGNED("TINYINT UNSIGNED", -6, Integer.class, 96, true, 3L, "[(M)] [UNSIGNED] [ZEROFILL]"),
    BOOLEAN("BOOLEAN", 16, Boolean.class, 0, false, 3L, ""),
    SMALLINT("SMALLINT", 5, Integer.class, 64, true, 5L, "[(M)] [UNSIGNED] [ZEROFILL]"),
    SMALLINT_UNSIGNED("SMALLINT UNSIGNED", 5, Integer.class, 96, true, 5L, "[(M)] [UNSIGNED] [ZEROFILL]"),
    INT("INT", 4, Integer.class, 64, true, 10L, "[(M)] [UNSIGNED] [ZEROFILL]"),
    INT_UNSIGNED("INT UNSIGNED", 4, Long.class, 96, true, 10L, "[(M)] [UNSIGNED] [ZEROFILL]"),
    FLOAT("FLOAT", 7, Float.class, 64, true, 12L, "[(M,D)] [UNSIGNED] [ZEROFILL]"),
    FLOAT_UNSIGNED("FLOAT UNSIGNED", 7, Float.class, 96, true, 12L, "[(M,D)] [UNSIGNED] [ZEROFILL]"),
    DOUBLE("DOUBLE", 8, Double.class, 64, true, 22L, "[(M,D)] [UNSIGNED] [ZEROFILL]"),
    DOUBLE_UNSIGNED("DOUBLE UNSIGNED", 8, Double.class, 96, true, 22L, "[(M,D)] [UNSIGNED] [ZEROFILL]"),
    NULL("NULL", 0, Object.class, 0, false, 0L, ""),
    TIMESTAMP("TIMESTAMP", 93, Timestamp.class, 0, false, 26L, "[(fsp)]"),
    BIGINT("BIGINT", -5, Long.class, 64, true, 19L, "[(M)] [UNSIGNED] [ZEROFILL]"),
    BIGINT_UNSIGNED("BIGINT UNSIGNED", -5, BigInteger.class, 96, true, 20L, "[(M)] [UNSIGNED] [ZEROFILL]"),
    MEDIUMINT("MEDIUMINT", 4, Integer.class, 64, true, 7L, "[(M)] [UNSIGNED] [ZEROFILL]"),
    MEDIUMINT_UNSIGNED("MEDIUMINT UNSIGNED", 4, Integer.class, 96, true, 8L, "[(M)] [UNSIGNED] [ZEROFILL]"),
    DATE("DATE", 91, Date.class, 0, false, 10L, ""),
    TIME("TIME", 92, Time.class, 0, false, 16L, "[(fsp)]"),
    DATETIME("DATETIME", 93, LocalDateTime.class, 0, false, 26L, "[(fsp)]"),
    YEAR("YEAR", 91, Date.class, 0, false, 4L, "[(4)]"),
    VARCHAR("VARCHAR", 12, String.class, 0, false, 65535L, "(M) [CHARACTER SET charset_name] [COLLATE collation_name]"),
    VARBINARY("VARBINARY", -3, null, 0, false, 65535L, "(M)"),
    BIT("BIT", -7, Boolean.class, 0, true, 1L, "[(M)]"),
    JSON("JSON", -1, String.class, 0, false, 0x40000000L, ""),
    ENUM("ENUM", 1, String.class, 0, false, 65535L, "('value1','value2',...) [CHARACTER SET charset_name] [COLLATE collation_name]"),
    SET("SET", 1, String.class, 0, false, 64L, "('value1','value2',...) [CHARACTER SET charset_name] [COLLATE collation_name]"),
    TINYBLOB("TINYBLOB", -3, null, 0, false, 255L, ""),
    TINYTEXT("TINYTEXT", 12, String.class, 0, false, 255L, " [CHARACTER SET charset_name] [COLLATE collation_name]"),
    MEDIUMBLOB("MEDIUMBLOB", -4, null, 0, false, 0xFFFFFFL, ""),
    MEDIUMTEXT("MEDIUMTEXT", -1, String.class, 0, false, 0xFFFFFFL, " [CHARACTER SET charset_name] [COLLATE collation_name]"),
    LONGBLOB("LONGBLOB", -4, null, 0, false, 0xFFFFFFFFL, ""),
    LONGTEXT("LONGTEXT", -1, String.class, 0, false, 0xFFFFFFFFL, " [CHARACTER SET charset_name] [COLLATE collation_name]"),
    BLOB("BLOB", -4, null, 0, false, 65535L, "[(M)]"),
    TEXT("TEXT", -1, String.class, 0, false, 65535L, "[(M)] [CHARACTER SET charset_name] [COLLATE collation_name]"),
    CHAR("CHAR", 1, String.class, 0, false, 255L, "[(M)] [CHARACTER SET charset_name] [COLLATE collation_name]"),
    BINARY("BINARY", -2, null, 0, false, 255L, "(M)"),
    GEOMETRY("GEOMETRY", -2, null, 0, false, 65535L, ""),
    UNKNOWN("UNKNOWN", 1111, null, 0, false, 65535L, "");

    private final String name;
    protected int jdbcType;
    protected final Class<?> javaClass;
    private final int flagsMask;
    private final boolean isDecimal;
    private final Long precision;
    private final String createParams;
    public static final int FIELD_FLAG_UNSIGNED = 32;
    public static final int FIELD_FLAG_ZEROFILL = 64;
    private static final boolean IS_DECIMAL = true;
    private static final boolean IS_NOT_DECIMAL = false;

    private OceanBaseMysqlType(String oceanBaseMysqlTypeName, int jdbcType, Class<?> javaClass, int allowedFlags, boolean isDec, Long precision, String createParams) {
        this.name = oceanBaseMysqlTypeName;
        this.jdbcType = jdbcType;
        this.javaClass = javaClass;
        this.flagsMask = allowedFlags;
        this.isDecimal = isDec;
        this.precision = precision;
        this.createParams = createParams;
    }

    public static OceanBaseMysqlType getByName(String fullMysqlTypeName) {
        String typeName = "";
        typeName = fullMysqlTypeName.indexOf("(") != -1 ? fullMysqlTypeName.substring(0, fullMysqlTypeName.indexOf("(")).trim() : fullMysqlTypeName;
        if (StringUtils.indexOfIgnoreCase((CharSequence)typeName, (CharSequence)"DECIMAL") != -1 || StringUtils.indexOfIgnoreCase((CharSequence)typeName, (CharSequence)"DEC") != -1 || StringUtils.indexOfIgnoreCase((CharSequence)typeName, (CharSequence)"NUMERIC") != -1 || StringUtils.indexOfIgnoreCase((CharSequence)typeName, (CharSequence)"FIXED") != -1) {
            return StringUtils.indexOfIgnoreCase((CharSequence)fullMysqlTypeName, (CharSequence)"UNSIGNED") != -1 ? DECIMAL_UNSIGNED : DECIMAL;
        }
        if (StringUtils.indexOfIgnoreCase((CharSequence)typeName, (CharSequence)"TINYBLOB") != -1) {
            return TINYBLOB;
        }
        if (StringUtils.indexOfIgnoreCase((CharSequence)typeName, (CharSequence)"TINYTEXT") != -1) {
            return TINYTEXT;
        }
        if (StringUtils.indexOfIgnoreCase((CharSequence)typeName, (CharSequence)"TINYINT") != -1 || StringUtils.indexOfIgnoreCase((CharSequence)typeName, (CharSequence)"TINY") != -1 || StringUtils.indexOfIgnoreCase((CharSequence)typeName, (CharSequence)"INT1") != -1) {
            return StringUtils.indexOfIgnoreCase((CharSequence)fullMysqlTypeName, (CharSequence)"UNSIGNED") != -1 || StringUtils.indexOfIgnoreCase((CharSequence)fullMysqlTypeName, (CharSequence)"ZEROFILL") != -1 ? TINYINT_UNSIGNED : TINYINT;
        }
        if (StringUtils.indexOfIgnoreCase((CharSequence)typeName, (CharSequence)"MEDIUMINT") != -1 || StringUtils.indexOfIgnoreCase((CharSequence)typeName, (CharSequence)"INT24") != -1 || StringUtils.indexOfIgnoreCase((CharSequence)typeName, (CharSequence)"INT3") != -1 || StringUtils.indexOfIgnoreCase((CharSequence)typeName, (CharSequence)"MIDDLEINT") != -1) {
            return StringUtils.indexOfIgnoreCase((CharSequence)fullMysqlTypeName, (CharSequence)"UNSIGNED") != -1 || StringUtils.indexOfIgnoreCase((CharSequence)fullMysqlTypeName, (CharSequence)"ZEROFILL") != -1 ? MEDIUMINT_UNSIGNED : MEDIUMINT;
        }
        if (StringUtils.indexOfIgnoreCase((CharSequence)typeName, (CharSequence)"SMALLINT") != -1 || StringUtils.indexOfIgnoreCase((CharSequence)typeName, (CharSequence)"INT2") != -1) {
            return StringUtils.indexOfIgnoreCase((CharSequence)fullMysqlTypeName, (CharSequence)"UNSIGNED") != -1 || StringUtils.indexOfIgnoreCase((CharSequence)fullMysqlTypeName, (CharSequence)"ZEROFILL") != -1 ? SMALLINT_UNSIGNED : SMALLINT;
        }
        if (StringUtils.indexOfIgnoreCase((CharSequence)typeName, (CharSequence)"BIGINT") != -1 || StringUtils.indexOfIgnoreCase((CharSequence)typeName, (CharSequence)"SERIAL") != -1 || StringUtils.indexOfIgnoreCase((CharSequence)typeName, (CharSequence)"INT8") != -1) {
            return StringUtils.indexOfIgnoreCase((CharSequence)fullMysqlTypeName, (CharSequence)"UNSIGNED") != -1 || StringUtils.indexOfIgnoreCase((CharSequence)fullMysqlTypeName, (CharSequence)"ZEROFILL") != -1 ? BIGINT_UNSIGNED : BIGINT;
        }
        if (StringUtils.indexOfIgnoreCase((CharSequence)typeName, (CharSequence)"POINT") == -1) {
            if (StringUtils.indexOfIgnoreCase((CharSequence)typeName, (CharSequence)"INT") != -1 || StringUtils.indexOfIgnoreCase((CharSequence)typeName, (CharSequence)"INTEGER") != -1 || StringUtils.indexOfIgnoreCase((CharSequence)typeName, (CharSequence)"INT4") != -1) {
                return StringUtils.indexOfIgnoreCase((CharSequence)fullMysqlTypeName, (CharSequence)"UNSIGNED") != -1 || StringUtils.indexOfIgnoreCase((CharSequence)fullMysqlTypeName, (CharSequence)"ZEROFILL") != -1 ? INT_UNSIGNED : INT;
            }
            if (StringUtils.indexOfIgnoreCase((CharSequence)typeName, (CharSequence)"DOUBLE") != -1 || StringUtils.indexOfIgnoreCase((CharSequence)typeName, (CharSequence)"REAL") != -1 || StringUtils.indexOfIgnoreCase((CharSequence)typeName, (CharSequence)"FLOAT8") != -1) {
                return StringUtils.indexOfIgnoreCase((CharSequence)fullMysqlTypeName, (CharSequence)"UNSIGNED") != -1 || StringUtils.indexOfIgnoreCase((CharSequence)fullMysqlTypeName, (CharSequence)"ZEROFILL") != -1 ? DOUBLE_UNSIGNED : DOUBLE;
            }
            if (StringUtils.indexOfIgnoreCase((CharSequence)typeName, (CharSequence)"FLOAT") != -1) {
                return StringUtils.indexOfIgnoreCase((CharSequence)fullMysqlTypeName, (CharSequence)"UNSIGNED") != -1 || StringUtils.indexOfIgnoreCase((CharSequence)fullMysqlTypeName, (CharSequence)"ZEROFILL") != -1 ? FLOAT_UNSIGNED : FLOAT;
            }
            if (StringUtils.indexOfIgnoreCase((CharSequence)typeName, (CharSequence)"NULL") != -1) {
                return NULL;
            }
            if (StringUtils.indexOfIgnoreCase((CharSequence)typeName, (CharSequence)"TIMESTAMP") != -1) {
                return TIMESTAMP;
            }
            if (StringUtils.indexOfIgnoreCase((CharSequence)typeName, (CharSequence)"DATETIME") != -1) {
                return DATETIME;
            }
            if (StringUtils.indexOfIgnoreCase((CharSequence)typeName, (CharSequence)"DATE") != -1) {
                return DATE;
            }
            if (StringUtils.indexOfIgnoreCase((CharSequence)typeName, (CharSequence)"TIME") != -1) {
                return TIME;
            }
            if (StringUtils.indexOfIgnoreCase((CharSequence)typeName, (CharSequence)"YEAR") != -1) {
                return YEAR;
            }
            if (StringUtils.indexOfIgnoreCase((CharSequence)typeName, (CharSequence)"LONGBLOB") != -1) {
                return LONGBLOB;
            }
            if (StringUtils.indexOfIgnoreCase((CharSequence)typeName, (CharSequence)"LONGTEXT") != -1) {
                return LONGTEXT;
            }
            if (StringUtils.indexOfIgnoreCase((CharSequence)typeName, (CharSequence)"MEDIUMBLOB") != -1 || StringUtils.indexOfIgnoreCase((CharSequence)typeName, (CharSequence)"LONG VARBINARY") != -1) {
                return MEDIUMBLOB;
            }
            if (StringUtils.indexOfIgnoreCase((CharSequence)typeName, (CharSequence)"MEDIUMTEXT") != -1 || StringUtils.indexOfIgnoreCase((CharSequence)typeName, (CharSequence)"LONG VARCHAR") != -1 || StringUtils.indexOfIgnoreCase((CharSequence)typeName, (CharSequence)"LONG") != -1) {
                return MEDIUMTEXT;
            }
            if (StringUtils.indexOfIgnoreCase((CharSequence)typeName, (CharSequence)"VARCHAR") != -1 || StringUtils.indexOfIgnoreCase((CharSequence)typeName, (CharSequence)"NVARCHAR") != -1 || StringUtils.indexOfIgnoreCase((CharSequence)typeName, (CharSequence)"NATIONAL VARCHAR") != -1 || StringUtils.indexOfIgnoreCase((CharSequence)typeName, (CharSequence)"CHARACTER VARYING") != -1) {
                return VARCHAR;
            }
            if (StringUtils.indexOfIgnoreCase((CharSequence)typeName, (CharSequence)"VARBINARY") != -1) {
                return VARBINARY;
            }
            if (StringUtils.indexOfIgnoreCase((CharSequence)typeName, (CharSequence)"BINARY") != -1 || StringUtils.indexOfIgnoreCase((CharSequence)typeName, (CharSequence)"CHAR BYTE") != -1) {
                return BINARY;
            }
            if (StringUtils.indexOfIgnoreCase((CharSequence)typeName, (CharSequence)"LINESTRING") != -1) {
                return GEOMETRY;
            }
            if (StringUtils.indexOfIgnoreCase((CharSequence)typeName, (CharSequence)"STRING") != -1 || StringUtils.indexOfIgnoreCase((CharSequence)typeName, (CharSequence)"CHAR") != -1 || StringUtils.indexOfIgnoreCase((CharSequence)typeName, (CharSequence)"NCHAR") != -1 || StringUtils.indexOfIgnoreCase((CharSequence)typeName, (CharSequence)"NATIONAL CHAR") != -1 || StringUtils.indexOfIgnoreCase((CharSequence)typeName, (CharSequence)"CHARACTER") != -1) {
                return CHAR;
            }
            if (StringUtils.indexOfIgnoreCase((CharSequence)typeName, (CharSequence)"BOOLEAN") != -1 || StringUtils.indexOfIgnoreCase((CharSequence)typeName, (CharSequence)"BOOL") != -1) {
                return BOOLEAN;
            }
            if (StringUtils.indexOfIgnoreCase((CharSequence)typeName, (CharSequence)"BIT") != -1) {
                return BIT;
            }
            if (StringUtils.indexOfIgnoreCase((CharSequence)typeName, (CharSequence)"JSON") != -1) {
                return JSON;
            }
            if (StringUtils.indexOfIgnoreCase((CharSequence)typeName, (CharSequence)"ENUM") != -1) {
                return ENUM;
            }
            if (StringUtils.indexOfIgnoreCase((CharSequence)typeName, (CharSequence)"SET") != -1) {
                return SET;
            }
            if (StringUtils.indexOfIgnoreCase((CharSequence)typeName, (CharSequence)"BLOB") != -1) {
                return BLOB;
            }
            if (StringUtils.indexOfIgnoreCase((CharSequence)typeName, (CharSequence)"TEXT") != -1) {
                return TEXT;
            }
            if (StringUtils.indexOfIgnoreCase((CharSequence)typeName, (CharSequence)"GEOM") != -1 || StringUtils.indexOfIgnoreCase((CharSequence)typeName, (CharSequence)"POINT") != -1 || StringUtils.indexOfIgnoreCase((CharSequence)typeName, (CharSequence)"POLYGON") != -1) {
                return GEOMETRY;
            }
        }
        return UNKNOWN;
    }

    @Override
    public String getVendor() {
        return "com.oceanbase";
    }

    @Override
    public Integer getVendorTypeNumber() {
        return this.jdbcType;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

