/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.meta;

import com.pingcap.tidb.tipb.Aggregation;
import com.pingcap.tidb.tipb.ByItem;
import com.pingcap.tidb.tipb.ColumnInfo;
import com.pingcap.tidb.tipb.DAGRequest;
import com.pingcap.tidb.tipb.EncodeType;
import com.pingcap.tidb.tipb.ExecType;
import com.pingcap.tidb.tipb.Executor;
import com.pingcap.tidb.tipb.IndexScan;
import com.pingcap.tidb.tipb.Limit;
import com.pingcap.tidb.tipb.Selection;
import com.pingcap.tidb.tipb.TableScan;
import com.pingcap.tidb.tipb.TopN;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.tikv.common.codec.KeyUtils;
import org.tikv.common.exception.DAGRequestException;
import org.tikv.common.exception.TiClientInternalException;
import org.tikv.common.expression.AggregateFunction;
import org.tikv.common.expression.ColumnRef;
import org.tikv.common.expression.Expression;
import org.tikv.common.expression.visitor.ProtoConverter;
import org.tikv.common.key.RowKey;
import org.tikv.common.meta.TiColumnInfo;
import org.tikv.common.meta.TiIndexColumn;
import org.tikv.common.meta.TiIndexInfo;
import org.tikv.common.meta.TiPartitionDef;
import org.tikv.common.meta.TiTableInfo;
import org.tikv.common.meta.TiTimestamp;
import org.tikv.common.predicates.PredicateUtils;
import org.tikv.common.region.TiStoreType;
import org.tikv.common.types.DataType;
import org.tikv.common.types.IntegerType;
import org.tikv.common.util.KeyRangeUtils;
import org.tikv.kvproto.Coprocessor;
import org.tikv.shade.com.google.common.annotations.VisibleForTesting;
import org.tikv.shade.com.google.common.base.Joiner;
import org.tikv.shade.com.google.common.base.Preconditions;
import org.tikv.shade.com.google.common.collect.ImmutableList;
import org.tikv.shade.com.google.common.collect.ImmutableMap;

public class TiDAGRequest
implements Serializable {
    private static final Map<ExecType, Integer> EXEC_TYPE_PRIORITY_MAP = ImmutableMap.builder().put(ExecType.TypeTableScan, 0).put(ExecType.TypeIndexScan, 0).put(ExecType.TypeSelection, 1).put(ExecType.TypeAggregation, 2).put(ExecType.TypeTopN, 3).put(ExecType.TypeLimit, 4).build();
    private static final ColumnInfo handleColumn = ColumnInfo.newBuilder().setColumnId(-1L).setPkHandle(true).setTp(8).setColumnLen(20).setFlag(2).build();
    private final List<ColumnRef> fields = new ArrayList<ColumnRef>();
    private final List<DataType> indexDataTypes = new ArrayList<DataType>();
    private final List<Expression> filters = new ArrayList<Expression>();
    private final List<org.tikv.common.expression.ByItem> groupByItems = new ArrayList<org.tikv.common.expression.ByItem>();
    private final List<org.tikv.common.expression.ByItem> orderByItems = new ArrayList<org.tikv.common.expression.ByItem>();
    private final List<AggregateFunction> aggregates = new ArrayList<AggregateFunction>();
    private final Map<Long, List<Coprocessor.KeyRange>> idToRanges = new HashMap<Long, List<Coprocessor.KeyRange>>();
    private final List<Expression> downgradeFilters = new ArrayList<Expression>();
    private final List<Expression> pushDownFilters = new ArrayList<Expression>();
    private final List<AggregateFunction> pushDownAggregates = new ArrayList<AggregateFunction>();
    private final List<org.tikv.common.expression.ByItem> pushDownGroupBys = new ArrayList<org.tikv.common.expression.ByItem>();
    private final List<org.tikv.common.expression.ByItem> pushDownOrderBys = new ArrayList<org.tikv.common.expression.ByItem>();
    private final PushDownType pushDownType;
    private TiTableInfo tableInfo;
    private List<TiPartitionDef> prunedParts;
    private TiStoreType storeType = TiStoreType.TiKV;
    private TiIndexInfo indexInfo;
    private List<Long> prunedPhysicalIds = new ArrayList<Long>();
    private final Map<Long, String> prunedPartNames = new HashMap<Long, String>();
    private long physicalId;
    private int pushDownLimits;
    private int limit;
    private int timeZoneOffset;
    private long flags;
    private TiTimestamp startTs;
    private Expression having;
    private boolean distinct;
    private boolean isDoubleRead;
    private EncodeType encodeType;
    private double estimatedCount = -1.0;

    public TiDAGRequest(PushDownType pushDownType) {
        this.pushDownType = pushDownType;
        this.encodeType = EncodeType.TypeDefault;
    }

    private TiDAGRequest(PushDownType pushDownType, EncodeType encodeType) {
        this.pushDownType = pushDownType;
        this.encodeType = encodeType;
    }

    public TiDAGRequest(PushDownType pushDownType, EncodeType encodeType, int timeZoneOffset) {
        this(pushDownType, encodeType);
        this.timeZoneOffset = timeZoneOffset;
    }

    public TiDAGRequest(PushDownType pushDownType, int timeZoneOffset) {
        this(pushDownType, EncodeType.TypeDefault);
        this.timeZoneOffset = timeZoneOffset;
    }

    public List<TiPartitionDef> getPrunedParts() {
        return this.prunedParts;
    }

    private String getPrunedPartName(long id) {
        return this.prunedPartNames.getOrDefault(id, "unknown");
    }

    public void setPrunedParts(List<TiPartitionDef> prunedParts) {
        this.prunedParts = prunedParts;
        if (prunedParts != null) {
            ArrayList<Long> ids = new ArrayList<Long>();
            this.prunedPartNames.clear();
            for (TiPartitionDef pDef : prunedParts) {
                ids.add(pDef.getId());
                this.prunedPartNames.put(pDef.getId(), pDef.getName());
            }
            this.prunedPhysicalIds = ids;
        }
    }

    public List<Long> getPrunedPhysicalIds() {
        if (!this.tableInfo.isPartitionEnabled()) {
            this.prunedPhysicalIds = ImmutableList.of(Long.valueOf(this.tableInfo.getId()));
            return this.prunedPhysicalIds;
        }
        return this.prunedPhysicalIds;
    }

    public TiStoreType getStoreType() {
        return this.storeType;
    }

    public void setStoreType(TiStoreType storeType) {
        this.storeType = storeType;
    }

    public EncodeType getEncodeType() {
        return this.encodeType;
    }

    public void setEncodeType(EncodeType encodeType) {
        this.encodeType = encodeType;
    }

    public DAGRequest buildIndexScan() {
        ArrayList<Integer> outputOffsets = new ArrayList<Integer>();
        DAGRequest.Builder builder = this.buildScan(true, outputOffsets);
        return this.buildRequest(builder, outputOffsets);
    }

    public DAGRequest buildTableScan() {
        ArrayList<Integer> outputOffsets = new ArrayList<Integer>();
        boolean isCoveringIndex = this.isCoveringIndexScan();
        DAGRequest.Builder builder = this.buildScan(isCoveringIndex, outputOffsets);
        return this.buildRequest(builder, outputOffsets);
    }

    private DAGRequest buildRequest(DAGRequest.Builder dagRequestBuilder, List<Integer> outputOffsets) {
        Preconditions.checkNotNull(this.startTs, "startTs is null");
        Preconditions.checkArgument(this.startTs.getVersion() != 0L, "timestamp is 0");
        DAGRequest request = dagRequestBuilder.setTimeZoneOffset(this.timeZoneOffset).setFlags(this.flags).addAllOutputOffsets(outputOffsets).setEncodeType(this.encodeType).setStartTsFallback(this.startTs.getVersion()).build();
        this.validateRequest(request);
        return request;
    }

    private DAGRequest.Builder buildScan(boolean buildIndexScan, List<Integer> outputOffsets) {
        long id = this.getPhysicalId();
        Preconditions.checkNotNull(this.startTs, "startTs is null");
        Preconditions.checkArgument(this.startTs.getVersion() != 0L, "timestamp is 0");
        this.clearPushDownInfo();
        DAGRequest.Builder dagRequestBuilder = DAGRequest.newBuilder();
        Executor.Builder executorBuilder = Executor.newBuilder();
        IndexScan.Builder indexScanBuilder = IndexScan.newBuilder();
        TableScan.Builder tblScanBuilder = TableScan.newBuilder();
        HashMap<String, Integer> colOffsetInFieldMap = new HashMap<String, Integer>();
        HashMap<String, Integer> colPosInIndexMap = new HashMap<String, Integer>();
        if (buildIndexScan) {
            if (this.indexInfo == null) {
                throw new TiClientInternalException("Index is empty for index scan");
            }
            List<TiColumnInfo> columnInfoList = this.tableInfo.getColumns();
            boolean hasPk = false;
            List indexColOffsets = this.indexInfo.getIndexColumns().stream().map(TiIndexColumn::getOffset).collect(Collectors.toList());
            int idxPos = 0;
            for (Object idx : indexColOffsets) {
                TiColumnInfo tiColumnInfo = columnInfoList.get((Integer)idx);
                ColumnInfo columnInfo = tiColumnInfo.toProto(this.tableInfo);
                colPosInIndexMap.put(tiColumnInfo.getName(), idxPos++);
                ColumnInfo.Builder colBuilder = ColumnInfo.newBuilder(columnInfo);
                if (columnInfo.getColumnId() == -1L) {
                    hasPk = true;
                    colBuilder.setPkHandle(true);
                }
                indexScanBuilder.addColumns(colBuilder);
            }
            int colCount = indexScanBuilder.getColumnsCount();
            if (this.isDoubleRead()) {
                for (ColumnRef col : this.getFields()) {
                    TiColumnInfo columnInfo;
                    Integer pos = (Integer)colPosInIndexMap.get(col.getName());
                    if (pos == null || !col.matchName((columnInfo = columnInfoList.get((Integer)indexColOffsets.get(pos))).getName())) continue;
                    colOffsetInFieldMap.put(col.getName(), pos);
                }
                if (!hasPk) {
                    indexScanBuilder.addColumns(handleColumn);
                    ++colCount;
                    this.addRequiredIndexDataType();
                }
                if (colCount == 0) {
                    throw new DAGRequestException("Incorrect index scan with zero column count");
                }
                outputOffsets.add(colCount - 1);
            } else {
                boolean pkIsNeeded = false;
                for (ColumnRef col : this.getFields()) {
                    Integer pos = (Integer)colPosInIndexMap.get(col.getName());
                    if (pos != null) {
                        TiColumnInfo columnInfo = columnInfoList.get((Integer)indexColOffsets.get(pos));
                        if (!col.matchName(columnInfo.getName())) continue;
                        outputOffsets.add(pos);
                        colOffsetInFieldMap.put(col.getName(), pos);
                        continue;
                    }
                    if (this.tableInfo.getColumn(col.getName()).isPrimaryKey()) {
                        pkIsNeeded = true;
                        outputOffsets.add(colCount);
                        colOffsetInFieldMap.put(col.getName(), indexColOffsets.size());
                        continue;
                    }
                    throw new DAGRequestException("columns other than primary key and index key exist in fields while index single read: " + col.getName());
                }
                if (pkIsNeeded) {
                    indexScanBuilder.addColumns(handleColumn);
                }
            }
            executorBuilder.setTp(ExecType.TypeIndexScan);
            indexScanBuilder.setTableId(id).setIndexId(this.indexInfo.getId());
            dagRequestBuilder.addExecutors(executorBuilder.setIdxScan(indexScanBuilder).build());
        } else {
            executorBuilder.setTp(ExecType.TypeTableScan);
            tblScanBuilder.setTableId(id);
            int lastOffset = 0;
            for (ColumnRef col : this.getFields()) {
                if (!colOffsetInFieldMap.containsKey(col.getName())) {
                    tblScanBuilder.addColumns(this.tableInfo.getColumn(col.getName()).toProto(this.tableInfo));
                    colOffsetInFieldMap.put(col.getName(), lastOffset);
                    ++lastOffset;
                }
                outputOffsets.add((Integer)colOffsetInFieldMap.get(col.getName()));
            }
            dagRequestBuilder.addExecutors(executorBuilder.setTblScan(tblScanBuilder));
        }
        boolean isIndexDoubleScan = buildIndexScan && this.isDoubleRead();
        executorBuilder.clear();
        Expression whereExpr = PredicateUtils.mergeCNFExpressions(this.getFilters());
        if (whereExpr != null) {
            if (!isIndexDoubleScan || this.isExpressionCoveredByIndex(whereExpr)) {
                executorBuilder.setTp(ExecType.TypeSelection);
                dagRequestBuilder.addExecutors(executorBuilder.setSelection(Selection.newBuilder().addConditions(ProtoConverter.toProto(whereExpr, colOffsetInFieldMap))));
                executorBuilder.clear();
                this.addPushDownFilters();
            } else {
                return dagRequestBuilder;
            }
        }
        if (!this.getGroupByItems().isEmpty() || !this.getAggregates().isEmpty()) {
            if (!isIndexDoubleScan || this.isGroupByCoveredByIndex() && this.isAggregateCoveredByIndex()) {
                this.pushDownAggAndGroupBy(dagRequestBuilder, executorBuilder, outputOffsets, colOffsetInFieldMap);
            } else {
                return dagRequestBuilder;
            }
        }
        if (!this.getOrderByItems().isEmpty()) {
            if (!isIndexDoubleScan || this.isOrderByCoveredByIndex()) {
                this.pushDownOrderBy(dagRequestBuilder, executorBuilder, colOffsetInFieldMap);
            }
        } else if (this.getLimit() != 0 && !isIndexDoubleScan) {
            this.pushDownLimit(dagRequestBuilder, executorBuilder);
        }
        return dagRequestBuilder;
    }

    private void pushDownLimit(DAGRequest.Builder dagRequestBuilder, Executor.Builder executorBuilder) {
        Limit.Builder limitBuilder = Limit.newBuilder();
        limitBuilder.setLimit(this.getLimit());
        executorBuilder.setTp(ExecType.TypeLimit);
        dagRequestBuilder.addExecutors(executorBuilder.setLimit(limitBuilder));
        executorBuilder.clear();
        this.addPushDownLimits();
    }

    private void pushDownOrderBy(DAGRequest.Builder dagRequestBuilder, Executor.Builder executorBuilder, Map<String, Integer> colOffsetInFieldMap) {
        TopN.Builder topNBuilder = TopN.newBuilder();
        this.getOrderByItems().forEach(tiByItem -> topNBuilder.addOrderBy(ByItem.newBuilder().setExpr(ProtoConverter.toProto(tiByItem.getExpr(), colOffsetInFieldMap)).setDesc(tiByItem.isDesc())));
        executorBuilder.setTp(ExecType.TypeTopN);
        topNBuilder.setLimit(this.getLimit());
        dagRequestBuilder.addExecutors(executorBuilder.setTopN(topNBuilder));
        executorBuilder.clear();
        this.addPushDownOrderBys();
    }

    private void pushDownAggAndGroupBy(DAGRequest.Builder dagRequestBuilder, Executor.Builder executorBuilder, List<Integer> outputOffsets, Map<String, Integer> colOffsetInFieldMap) {
        Aggregation.Builder aggregationBuilder = Aggregation.newBuilder();
        this.getAggregates().forEach(tiExpr -> aggregationBuilder.addAggFunc(ProtoConverter.toProto(tiExpr, colOffsetInFieldMap)));
        this.getGroupByItems().forEach(tiByItem -> aggregationBuilder.addGroupBy(ProtoConverter.toProto(tiByItem.getExpr(), colOffsetInFieldMap)));
        executorBuilder.setTp(ExecType.TypeAggregation);
        dagRequestBuilder.addExecutors(executorBuilder.setAggregation(aggregationBuilder));
        executorBuilder.clear();
        this.addPushDownGroupBys();
        this.addPushDownAggregates();
        outputOffsets.clear();
        for (int i = 0; i < this.getAggregates().size(); ++i) {
            outputOffsets.add(i);
        }
        int currentMaxOutputOffset = outputOffsets.get(outputOffsets.size() - 1) + 1;
        for (int i = 0; i < this.getGroupByItems().size(); ++i) {
            outputOffsets.add(currentMaxOutputOffset + i);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isExpressionCoveredByIndex(Expression expr) {
        Set indexColumnRefSet = this.indexInfo.getIndexColumns().stream().filter(x -> !x.isPrefixIndex()).map(TiIndexColumn::getName).collect(Collectors.toSet());
        if (this.isDoubleRead()) return false;
        if (!PredicateUtils.extractColumnRefFromExpression(expr).stream().map(ColumnRef::getName).allMatch(indexColumnRefSet::contains)) return false;
        return true;
    }

    private boolean isGroupByCoveredByIndex() {
        return this.isByItemCoveredByIndex(this.getGroupByItems());
    }

    private boolean isOrderByCoveredByIndex() {
        return this.isByItemCoveredByIndex(this.getOrderByItems());
    }

    private boolean isByItemCoveredByIndex(List<org.tikv.common.expression.ByItem> byItems) {
        if (byItems.isEmpty()) {
            return false;
        }
        return byItems.stream().allMatch(x -> this.isExpressionCoveredByIndex(x.getExpr()));
    }

    private boolean isAggregateCoveredByIndex() {
        if (this.aggregates.isEmpty()) {
            return false;
        }
        return this.aggregates.stream().allMatch(this::isExpressionCoveredByIndex);
    }

    private void validateRequest(DAGRequest dagRequest) {
        Objects.requireNonNull(dagRequest);
        Objects.requireNonNull(dagRequest.getEncodeType());
        if (dagRequest.getExecutorsCount() < 1) {
            throw new DAGRequestException("Invalid executors count:" + dagRequest.getExecutorsCount());
        }
        ExecType formerType = dagRequest.getExecutors(0).getTp();
        if (formerType != ExecType.TypeTableScan && formerType != ExecType.TypeIndexScan) {
            throw new DAGRequestException("Invalid first executor type:" + formerType + ", must one of TypeTableScan or TypeIndexScan");
        }
        for (int i = 1; i < dagRequest.getExecutorsCount(); ++i) {
            ExecType currentType = dagRequest.getExecutors(i).getTp();
            if (EXEC_TYPE_PRIORITY_MAP.get(currentType) < EXEC_TYPE_PRIORITY_MAP.get(formerType)) {
                throw new DAGRequestException("Invalid executor priority.");
            }
            formerType = currentType;
        }
    }

    public TiTableInfo getTableInfo() {
        return this.tableInfo;
    }

    public TiDAGRequest setTableInfo(TiTableInfo tableInfo) {
        this.tableInfo = Objects.requireNonNull(tableInfo, "tableInfo is null");
        this.setPhysicalId(tableInfo.getId());
        return this;
    }

    public long getPhysicalId() {
        return this.physicalId;
    }

    public TiDAGRequest setPhysicalId(long id) {
        this.physicalId = id;
        return this;
    }

    public TiIndexInfo getIndexInfo() {
        return this.indexInfo;
    }

    public TiDAGRequest setIndexInfo(TiIndexInfo indexInfo) {
        this.indexInfo = Objects.requireNonNull(indexInfo, "indexInfo is null");
        return this;
    }

    public void clearIndexInfo() {
        this.indexInfo = null;
        this.clearPushDownInfo();
    }

    public int getLimit() {
        return this.limit;
    }

    public TiDAGRequest setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    int getTimeZoneOffset() {
        return this.timeZoneOffset;
    }

    TiDAGRequest setTruncateMode(TruncateMode mode) {
        this.flags = Objects.requireNonNull(mode, "mode is null").mask(this.flags);
        return this;
    }

    @VisibleForTesting
    long getFlags() {
        return this.flags;
    }

    @VisibleForTesting
    public TiTimestamp getStartTs() {
        return this.startTs;
    }

    public TiDAGRequest setStartTs(@Nonnull TiTimestamp startTs) {
        this.startTs = startTs;
        return this;
    }

    public TiDAGRequest setHaving(Expression having) {
        this.having = Objects.requireNonNull(having, "having is null");
        return this;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public TiDAGRequest setDistinct(boolean distinct) {
        this.distinct = distinct;
        return this;
    }

    public TiDAGRequest addAggregate(AggregateFunction expr) {
        Objects.requireNonNull(expr, "aggregation expr is null");
        this.aggregates.add(expr);
        return this;
    }

    List<AggregateFunction> getAggregates() {
        return this.aggregates;
    }

    public TiDAGRequest addOrderByItem(org.tikv.common.expression.ByItem byItem) {
        this.orderByItems.add(Objects.requireNonNull(byItem, "byItem is null"));
        return this;
    }

    List<org.tikv.common.expression.ByItem> getOrderByItems() {
        return this.orderByItems;
    }

    public TiDAGRequest addGroupByItem(org.tikv.common.expression.ByItem byItem) {
        this.groupByItems.add(Objects.requireNonNull(byItem, "byItem is null"));
        return this;
    }

    public List<org.tikv.common.expression.ByItem> getGroupByItems() {
        return this.groupByItems;
    }

    public TiDAGRequest addRequiredColumn(ColumnRef column) {
        if (!column.isResolved()) {
            throw new UnsupportedOperationException(String.format("cannot add unresolved column %s to dag request", column.getName()));
        }
        this.fields.add(Objects.requireNonNull(column, "columnRef is null"));
        return this;
    }

    public List<ColumnRef> getFields() {
        return this.fields;
    }

    private void addRequiredIndexDataType() {
        this.indexDataTypes.add(Objects.requireNonNull(IntegerType.BIGINT, "dataType is null"));
    }

    public List<DataType> getIndexDataTypes() {
        return this.indexDataTypes;
    }

    public TiDAGRequest addRanges(Map<Long, List<Coprocessor.KeyRange>> ranges) {
        this.idToRanges.putAll(Objects.requireNonNull(ranges, "KeyRange is null"));
        return this;
    }

    private void resetRanges() {
        this.idToRanges.clear();
    }

    public void resetFilters(List<Expression> filters) {
        this.filters.clear();
        this.filters.addAll(filters);
    }

    public List<Coprocessor.KeyRange> getRangesByPhysicalId(long physicalId) {
        return this.idToRanges.get(physicalId);
    }

    public Map<Long, List<Coprocessor.KeyRange>> getRangesMaps() {
        return this.idToRanges;
    }

    public TiDAGRequest addFilters(List<Expression> filters) {
        this.filters.addAll((Collection<Expression>)Objects.requireNonNull(filters, "filters expr is null"));
        return this;
    }

    public List<Expression> getFilters() {
        return this.filters;
    }

    public void addDowngradeFilter(Expression filter) {
        this.downgradeFilters.add(Objects.requireNonNull(filter, "downgrade filter is null"));
    }

    public List<Expression> getDowngradeFilters() {
        return this.downgradeFilters;
    }

    private void addPushDownFilters() {
        this.pushDownFilters.addAll(this.filters);
    }

    private List<Expression> getPushDownFilters() {
        return this.pushDownFilters;
    }

    private void addPushDownAggregates() {
        this.pushDownAggregates.addAll(this.aggregates);
    }

    public List<AggregateFunction> getPushDownAggregates() {
        return this.pushDownAggregates;
    }

    private void addPushDownGroupBys() {
        this.pushDownGroupBys.addAll(this.getGroupByItems());
    }

    public List<org.tikv.common.expression.ByItem> getPushDownGroupBys() {
        return this.pushDownGroupBys;
    }

    private void addPushDownOrderBys() {
        this.pushDownOrderBys.addAll(this.getOrderByItems());
    }

    public List<org.tikv.common.expression.ByItem> getPushDownOrderBys() {
        return this.pushDownOrderBys;
    }

    private void addPushDownLimits() {
        this.pushDownLimits = this.limit;
    }

    private int getPushDownLimits() {
        return this.pushDownLimits;
    }

    private void clearPushDownInfo() {
        this.indexDataTypes.clear();
        this.pushDownFilters.clear();
        this.pushDownAggregates.clear();
        this.pushDownGroupBys.clear();
        this.pushDownOrderBys.clear();
        this.pushDownLimits = 0;
    }

    public boolean hasPushDownAggregate() {
        return !this.getPushDownAggregates().isEmpty();
    }

    public boolean hasPushDownGroupBy() {
        return !this.getPushDownGroupBys().isEmpty();
    }

    public boolean isDoubleRead() {
        return this.isDoubleRead;
    }

    public void setIsDoubleRead(boolean isDoubleRead) {
        this.isDoubleRead = isDoubleRead;
    }

    private boolean isCoveringIndexScan() {
        return this.hasIndex() && !this.isDoubleRead();
    }

    public boolean hasIndex() {
        return this.indexInfo != null;
    }

    public PushDownType getPushDownType() {
        return this.pushDownType;
    }

    public double getEstimatedCount() {
        return this.estimatedCount;
    }

    public void setEstimatedCount(double estimatedCount) {
        this.estimatedCount = estimatedCount;
    }

    public void init(boolean readHandle) {
        if (readHandle) {
            this.buildIndexScan();
        } else {
            this.buildTableScan();
        }
    }

    private void init() {
        this.init(this.hasIndex());
    }

    public IndexScanType getIndexScanType() {
        if (this.hasIndex()) {
            if (this.isDoubleRead) {
                return IndexScanType.INDEX_SCAN;
            }
            return IndexScanType.COVERING_INDEX_SCAN;
        }
        return IndexScanType.TABLE_SCAN;
    }

    public String toString() {
        this.init();
        StringBuilder sb = new StringBuilder();
        if (this.tableInfo != null) {
            sb.append(String.format("[table: %s] ", this.tableInfo.getName()));
        }
        boolean isIndexScan = false;
        switch (this.getIndexScanType()) {
            case INDEX_SCAN: {
                sb.append("IndexScan");
                sb.append(String.format("[Index: %s] ", this.indexInfo.getName()));
                isIndexScan = true;
                break;
            }
            case COVERING_INDEX_SCAN: {
                sb.append("CoveringIndexScan");
                sb.append(String.format("[Index: %s] ", this.indexInfo.getName()));
                break;
            }
            case TABLE_SCAN: {
                sb.append("TableScan");
            }
        }
        if (!this.getFields().isEmpty()) {
            sb.append(", Columns: ");
            Joiner.on(", ").skipNulls().appendTo(sb, (Iterable<?>)this.getFields());
        }
        if (isIndexScan && !this.getDowngradeFilters().isEmpty()) {
            sb.append(", Downgrade Filter: ");
            Joiner.on(", ").skipNulls().appendTo(sb, (Iterable<?>)this.getDowngradeFilters());
        }
        if (!isIndexScan && !this.getFilters().isEmpty()) {
            sb.append(", Residual Filter: ");
            Joiner.on(", ").skipNulls().appendTo(sb, (Iterable<?>)this.getFilters());
        }
        if (!this.getPushDownFilters().isEmpty()) {
            sb.append(", PushDown Filter: ");
            Joiner.on(", ").skipNulls().appendTo(sb, (Iterable<?>)this.getPushDownFilters());
        }
        if (!this.getRangesMaps().isEmpty()) {
            sb.append(", KeyRange: [");
            if (this.tableInfo.isPartitionEnabled()) {
                this.getRangesMaps().forEach((key, value) -> {
                    for (Coprocessor.KeyRange v : value) {
                        sb.append(" partition: ").append(this.getPrunedPartName((long)key));
                        sb.append(KeyUtils.formatBytesUTF8(v));
                    }
                });
            } else {
                this.getRangesMaps().values().forEach(vList -> {
                    for (Coprocessor.KeyRange range : vList) {
                        sb.append(KeyUtils.formatBytesUTF8(range));
                    }
                });
            }
            sb.append("]");
        }
        if (!this.getPushDownFilters().isEmpty()) {
            sb.append(", Aggregates: ");
            Joiner.on(", ").skipNulls().appendTo(sb, (Iterable<?>)this.getPushDownAggregates());
        }
        if (!this.getGroupByItems().isEmpty()) {
            sb.append(", Group By: ");
            Joiner.on(", ").skipNulls().appendTo(sb, (Iterable<?>)this.getGroupByItems());
        }
        if (!this.getOrderByItems().isEmpty()) {
            sb.append(", Order By: ");
            Joiner.on(", ").skipNulls().appendTo(sb, (Iterable<?>)this.getOrderByItems());
        }
        if (this.getLimit() != 0) {
            sb.append(", Limit: ");
            sb.append("[").append(this.limit).append("]");
        }
        sb.append(", startTs: ").append(this.startTs.getVersion());
        return sb.toString();
    }

    public TiDAGRequest copy() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bais);
            return (TiDAGRequest)ois.readObject();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public TiDAGRequest copyReqWithPhysicalId(long id) {
        TiDAGRequest req = this.copy();
        req.setPhysicalId(id);
        List<Coprocessor.KeyRange> currentIdRange = req.getRangesByPhysicalId(id);
        req.resetRanges();
        HashMap<Long, List<Coprocessor.KeyRange>> rangeMap = new HashMap<Long, List<Coprocessor.KeyRange>>();
        rangeMap.put(id, currentIdRange);
        req.addRanges(rangeMap);
        return req;
    }

    public static class Builder {
        private final List<String> requiredCols = new ArrayList<String>();
        private final List<Expression> filters = new ArrayList<Expression>();
        private final List<org.tikv.common.expression.ByItem> orderBys = new ArrayList<org.tikv.common.expression.ByItem>();
        private final Map<Long, List<Coprocessor.KeyRange>> ranges = new HashMap<Long, List<Coprocessor.KeyRange>>();
        private TiTableInfo tableInfo;
        private long physicalId;
        private int limit;
        private TiTimestamp startTs;

        public static Builder newBuilder() {
            return new Builder();
        }

        public Builder setFullTableScan(TiTableInfo tableInfo) {
            Objects.requireNonNull(tableInfo);
            this.setTableInfo(tableInfo);
            if (!tableInfo.isPartitionEnabled()) {
                RowKey start = RowKey.createMin(tableInfo.getId());
                RowKey end = RowKey.createBeyondMax(tableInfo.getId());
                this.ranges.put(tableInfo.getId(), ImmutableList.of(KeyRangeUtils.makeCoprocRange(start.toByteString(), end.toByteString())));
            } else {
                for (TiPartitionDef pDef : tableInfo.getPartitionInfo().getDefs()) {
                    RowKey start = RowKey.createMin(pDef.getId());
                    RowKey end = RowKey.createBeyondMax(pDef.getId());
                    this.ranges.put(pDef.getId(), ImmutableList.of(KeyRangeUtils.makeCoprocRange(start.toByteString(), end.toByteString())));
                }
            }
            return this;
        }

        public Builder setLimit(int limit) {
            this.limit = limit;
            return this;
        }

        public Builder setTableInfo(TiTableInfo tableInfo) {
            this.tableInfo = tableInfo;
            this.setPhysicalId(tableInfo.getId());
            return this;
        }

        public Builder setPhysicalId(long id) {
            this.physicalId = id;
            return this;
        }

        public Builder addRequiredCols(List<String> cols) {
            this.requiredCols.addAll(cols);
            return this;
        }

        public Builder addFilter(Expression filter) {
            this.filters.add(filter);
            return this;
        }

        public Builder addOrderBy(org.tikv.common.expression.ByItem item) {
            this.orderBys.add(item);
            return this;
        }

        public Builder setStartTs(@Nonnull TiTimestamp ts) {
            this.startTs = ts;
            return this;
        }

        public TiDAGRequest build(PushDownType pushDownType) {
            TiDAGRequest req = new TiDAGRequest(pushDownType);
            req.setTableInfo(this.tableInfo);
            req.setPhysicalId(this.physicalId);
            req.addRanges(this.ranges);
            req.addFilters(this.filters);
            req.addPushDownFilters();
            if (!this.orderBys.isEmpty()) {
                this.orderBys.forEach(req::addOrderByItem);
            }
            if (this.limit != 0) {
                req.setLimit(this.limit);
            }
            this.requiredCols.forEach(c -> req.addRequiredColumn(ColumnRef.create(c, this.tableInfo.getColumn((String)c))));
            req.setStartTs(this.startTs);
            return req;
        }
    }

    public static enum IndexScanType {
        INDEX_SCAN,
        COVERING_INDEX_SCAN,
        TABLE_SCAN;

    }

    public static enum PushDownType {
        STREAMING,
        NORMAL;

    }

    public static enum TruncateMode {
        IgnoreTruncation(1L),
        TruncationAsWarning(2L);

        private final long mask;

        private TruncateMode(long mask) {
            this.mask = mask;
        }

        public long mask(long flags) {
            return flags | this.mask;
        }
    }
}

