/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.codec;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.tikv.common.Snapshot;
import org.tikv.common.codec.Codec;
import org.tikv.common.codec.CodecDataInput;
import org.tikv.common.codec.CodecDataOutput;
import org.tikv.common.codec.KeyUtils;
import org.tikv.common.exception.TiClientInternalException;
import org.tikv.common.util.Pair;
import org.tikv.kvproto.Kvrpcpb;
import org.tikv.shade.com.google.common.base.Preconditions;
import org.tikv.shade.com.google.protobuf.ByteString;

public class MetaCodec {
    public static final String ENCODED_DB_PREFIX = "DB";
    public static final String KEY_TID = "TID";
    private static final byte[] META_PREFIX = new byte[]{109};
    private static final byte HASH_DATA_FLAG = 104;
    private static final byte HASH_META_FLAG = 72;
    private static final byte STR_DATA_FLAG = 115;
    public static ByteString KEY_DBs = ByteString.copyFromUtf8("DBs");
    public static String KEY_TABLE = "Table";
    public static ByteString KEY_SCHEMA_VERSION = ByteString.copyFromUtf8("SchemaVersionKey");

    public static void encodeStringDataKey(CodecDataOutput cdo, byte[] key) {
        cdo.write(META_PREFIX);
        Codec.BytesCodec.writeBytes(cdo, key);
        Codec.IntegerCodec.writeULong(cdo, 115L);
    }

    public static void encodeHashDataKey(CodecDataOutput cdo, byte[] key, byte[] field) {
        cdo.write(META_PREFIX);
        Codec.BytesCodec.writeBytes(cdo, key);
        Codec.IntegerCodec.writeULong(cdo, 104L);
        Codec.BytesCodec.writeBytes(cdo, field);
    }

    public static ByteString encodeHashMetaKey(CodecDataOutput cdo, byte[] key) {
        cdo.write(META_PREFIX);
        Codec.BytesCodec.writeBytes(cdo, key);
        Codec.IntegerCodec.writeULong(cdo, 72L);
        return cdo.toByteString();
    }

    public static void encodeHashDataKeyPrefix(CodecDataOutput cdo, byte[] key) {
        cdo.write(META_PREFIX);
        Codec.BytesCodec.writeBytes(cdo, key);
        Codec.IntegerCodec.writeULong(cdo, 104L);
    }

    public static Pair<ByteString, ByteString> decodeHashDataKey(ByteString rawKey) {
        Preconditions.checkArgument(KeyUtils.hasPrefix(rawKey, ByteString.copyFrom(META_PREFIX)), "invalid encoded hash data key prefix: " + new String(META_PREFIX));
        CodecDataInput cdi = new CodecDataInput(rawKey.toByteArray());
        cdi.skipBytes(META_PREFIX.length);
        byte[] key = Codec.BytesCodec.readBytes(cdi);
        long typeFlag = Codec.IntegerCodec.readULong(cdi);
        if (typeFlag != 104L) {
            throw new TiClientInternalException("Invalid hash data flag: " + typeFlag);
        }
        byte[] field = Codec.BytesCodec.readBytes(cdi);
        return Pair.create(ByteString.copyFrom(key), ByteString.copyFrom(field));
    }

    public static ByteString autoTableIDKey(long tableId) {
        return ByteString.copyFrom(String.format("%s:%d", KEY_TID, tableId).getBytes());
    }

    public static ByteString tableKey(long tableId) {
        return ByteString.copyFrom(String.format("%s:%d", KEY_TABLE, tableId).getBytes());
    }

    public static ByteString encodeDatabaseID(long id) {
        return ByteString.copyFrom(String.format("%s:%d", ENCODED_DB_PREFIX, id).getBytes());
    }

    public static ByteString hashGet(ByteString key, ByteString field, Snapshot snapshot) {
        CodecDataOutput cdo = new CodecDataOutput();
        MetaCodec.encodeHashDataKey(cdo, key.toByteArray(), field.toByteArray());
        return snapshot.get(cdo.toByteString());
    }

    public static ByteString bytesGet(ByteString key, Snapshot snapshot) {
        CodecDataOutput cdo = new CodecDataOutput();
        MetaCodec.encodeStringDataKey(cdo, key.toByteArray());
        return snapshot.get(cdo.toByteString());
    }

    public static List<Pair<ByteString, ByteString>> hashGetFields(ByteString key, Snapshot snapshot) {
        CodecDataOutput cdo = new CodecDataOutput();
        MetaCodec.encodeHashDataKeyPrefix(cdo, key.toByteArray());
        ByteString encodedKey = cdo.toByteString();
        Iterator<Kvrpcpb.KvPair> iterator = snapshot.scanPrefix(encodedKey);
        ArrayList<Pair<ByteString, ByteString>> fields = new ArrayList<Pair<ByteString, ByteString>>();
        while (iterator.hasNext()) {
            Kvrpcpb.KvPair kv = iterator.next();
            if (kv == null || kv.getKey() == null) continue;
            fields.add(Pair.create(MetaCodec.decodeHashDataKey((ByteString)kv.getKey()).second, kv.getValue()));
        }
        return fields;
    }
}

