/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.source;

import java.math.BigInteger;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollationBasedSplitter {
    private static final Logger log = LoggerFactory.getLogger(CollationBasedSplitter.class);

    public static BigInteger encodeStringToNumericRange(String str, int maxLength, boolean paddingAtEnd, boolean isCaseInsensitive, String orderedCharset, int radix) {
        log.info("Converting string '{}' to BigInteger, maxLength={}, isCaseInsensitive={}", new Object[]{str, maxLength, isCaseInsensitive});
        String asciiString = CollationBasedSplitter.stringToAsciiString(str, maxLength, paddingAtEnd, isCaseInsensitive, orderedCharset);
        log.info("String converted to ASCII representation: {}", (Object)asciiString);
        int[] baseArray = CollationBasedSplitter.parseBaseNumber(asciiString);
        log.info("ASCII representation parsed to base array: {}", (Object)Arrays.toString(baseArray));
        BigInteger result = CollationBasedSplitter.toDecimal(baseArray, radix);
        log.info("Final BigInteger result: {}", (Object)result);
        return result;
    }

    public static String decodeNumericRangeToString(String bigInteger, int maxLength, int radix, String orderedCharset) {
        log.info("Converting BigInteger '{}' to string, maxLength={}, radix={}", new Object[]{bigInteger, maxLength, radix});
        int[] baseArray = CollationBasedSplitter.fromDecimal(new BigInteger(bigInteger), maxLength, radix);
        log.info("BigInteger converted to base array: {}", (Object)Arrays.toString(baseArray));
        String formattedNumber = CollationBasedSplitter.formatBaseNumber(baseArray);
        log.info("Base array formatted as number string: {}", (Object)formattedNumber);
        String result = CollationBasedSplitter.convertToAsciiString(formattedNumber, orderedCharset);
        log.info("Final string result: '{}'", (Object)result);
        return result;
    }

    private static int[] parseBaseNumber(String numberStr) {
        log.trace("Parsing base number from string: {}", (Object)numberStr);
        String[] parts = numberStr.split(" ");
        int[] result = new int[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            result[i] = Integer.parseInt(parts[i]);
        }
        log.trace("Parsed base number result: {}", (Object)Arrays.toString(result));
        return result;
    }

    private static String formatBaseNumber(int[] number) {
        log.trace("Formatting base number array: {}", (Object)Arrays.toString(number));
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < number.length; ++i) {
            if (i > 0) {
                sb.append(" ");
            }
            sb.append(String.format("%03d", number[i]));
        }
        String result = sb.toString();
        log.trace("Formatted base number: {}", (Object)result);
        return result;
    }

    private static int charToIndex(char c, String supportedChars) {
        int result = c == '\u0000' ? 0 : supportedChars.indexOf(c) + 1;
        log.trace("Char '{}' converted to index: {}", (Object)Character.valueOf(c), (Object)result);
        return result;
    }

    private static char indexToChar(int index, String supportedChars) {
        char result = index == 0 ? (char)'\u0001' : supportedChars.charAt(index - 1);
        log.trace("Index {} converted to char: '{}'", (Object)index, (Object)Character.valueOf(result));
        return result;
    }

    private static BigInteger toDecimal(int[] array, int radix) {
        log.trace("Converting array {} to decimal with charset size {}", (Object)Arrays.toString(array), (Object)radix);
        BigInteger result = BigInteger.ZERO;
        for (int i = 0; i < array.length; ++i) {
            BigInteger value = BigInteger.valueOf(array[i]);
            BigInteger multiplier = BigInteger.valueOf(radix).pow(array.length - 1 - i);
            result = result.add(value.multiply(multiplier));
        }
        log.trace("Decimal conversion result: {}", (Object)result);
        return result;
    }

    private static int[] fromDecimal(BigInteger decimal, int length, int base) {
        log.trace("Converting decimal {} to base {} array of length {}", new Object[]{decimal, base, length});
        int[] result = new int[length];
        BigInteger remainder = decimal;
        for (int i = length - 1; i >= 0; --i) {
            BigInteger divisor = BigInteger.valueOf(base).pow(i);
            int value = remainder.divide(divisor).intValue();
            remainder = remainder.mod(divisor);
            result[length - 1 - i] = value;
        }
        log.trace("Base conversion result: {}", (Object)Arrays.toString(result));
        return result;
    }

    private static String stringToAsciiString(String s2, int expectedLength, boolean paddingAtEnd, boolean isCaseInsensitive, String supportedChars) {
        int i;
        log.trace("Converting string '{}' to ASCII string, expectedLength={}, paddingAtEnd={}, isCaseInsensitive={}", new Object[]{s2, expectedLength, paddingAtEnd, isCaseInsensitive});
        String str = isCaseInsensitive ? s2.toLowerCase() : s2;
        char[] paddedChars = new char[expectedLength];
        if (paddingAtEnd) {
            for (int i2 = 0; i2 < expectedLength; ++i2) {
                paddedChars[i2] = i2 < str.length() ? str.charAt(i2) : (char)'\u0000';
            }
            log.trace("Applied suffix padding to string");
        } else {
            int offset = expectedLength - str.length();
            for (i = 0; i < expectedLength; ++i) {
                paddedChars[i] = i < offset ? (char)'\u0000' : str.charAt(i - offset);
            }
            log.trace("Applied prefix padding to string");
        }
        StringBuilder result = new StringBuilder();
        for (i = 0; i < paddedChars.length; ++i) {
            if (i > 0) {
                result.append(" ");
            }
            result.append(String.format("%03d", CollationBasedSplitter.charToIndex(paddedChars[i], supportedChars)));
        }
        String asciiResult = result.toString();
        log.trace("ASCII string conversion result: {}", (Object)asciiResult);
        return asciiResult;
    }

    private static String convertToAsciiString(String input, String supportedChars) {
        log.trace("Converting ASCII representation '{}' back to string", (Object)input);
        String[] asciiValues = input.split(" ");
        StringBuilder result = new StringBuilder();
        for (String value : asciiValues) {
            char c = CollationBasedSplitter.indexToChar(Integer.parseInt(value), supportedChars);
            result.append(c);
        }
        String resultString = result.toString();
        if (resultString.replaceAll("\u0001", "").isEmpty()) {
            log.trace("Detected all placeholder characters, returning empty string");
            return "";
        }
        log.trace("ASCII to string conversion result: '{}'", (Object)resultString);
        return resultString;
    }
}

