/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.hive;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import lombok.NonNull;
import org.apache.hadoop.conf.Configuration;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcConnectionConfig;
import org.apache.seatunnel.connectors.seatunnel.jdbc.exception.JdbcConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.jdbc.exception.JdbcConnectorException;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.connection.SimpleJdbcConnectionProvider;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.hive.HadoopLoginFactory;

public class HiveJdbcConnectionProvider
extends SimpleJdbcConnectionProvider {
    public HiveJdbcConnectionProvider(@NonNull JdbcConnectionConfig jdbcConfig) {
        super(jdbcConfig);
        if (jdbcConfig == null) {
            throw new NullPointerException("jdbcConfig is marked non-null but is null");
        }
    }

    @Override
    public Connection getOrEstablishConnection() throws SQLException, ClassNotFoundException {
        if (this.isConnectionValid()) {
            return super.getConnection();
        }
        JdbcConnectionConfig jdbcConfig = super.getJdbcConfig();
        Driver driver = this.getLoadedDriver();
        HiveConnectionProduceFunction hiveConnectionProduceFunction = new HiveConnectionProduceFunction(driver, jdbcConfig);
        if (jdbcConfig.isUseKerberos()) {
            super.setConnection(this.getConnectionWithKerberos(hiveConnectionProduceFunction));
        } else {
            super.setConnection(hiveConnectionProduceFunction.produce());
        }
        if (super.getConnection() == null) {
            throw new JdbcConnectorException((SeaTunnelErrorCode)JdbcConnectorErrorCode.NO_SUITABLE_DRIVER, "No suitable driver found for " + super.getJdbcConfig().getUrl());
        }
        return super.getConnection();
    }

    private Connection getConnectionWithKerberos(HiveConnectionProduceFunction hiveConnectionProduceFunction) {
        try {
            Configuration configuration = new Configuration();
            configuration.set("hadoop.security.authentication", "kerberos");
            return HadoopLoginFactory.loginWithKerberos(configuration, this.jdbcConfig.getKrb5Path(), this.jdbcConfig.getKerberosPrincipal(), this.jdbcConfig.getKerberosKeytabPath(), (conf, userGroupInformation) -> hiveConnectionProduceFunction.produce());
        }
        catch (Exception ex) {
            throw new JdbcConnectorException((SeaTunnelErrorCode)JdbcConnectorErrorCode.KERBEROS_AUTHENTICATION_FAILED, ex);
        }
    }

    public static class HiveConnectionProduceFunction {
        private final Driver driver;
        private final JdbcConnectionConfig jdbcConnectionConfig;

        public HiveConnectionProduceFunction(Driver driver, JdbcConnectionConfig jdbcConnectionConfig) {
            this.driver = driver;
            this.jdbcConnectionConfig = jdbcConnectionConfig;
        }

        public Connection produce() throws SQLException {
            Properties info = new Properties();
            this.jdbcConnectionConfig.getUsername().ifPresent(username -> info.setProperty("user", (String)username));
            this.jdbcConnectionConfig.getPassword().ifPresent(username -> info.setProperty("password", (String)username));
            return this.driver.connect(this.jdbcConnectionConfig.getUrl(), info);
        }
    }
}

