/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.sqlserver;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Optional;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.api.table.type.SqlType;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.jdbc.exception.JdbcConnectorException;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.converter.AbstractJdbcRowConverter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.utils.JdbcFieldTypeUtils;

public class SqlserverJdbcRowConverter
extends AbstractJdbcRowConverter {
    @Override
    public String converterName() {
        return "SqlServer";
    }

    @Override
    protected LocalTime readTime(ResultSet rs, int resultSetIndex) throws SQLException {
        Timestamp sqlTime = JdbcFieldTypeUtils.getTimestamp(rs, resultSetIndex);
        return Optional.ofNullable(sqlTime).map(e -> e.toLocalDateTime().toLocalTime()).orElse(null);
    }

    public PreparedStatement toExternal(SeaTunnelRowType rowType, SeaTunnelRow row, PreparedStatement statement) throws SQLException {
        block16: for (int fieldIndex = 0; fieldIndex < rowType.getTotalFields(); ++fieldIndex) {
            SeaTunnelDataType seaTunnelDataType = rowType.getFieldType(fieldIndex);
            int statementIndex = fieldIndex + 1;
            Object fieldValue = row.getField(fieldIndex);
            if (fieldValue == null && seaTunnelDataType.getSqlType() != SqlType.BYTES) {
                statement.setObject(statementIndex, null);
                continue;
            }
            switch (seaTunnelDataType.getSqlType()) {
                case STRING: {
                    statement.setString(statementIndex, (String)row.getField(fieldIndex));
                    continue block16;
                }
                case BOOLEAN: {
                    statement.setBoolean(statementIndex, (Boolean)row.getField(fieldIndex));
                    continue block16;
                }
                case TINYINT: {
                    statement.setByte(statementIndex, (Byte)row.getField(fieldIndex));
                    continue block16;
                }
                case SMALLINT: {
                    statement.setShort(statementIndex, (Short)row.getField(fieldIndex));
                    continue block16;
                }
                case INT: {
                    statement.setInt(statementIndex, (Integer)row.getField(fieldIndex));
                    continue block16;
                }
                case BIGINT: {
                    statement.setLong(statementIndex, (Long)row.getField(fieldIndex));
                    continue block16;
                }
                case FLOAT: {
                    statement.setFloat(statementIndex, ((Float)row.getField(fieldIndex)).floatValue());
                    continue block16;
                }
                case DOUBLE: {
                    statement.setDouble(statementIndex, (Double)row.getField(fieldIndex));
                    continue block16;
                }
                case DECIMAL: {
                    statement.setBigDecimal(statementIndex, (BigDecimal)row.getField(fieldIndex));
                    continue block16;
                }
                case DATE: {
                    LocalDate localDate = (LocalDate)row.getField(fieldIndex);
                    statement.setDate(statementIndex, Date.valueOf(localDate));
                    continue block16;
                }
                case TIME: {
                    LocalTime localTime = (LocalTime)row.getField(fieldIndex);
                    statement.setTime(statementIndex, Time.valueOf(localTime));
                    continue block16;
                }
                case TIMESTAMP: {
                    LocalDateTime localDateTime = (LocalDateTime)row.getField(fieldIndex);
                    statement.setTimestamp(statementIndex, Timestamp.valueOf(localDateTime));
                    continue block16;
                }
                case BYTES: {
                    if (row.getField(fieldIndex) == null) {
                        statement.setBytes(statementIndex, new byte[0]);
                        continue block16;
                    }
                    statement.setBytes(statementIndex, (byte[])row.getField(fieldIndex));
                    continue block16;
                }
                case NULL: {
                    statement.setNull(statementIndex, 0);
                    continue block16;
                }
                default: {
                    throw new JdbcConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_DATA_TYPE, "Unexpected value: " + seaTunnelDataType);
                }
            }
        }
        return statement;
    }
}

